/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibCommonsMath;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class MultiReturnBuiltinCPInstruction
extends ComputationCPInstruction {
    protected ArrayList<CPOperand> _outputs;

    private MultiReturnBuiltinCPInstruction(Operator op, CPOperand input1, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, null, outputs.get(0), opcode, istr);
        this._outputs = outputs;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public List<CPOperand> getOutputs() {
        return this._outputs;
    }

    public String[] getOutputNames() {
        return (String[])this._outputs.parallelStream().map(output -> output.getName()).toArray(String[]::new);
    }

    public static MultiReturnBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qr")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("lu")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("eigen")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("svd")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    public int getNumOutputs() {
        return this._outputs.size();
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in, this.getOpcode());
        ec.releaseMatrixInput(this.input1.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    @Override
    public boolean hasSingleLineage() {
        return false;
    }

    public Pair[] getLineageItems(ExecutionContext ec) {
        LineageItem[] inputLineage = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3);
        ArrayList<Pair> items = new ArrayList<Pair>();
        for (CPOperand out : this._outputs) {
            items.add(Pair.of((Object)out.getName(), (Object)new LineageItem(this.getOpcode(), inputLineage)));
        }
        return items.toArray(new Pair[items.size()]);
    }
}

