/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public abstract class ColGroupValue
extends ColGroupCompressed
implements Cloneable {
    private static final long serialVersionUID = 3786247536054353658L;
    private static ThreadLocal<Pair<int[], double[]>> memPool = new ThreadLocal<Pair<int[], double[]>>(){

        @Override
        protected Pair<int[], double[]> initialValue() {
            return null;
        }
    };
    protected boolean _zeros = false;
    protected ADictionary _dict;
    private int[] counts;
    private static boolean logMM = true;

    protected ColGroupValue(int numRows) {
        super(numRows);
    }

    protected ColGroupValue(int[] colIndices, int numRows, ADictionary dict, int[] cachedCounts) {
        super(colIndices, numRows);
        this._dict = dict;
        this.counts = cachedCounts;
    }

    @Override
    public final void decompressToBlockSafe(MatrixBlock target, int rl, int ru, int offT) {
        this.decompressToBlockUnSafe(target, rl, ru, offT);
        target.setNonZeros(this.getNumberNonZeros() + target.getNonZeros());
    }

    @Override
    public final void decompressToBlockUnSafe(MatrixBlock target, int rl, int ru, int offT) {
        if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary md = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isEmpty()) {
                return;
            }
            if (mb.isInSparseFormat()) {
                this.decompressToBlockUnSafeSparseDictionary(target, rl, ru, offT, mb.getSparseBlock());
            } else {
                this.decompressToBlockUnSafeDenseDictionary(target, rl, ru, offT, mb.getDenseBlockValues());
            }
        } else {
            this.decompressToBlockUnSafeDenseDictionary(target, rl, ru, offT, this._dict.getValues());
        }
    }

    protected abstract void decompressToBlockUnSafeSparseDictionary(MatrixBlock var1, int var2, int var3, int var4, SparseBlock var5);

    protected abstract void decompressToBlockUnSafeDenseDictionary(MatrixBlock var1, int var2, int var3, int var4, double[] var5);

    @Override
    public final int getNumValues() {
        return this._dict.getNumberOfValues(this._colIndexes.length);
    }

    @Override
    public final double[] getValues() {
        return this._dict != null ? this._dict.getValues() : null;
    }

    public final ADictionary getDictionary() {
        return this._dict;
    }

    @Override
    public final void addMinMax(double[] ret) {
        this._dict.addMaxAndMin(ret, this._colIndexes);
    }

    @Override
    public final MatrixBlock getValuesAsBlock() {
        this._dict = this._dict.getAsMatrixBlockDictionary(this._colIndexes.length);
        MatrixBlock ret = ((MatrixBlockDictionary)this._dict).getMatrixBlock();
        if (this._zeros) {
            MatrixBlock tmp = new MatrixBlock();
            ret.append(new MatrixBlock(1, this._colIndexes.length, 0L), tmp, false);
            return tmp;
        }
        return ret;
    }

    public final int[] getCounts() {
        if (this.counts == null && this._dict != null) {
            this.counts = this.getCounts(new int[this.getNumValues() + (this._zeros ? 1 : 0)]);
            return this.counts;
        }
        return this.counts;
    }

    public final int[] getCachedCounts() {
        return this.counts;
    }

    public final int[] getCounts(int rl, int ru) {
        int[] tmp = this._zeros ? ColGroupValue.allocIVector(this.getNumValues() + 1, true) : ColGroupValue.allocIVector(this.getNumValues(), true);
        return this.getCounts(rl, ru, tmp);
    }

    public boolean getIfCountsType() {
        return true;
    }

    protected final double sumValues(int valIx, double[] b, double[] dictVals) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        double val = 0.0;
        for (int i = 0; i < numCols; ++i) {
            val += dictVals[valOff + i] * b[this._colIndexes[i]];
        }
        return val;
    }

    protected final double sumValues(int valIx, double[] b, double[] dictVals, int off) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        double val = 0.0;
        for (int i = 0; i < numCols; ++i) {
            val += dictVals[valOff + i] * b[this._colIndexes[i] + off];
        }
        return val;
    }

    private int[] getAggregateColumnsSetDense(double[] b, int cl, int cu, int cut) {
        HashSet<Integer> aggregateColumnsSet = new HashSet<Integer>();
        int retCols = cu - cl;
        for (int k = 0; k < this._colIndexes.length; ++k) {
            int rowIdxOffset = this._colIndexes[k] * cut;
            for (int h = cl; h < cu; ++h) {
                double v = b[rowIdxOffset + h];
                if (v == 0.0) continue;
                aggregateColumnsSet.add(h);
            }
            if (aggregateColumnsSet.size() == retCols) break;
        }
        int[] aggregateColumns = aggregateColumnsSet.stream().mapToInt(x -> x).toArray();
        Arrays.sort(aggregateColumns);
        return aggregateColumns;
    }

    private int[] getAggregateColumnsSetSparse(SparseBlock b, int retCols) {
        HashSet<Integer> aggregateColumnsSet = new HashSet<Integer>();
        for (int h = 0; h < this._colIndexes.length; ++h) {
            int colIdx = this._colIndexes[h];
            if (!b.isEmpty(colIdx)) {
                int[] sIndexes = b.indexes(colIdx);
                for (int i = b.pos(colIdx); i < b.size(colIdx) + b.pos(colIdx); ++i) {
                    aggregateColumnsSet.add(sIndexes[i]);
                }
            }
            if (aggregateColumnsSet.size() == retCols) break;
        }
        int[] aggregateColumns = aggregateColumnsSet.stream().mapToInt(x -> x).toArray();
        Arrays.sort(aggregateColumns);
        return aggregateColumns;
    }

    private double[] preaggValuesFromSparse(int numVals, SparseBlock b, int[] aggregateColumns, int cl, int cu, int cut) {
        double[] ret = new double[numVals * aggregateColumns.length];
        for (int h = 0; h < this._colIndexes.length; ++h) {
            int colIdx = this._colIndexes[h];
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int retIdx = 0;
            for (int i = b.pos(colIdx); i < b.size(colIdx) + b.pos(colIdx); ++i) {
                while (aggregateColumns[retIdx] < sIndexes[i]) {
                    ++retIdx;
                }
                if (sIndexes[i] != aggregateColumns[retIdx]) continue;
                int j = 0;
                int offOrg = h;
                while (j < numVals * aggregateColumns.length) {
                    int n = j + retIdx;
                    ret[n] = ret[n] + this._dict.getValue(offOrg) * sValues[i];
                    j += aggregateColumns.length;
                    offOrg += this._colIndexes.length;
                }
            }
        }
        return ret;
    }

    @Override
    protected final double computeMxx(double c, Builtin builtin) {
        if (this._zeros) {
            c = builtin.execute(c, 0.0);
        }
        if (this._dict != null) {
            return this._dict.aggregate(c, builtin);
        }
        return c;
    }

    @Override
    protected final void computeColMxx(double[] c, Builtin builtin) {
        if (this._zeros) {
            for (int x = 0; x < this._colIndexes.length; ++x) {
                c[this._colIndexes[x]] = builtin.execute(c[this._colIndexes[x]], 0.0);
            }
        }
        if (this._dict != null) {
            this._dict.aggregateCols(c, builtin, this._colIndexes);
        }
    }

    protected final ADictionary applyScalarOp(ScalarOperator op) {
        return this._dict.clone().apply(op);
    }

    protected final ADictionary applyScalarOp(ScalarOperator op, double newVal, int numCols) {
        return this._dict.applyScalarOp(op, newVal, numCols);
    }

    protected final ADictionary applyBinaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        return sparseSafe ? this._dict.clone().applyBinaryRowOp(op, v, sparseSafe, this._colIndexes, left) : this._dict.applyBinaryRowOp(op, v, sparseSafe, this._colIndexes, left);
    }

    public static void setupThreadLocalMemory(int len) {
        if (memPool.get() == null || ((int[])memPool.get().getLeft()).length < len) {
            ImmutablePair p = new ImmutablePair((Object)new int[len], (Object)new double[len]);
            memPool.set((Pair<int[], double[]>)p);
        }
    }

    public static void cleanupThreadLocalMemory() {
        memPool.remove();
    }

    protected static double[] allocDVector(int len, boolean reset) {
        Pair<int[], double[]> p = memPool.get();
        if (p == null) {
            return new double[len];
        }
        if (((double[])p.getValue()).length < len) {
            ColGroupValue.setupThreadLocalMemory(len);
            return (double[])p.getValue();
        }
        double[] tmp = (double[])p.getValue();
        if (reset) {
            Arrays.fill(tmp, 0, len, 0.0);
        }
        return tmp;
    }

    protected static int[] allocIVector(int len, boolean reset) {
        Pair<int[], double[]> p = memPool.get();
        if (p == null) {
            return new int[len + 1];
        }
        if (((int[])p.getKey()).length < len) {
            ColGroupValue.setupThreadLocalMemory(len);
            return (int[])p.getKey();
        }
        int[] tmp = (int[])p.getKey();
        if (reset) {
            Arrays.fill(tmp, 0, len, 0);
        }
        return tmp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Is Lossy: " + this._dict.isLossy() + " num Rows: " + this.getNumRows() + " contain zero row:" + this._zeros);
        sb.append(super.toString());
        if (this._dict != null) {
            sb.append(String.format("\n%15s ", "Values: " + this._dict.getClass().getSimpleName()));
            sb.append(this._dict.getString(this._colIndexes.length));
        }
        return sb.toString();
    }

    @Override
    public final boolean isLossy() {
        return this._dict.isLossy();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._zeros = in.readBoolean();
        this._dict = DictionaryFactory.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this._zeros);
        this._dict.write(out);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ++ret;
        ++ret;
        ++ret;
        if (this._dict != null) {
            ret += this._dict.getExactSizeOnDisk();
        }
        return ret;
    }

    public abstract int[] getCounts(int[] var1);

    public abstract int[] getCounts(int var1, int var2, int[] var3);

    @Override
    protected final void computeSum(double[] c, boolean square) {
        if (this._dict != null) {
            c[0] = square ? c[0] + this._dict.sumsq(this.getCounts(), this._colIndexes.length) : c[0] + this._dict.sum(this.getCounts(), this._colIndexes.length);
        }
    }

    @Override
    protected final void computeColSums(double[] c, boolean square) {
        this._dict.colSum(c, this.getCounts(), this._colIndexes, square);
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DMLCompressionException("Error while cloning: " + this.getClass().getSimpleName(), e);
        }
    }

    public AColGroup copyAndSet(double[] newDictionary) {
        return this.copyAndSet(new Dictionary(newDictionary));
    }

    public AColGroup copyAndSet(ADictionary newDictionary) {
        ColGroupValue clone = (ColGroupValue)this.clone();
        clone._dict = newDictionary;
        return clone;
    }

    public AColGroup copyAndSet(int[] colIndexes, double[] newDictionary) {
        return this.copyAndSet(colIndexes, new Dictionary(newDictionary));
    }

    public AColGroup copyAndSet(int[] colIndexes, ADictionary newDictionary) {
        ColGroupValue clone = (ColGroupValue)this.clone();
        clone._dict = newDictionary;
        clone.setColIndices(colIndexes);
        return clone;
    }

    @Override
    public ColGroupValue copy() {
        return (ColGroupValue)this.clone();
    }

    @Override
    protected final AColGroup sliceSingleColumn(int idx) {
        ColGroupValue ret = this.copy();
        ret._colIndexes = new int[]{0};
        if (ret._dict != null) {
            ret._dict = this._colIndexes.length == 1 ? ret._dict.clone() : ret._dict.sliceOutColumnRange(idx, idx + 1, this._colIndexes.length);
        }
        return ret;
    }

    @Override
    protected final AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        ColGroupValue ret = this.copy();
        ret._dict = ret._dict != null ? ret._dict.sliceOutColumnRange(idStart, idEnd, this._colIndexes.length) : null;
        ret._colIndexes = outputCols;
        return ret;
    }

    protected final MatrixBlock preAggregate(MatrixBlock m, int rl, int ru) {
        int numVals = this.getNumValues();
        int lhsRows = ru - rl;
        double[] vals = ColGroupValue.allocDVector(lhsRows * numVals, true);
        DenseBlockFP64 retB = new DenseBlockFP64(new int[]{lhsRows, numVals}, vals);
        MatrixBlock preAgg = new MatrixBlock(lhsRows, numVals, retB);
        this.preAggregate(m, preAgg, rl, ru);
        preAgg.recomputeNonZeros();
        return preAgg;
    }

    protected abstract void preAggregate(MatrixBlock var1, MatrixBlock var2, int var3, int var4);

    public final Dictionary preAggregateThatIndexStructure(ColGroupValue that, boolean preModify) {
        int outputLength = that._colIndexes.length * this.getNumValues();
        Dictionary ret = new Dictionary(new double[outputLength]);
        if (that instanceof ColGroupDDC) {
            return this.preAggregateThatDDCStructure((ColGroupDDC)that, ret);
        }
        if (that instanceof ColGroupSDC) {
            return this.preAggregateThatSDCStructure((ColGroupSDC)that, ret, preModify);
        }
        if (that instanceof ColGroupSDCSingle) {
            return this.preAggregateThatSDCSingleStructure((ColGroupSDCSingle)that, ret, preModify);
        }
        if (that instanceof ColGroupSDCSingleZeros) {
            return this.preAggregateThatSDCSingleZerosStructure((ColGroupSDCSingleZeros)that, ret);
        }
        if (that instanceof ColGroupSDCZeros) {
            return this.preAggregateThatSDCZerosStructure((ColGroupSDCZeros)that, ret);
        }
        if (that instanceof ColGroupConst) {
            return this.preAggregateThatConstStructure((ColGroupConst)that, ret);
        }
        throw new NotImplementedException("Not supported pre aggregate using index structure of :" + that.getClass().getSimpleName() + " in " + this.getClass().getSimpleName());
    }

    protected int getIndexStructureHash() {
        throw new NotImplementedException("This base function should not be called");
    }

    protected Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        throw new DMLCompressionException("Does not make sense to call this, implement function for sub class");
    }

    protected Dictionary preAggregateThatConstStructure(ColGroupConst that, Dictionary ret) {
        this.computeColSums(ret.getValues(), false);
        return ret;
    }

    @Override
    public final void leftMultByAColGroup(AColGroup lhs, MatrixBlock result) {
        if (lhs instanceof ColGroupEmpty) {
            return;
        }
        if (lhs instanceof ColGroupValue) {
            this.leftMultByColGroupValue((ColGroupValue)lhs, result);
        } else if (lhs instanceof ColGroupUncompressed) {
            this.leftMultByUncompressedColGroup((ColGroupUncompressed)lhs, result);
        } else {
            throw new DMLCompressionException("Not supported left multiplication with A ColGroup of type: " + lhs.getClass().getSimpleName());
        }
    }

    private void leftMultByColGroupValue(ColGroupValue lhs, MatrixBlock result) {
        int nvL = lhs.getNumValues();
        int nvR = this.getNumValues();
        int lCol = lhs._colIndexes.length;
        int rCol = this._colIndexes.length;
        double[] resV = result.getDenseBlockValues();
        int numCols = result.getNumColumns();
        double threshold = 0.2;
        if (this.sameIndexStructure(lhs)) {
            if (this._dict == lhs._dict) {
                ColGroupValue.tsmmDictionaryWithScaling(this._dict, this.getCounts(), lhs._colIndexes, this._colIndexes, resV, numCols);
            } else {
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexesWithScaling(lhs._dict, this._dict, lhs._colIndexes, this._colIndexes, result, this.getCounts());
            }
        } else if (lhs instanceof ColGroupConst || this instanceof ColGroupConst) {
            ADictionary r = this instanceof ColGroupConst ? this._dict : new Dictionary(this._dict.colSum(this.getCounts(), rCol));
            ADictionary l = lhs instanceof ColGroupConst ? lhs._dict : new Dictionary(lhs._dict.colSum(lhs.getCounts(), lCol));
            ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(l, r, lhs._colIndexes, this._colIndexes, result);
        } else {
            int[] countsRight = this.getCounts();
            int mostFrequentRight = Math.max(countsRight[0], countsRight[countsRight.length - 1]);
            double percentageRight = (double)mostFrequentRight / (double)this._numRows;
            double skipRight = percentageRight * (double)rCol;
            int[] countsLeft = lhs.getCounts();
            int mostFrequentLeft = Math.max(countsLeft[0], countsLeft[countsLeft.length - 1]);
            double percentageLeft = (double)mostFrequentLeft / (double)this._numRows;
            double skipLeft = percentageLeft * (double)lCol;
            if (skipRight > 0.2 && percentageRight > percentageLeft && !(this instanceof ColGroupDDC)) {
                double[] mct = this._dict.getMostCommonTuple(this.getCounts(), rCol);
                double[] lhsSum = lhs._dict.colSum(lhs.getCounts(), lCol);
                if (mct != null) {
                    ColGroupValue.outerProduct(lhsSum, lhs._colIndexes, mct, this._colIndexes, resV, numCols);
                }
                ColGroupValue thisM = mct != null ? (ColGroupValue)this.copyAndSet(this._dict.subtractTuple(mct)) : this;
                Dictionary preAgg = lhs.preAggregateThatIndexStructure(thisM, true);
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(lhs._dict, preAgg, lhs._colIndexes, this._colIndexes, result);
            } else if (skipLeft > 0.2 && !(lhs instanceof ColGroupDDC)) {
                double[] mct = lhs._dict.getMostCommonTuple(lhs.getCounts(), lCol);
                double[] thisColSum = this._dict.colSum(this.getCounts(), rCol);
                if (mct != null) {
                    ColGroupValue.outerProduct(mct, lhs._colIndexes, thisColSum, this._colIndexes, resV, numCols);
                }
                ColGroupValue lhsM = mct != null ? (ColGroupValue)lhs.copyAndSet(lhs._dict.subtractTuple(mct)) : lhs;
                Dictionary preAgg = this.preAggregateThatIndexStructure(lhsM, true);
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(preAgg, this._dict, lhs._colIndexes, this._colIndexes, result);
            } else if (nvR * rCol < nvL * lCol) {
                Dictionary preAgg = lhs.preAggregateThatIndexStructure(this, false);
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(lhs._dict, preAgg, lhs._colIndexes, this._colIndexes, result);
            } else {
                Dictionary preAgg = this.preAggregateThatIndexStructure(lhs, false);
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(preAgg, this._dict, lhs._colIndexes, this._colIndexes, result);
            }
        }
    }

    private void leftMultByUncompressedColGroup(ColGroupUncompressed lhs, MatrixBlock result) {
        MatrixBlock ucCG = lhs.getData();
        if (this instanceof ColGroupConst) {
            AggregateUnaryOperator auop = InstructionUtils.parseBasicAggregateUnaryOperator("uac+", 1);
            MatrixBlock tmp = ucCG.aggregateUnaryOperations(auop, new MatrixBlock(), Math.max(ucCG.getNumRows(), ucCG.getNumColumns()), null, true);
            MatrixBlockDictionary l = new MatrixBlockDictionary(tmp);
            ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(l, this._dict, lhs._colIndexes, this._colIndexes, result);
        } else {
            LOG.warn((Object)"Inefficient transpose of uncompressed to fit to template need t(UnCompressedColGroup) %*% AColGroup support");
            MatrixBlock tmp = new MatrixBlock(ucCG.getNumColumns(), ucCG.getNumRows(), ucCG.isInSparseFormat());
            LibMatrixReorg.transpose(ucCG, tmp, InfrastructureAnalyzer.getLocalParallelism());
            this.leftMultByMatrix(tmp, result, lhs._colIndexes);
        }
    }

    @Override
    public final void tsmm(double[] result, int numColumns) {
        int[] counts = this.getCounts();
        this._dict = this._dict.getAsMatrixBlockDictionary(this._colIndexes.length);
        if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary mbd = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = mbd.getMatrixBlock();
            if (mb.isEmpty()) {
                return;
            }
            if (mb.isInSparseFormat()) {
                this.tsmmSparse(result, numColumns, mb.getSparseBlock(), counts);
            } else {
                this.tsmmDense(result, numColumns, mb.getDenseBlockValues(), counts);
            }
        } else {
            this.tsmmDense(result, numColumns, this.getValues(), counts);
        }
    }

    @Override
    public final void tsmm(double[] result, int numColumns, int idxStart, int idxEnd) {
        throw new NotImplementedException();
    }

    private void tsmmDense(double[] result, int numColumns, double[] values, int[] counts) {
        if (values == null) {
            return;
        }
        int nCol = this._colIndexes.length;
        int nRow = values.length / this._colIndexes.length;
        for (int k = 0; k < nRow; ++k) {
            int offTmp = nCol * k;
            int scale = counts[k];
            for (int i = 0; i < nCol; ++i) {
                int offRet = numColumns * this._colIndexes[i];
                double v = values[offTmp + i] * (double)scale;
                if (v == 0.0) continue;
                for (int j = i; j < nCol; ++j) {
                    int n = offRet + this._colIndexes[j];
                    result[n] = result[n] + v * values[offTmp + j];
                }
            }
        }
    }

    private void tsmmSparse(double[] result, int numColumns, SparseBlock sb, int[] counts) {
        for (int row = 0; row < sb.numRows(); ++row) {
            if (sb.isEmpty(row)) continue;
            int apos = sb.pos(row);
            int alen = sb.size(row);
            int[] aix = sb.indexes(row);
            double[] avals = sb.values(row);
            for (int i = apos; i < apos + alen; ++i) {
                int offRet = this._colIndexes[aix[i]] * numColumns;
                double val = avals[i] * (double)counts[row];
                for (int j = i; j < apos + alen; ++j) {
                    int n = offRet + this._colIndexes[aix[j]];
                    result[n] = result[n] + val * avals[j];
                }
            }
        }
    }

    @Override
    public final boolean containsValue(double pattern) {
        return this._dict.containsValue(pattern);
    }

    @Override
    public final long getNumberNonZeros() {
        int[] counts = this.getCounts();
        return this._dict.getNumberNonZeros(counts, this._colIndexes.length);
    }

    private static void matrixMultDictionariesAndOutputToColIndexesWithScaling(ADictionary left, ADictionary right, int[] leftRows, int[] rightColumns, MatrixBlock result, int[] counts) {
        boolean modifyRight = right.getInMemorySize() > left.getInMemorySize();
        ADictionary rightM = modifyRight ? right.scaleTuples(counts, rightColumns.length) : right;
        ADictionary leftM = modifyRight ? left : left.scaleTuples(counts, leftRows.length);
        ColGroupValue.matrixMultDictionariesAndOutputToColIndexes(leftM, rightM, leftRows, rightColumns, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tsmmDictionaryWithScaling(ADictionary dict, int[] counts, int[] rows, int[] cols, double[] res, int outCols) {
        if (dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary mbd = (MatrixBlockDictionary)dict;
            MatrixBlock mb = mbd.getMatrixBlock();
            if (mb.isEmpty()) {
                return;
            }
            if (!mb.isInSparseFormat()) throw new NotImplementedException();
            SparseBlock sb = mb.getSparseBlock();
            for (int row = 0; row < sb.numRows(); ++row) {
                if (sb.isEmpty(row)) continue;
                int apos = sb.pos(row);
                int alen = sb.size(row);
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                for (int i = apos; i < apos + alen; ++i) {
                    int offRet = rows[aix[i]] * outCols;
                    double val = avals[i] * (double)counts[row];
                    for (int j = i; j < apos + alen; ++j) {
                        int n = offRet + cols[aix[j]];
                        res[n] = res[n] + val * avals[j];
                    }
                }
            }
            return;
        } else {
            double[] values = dict.getValues();
            for (int row = 0; row < rows.length; ++row) {
                int offTmp = cols.length * row;
                int offRet = outCols * rows[row];
                for (int col = 0; col < cols.length; ++col) {
                    double v = values[offTmp + col] * (double)counts[row];
                    if (v == 0.0) continue;
                    for (int j = col; j < cols.length; ++j) {
                        int n = offRet + cols[col];
                        res[n] = res[n] + v * values[offTmp + j];
                    }
                }
            }
        }
    }

    private static void outerProduct(double[] left, int[] leftRows, double[] right, int[] rightColumns, double[] result, int outCols) {
        if (left.length != leftRows.length) {
            throw new DMLCompressionException("Error left length " + left.length + " not equal columns length" + leftRows.length);
        }
        if (right.length != rightColumns.length) {
            throw new DMLCompressionException("Error right not equal length " + right.length + " " + rightColumns.length);
        }
        for (int row = 0; row < leftRows.length; ++row) {
            int outputRowOffset = leftRows[row] * outCols;
            double vLeft = left[row];
            for (int col = 0; col < rightColumns.length; ++col) {
                int n = outputRowOffset + rightColumns[col];
                result[n] = result[n] + vLeft * right[col];
            }
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndexes(ADictionary left, ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        try {
            double[] leftV = null;
            double[] rightV = null;
            if (left instanceof MatrixBlockDictionary) {
                MatrixBlockDictionary leftD = left.getAsMatrixBlockDictionary(rowsLeft.length);
                MatrixBlock leftMB = leftD.getMatrixBlock();
                if (leftMB.isEmpty()) {
                    LOG.error((Object)("Left is empty: " + leftMB));
                    return;
                }
                if (right instanceof MatrixBlockDictionary) {
                    MatrixBlockDictionary rightD = right.getAsMatrixBlockDictionary(colsRight.length);
                    MatrixBlock rightMB = rightD.getMatrixBlock();
                    if (rightMB.isEmpty()) {
                        return;
                    }
                    if (rightMB.isInSparseFormat() && leftMB.isInSparseFormat()) {
                        throw new NotImplementedException("Not Supported sparse sparse dictionary multiplication");
                    }
                    if (rightMB.isInSparseFormat()) {
                        ColGroupValue.matrixMultDictionariesAndOutputToColIndecesDenseSparse(leftMB.getDenseBlockValues(), rightMB.getSparseBlock(), rowsLeft, colsRight, result);
                    } else if (leftMB.isInSparseFormat()) {
                        ColGroupValue.matrixMultDictionariesAndOutputToColIndecesSparseDense(leftMB.getSparseBlock(), rightMB.getDenseBlockValues(), rowsLeft, colsRight, result);
                    } else {
                        ColGroupValue.matrixMultDictionariesAndOutputToColIndexesDenseDense(leftMB.getDenseBlockValues(), rightMB.getDenseBlockValues(), rowsLeft, colsRight, result);
                    }
                    return;
                }
                if (leftMB.isInSparseFormat()) {
                    ColGroupValue.matrixMultDictionariesAndOutputToColIndecesSparseDense(leftMB.getSparseBlock(), right.getValues(), rowsLeft, colsRight, result);
                    return;
                }
                leftV = leftMB.getDenseBlockValues();
            } else {
                leftV = left.getValues();
            }
            if (right instanceof MatrixBlockDictionary) {
                MatrixBlockDictionary rightD = right.getAsMatrixBlockDictionary(colsRight.length);
                MatrixBlock rightMB = rightD.getMatrixBlock();
                if (rightMB.isEmpty()) {
                    LOG.error((Object)("Right is empty: " + rightMB));
                    return;
                }
                if (rightMB.isInSparseFormat()) {
                    ColGroupValue.matrixMultDictionariesAndOutputToColIndecesDenseSparse(leftV, rightMB.getSparseBlock(), rowsLeft, colsRight, result);
                    return;
                }
                rightV = rightMB.getDenseBlockValues();
            } else {
                rightV = right.getValues();
            }
            if (leftV != null && rightV != null) {
                ColGroupValue.matrixMultDictionariesAndOutputToColIndexesDenseDense(leftV, rightV, rowsLeft, colsRight, result);
            }
        }
        catch (Exception e) {
            if (logMM) {
                LOG.error((Object)("\nLeft (transposed):\n" + left + "\nRight:\n" + right));
                logMM = false;
            }
            throw new DMLCompressionException("MM of pre aggregated colGroups failed", e);
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndexesDenseDense(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int offOut = rowsLeft[i] * result.getNumColumns();
                double vl = left[offL + i];
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offR + j];
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + vl * vr;
                }
            }
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndecesSparseDense(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            for (int k = apos; k < alen; ++k) {
                int offOut = rowsLeft[aix[k]] * result.getNumColumns();
                double v = leftVals[k];
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + v * right[offRight + j];
                }
            }
        }
    }

    private static void matrixMultDictionariesAndOutputToColIndecesDenseSparse(double[] left, SparseBlock right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.length, right.numRows());
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.length;
            for (int j = 0; j < rowsLeft.length; ++j) {
                int offOut = rowsLeft[j] * result.getNumColumns();
                double v = left[offLeft + j];
                if (v == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    int n = offOut + colsRight[aix[k]];
                    resV[n] = resV[n] + v * rightVals[k];
                }
            }
        }
    }

    @Override
    public final boolean isDense() {
        return !this._zeros;
    }

    @Override
    public final void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result, int rl, int ru) {
        try {
            if (matrix.isEmpty()) {
                return;
            }
            MatrixBlock tmpRes = this.leftMultByMatrixIntermediateMatrix(matrix, rl, ru);
            this.addMatrixToResult(tmpRes, result, rl, ru);
        }
        catch (Exception e) {
            throw new DMLCompressionException(this.getClass().getSimpleName() + " Failed to Left Matrix Multiply", e);
        }
    }

    private MatrixBlock leftMultByMatrixIntermediateMatrix(MatrixBlock matrix, int rl, int ru) {
        MatrixBlock dictM = this.forceMatrixBlockDictionary().getMatrixBlock();
        int tmpCol = this._colIndexes.length;
        int tmpRow = matrix.getNumRows();
        MatrixBlock tmpRes = new MatrixBlock(tmpRow, tmpCol, false);
        MatrixBlock preAgg = this.preAggregate(matrix, rl, ru);
        LibMatrixMult.matrixMult(preAgg, dictM, tmpRes);
        return tmpRes;
    }

    private void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result, int[] outputRows) {
        try {
            if (matrix.isEmpty()) {
                return;
            }
            MatrixBlock tmpRes = this.leftMultByMatrixIntermediateMatrix(matrix, 0, matrix.getNumRows());
            this.addMatrixToResult(tmpRes, result, outputRows);
        }
        catch (Exception e) {
            throw new DMLCompressionException(this.getClass().getSimpleName() + " Failed to multiply with an uncompressed column group", e);
        }
    }

    private MatrixBlockDictionary forceMatrixBlockDictionary() {
        if (!(this._dict instanceof MatrixBlockDictionary)) {
            this._dict = this._dict.getAsMatrixBlockDictionary(this._colIndexes.length);
        }
        return (MatrixBlockDictionary)this._dict;
    }

    private void addMatrixToResult(MatrixBlock tmp, MatrixBlock result, int rl, int ru) {
        if (tmp.isEmpty()) {
            return;
        }
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        if (tmp.isInSparseFormat()) {
            SparseBlock sb = tmp.getSparseBlock();
            int row = rl;
            int offT = 0;
            while (row < ru) {
                int apos = sb.pos(offT);
                int alen = sb.size(offT);
                int[] aix = sb.indexes(offT);
                double[] avals = sb.values(offT);
                int offR = row * nColRet;
                for (int i = apos; i < apos + alen; ++i) {
                    int n = offR + this._colIndexes[aix[i]];
                    retV[n] = retV[n] + avals[i];
                }
                ++row;
                ++offT;
            }
        } else {
            double[] tmpV = tmp.getDenseBlockValues();
            int nCol = this._colIndexes.length;
            int row = rl;
            int offT = 0;
            while (row < ru) {
                int offR = row * nColRet;
                for (int col = 0; col < nCol; ++col) {
                    int n = offR + this._colIndexes[col];
                    retV[n] = retV[n] + tmpV[offT + col];
                }
                ++row;
                offT += nCol;
            }
        }
    }

    private void addMatrixToResult(MatrixBlock tmp, MatrixBlock result, int[] rowIndexes) {
        if (tmp.isEmpty()) {
            return;
        }
        double[] retV = result.getDenseBlockValues();
        int nColRet = result.getNumColumns();
        if (tmp.isInSparseFormat()) {
            SparseBlock sb = tmp.getSparseBlock();
            for (int row = 0; row < rowIndexes.length; ++row) {
                int apos = sb.pos(row);
                int alen = sb.size(row);
                int[] aix = sb.indexes(row);
                double[] avals = sb.values(row);
                int offR = rowIndexes[row] * nColRet;
                for (int i = apos; i < apos + alen; ++i) {
                    int n = offR + this._colIndexes[aix[i]];
                    retV[n] = retV[n] + avals[i];
                }
            }
        } else {
            double[] tmpV = tmp.getDenseBlockValues();
            int nCol = this._colIndexes.length;
            int row = 0;
            int offT = 0;
            while (row < rowIndexes.length) {
                int offR = rowIndexes[row] * nColRet;
                for (int col = 0; col < nCol; ++col) {
                    int n = offR + this._colIndexes[col];
                    retV[n] = retV[n] + tmpV[offT + col];
                }
                ++row;
                offT += nCol;
            }
        }
    }

    @Override
    public final AColGroup rightMultByMatrix(MatrixBlock right) {
        double[] ret;
        int[] agCols;
        if (right.isEmpty()) {
            return null;
        }
        boolean cl = false;
        int cu = right.getNumColumns();
        int cut = right.getNumColumns();
        int nCol = right.getNumColumns();
        int numVals = this.getNumValues();
        if (right.isInSparseFormat()) {
            SparseBlock sb = right.getSparseBlock();
            agCols = this.getAggregateColumnsSetSparse(sb, nCol);
            if (agCols.length == 0) {
                return null;
            }
            ret = this.preaggValuesFromSparse(numVals, sb, agCols, 0, cu, cut);
        } else {
            double[] rightV = right.getDenseBlockValues();
            agCols = this.getAggregateColumnsSetDense(rightV, 0, cu, cut);
            if (agCols.length == 0) {
                return null;
            }
            ret = new double[numVals * agCols.length];
            this._dict.preaggValuesFromDense(numVals, this._colIndexes, agCols, rightV, ret, cut);
        }
        return this.copyAndSet(agCols, ret);
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += 8L;
        size += 8L;
        ++size;
        ++size;
        size += 2L;
        return size += this._dict.getInMemorySize();
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.length, this._zeros);
        return this.copyAndSet(replaced);
    }
}

