/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import org.apache.sysds.common.Types;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.VariableSet;

public class DataIdentifier
extends Identifier {
    protected String _name;
    protected String _valueTypeString;

    public DataIdentifier(DataIdentifier passed) {
        this.setProperties(passed);
        this._name = passed.getName();
        this._valueTypeString = passed.getValueType().toString();
        this.setParseInfo(passed);
    }

    public DataIdentifier(String name) {
        this._name = name;
    }

    public DataIdentifier(String name, Types.DataType dt) {
        this(name);
        this._dataType = dt;
    }

    public DataIdentifier(String name, Types.DataType dt, Types.ValueType vt) {
        this(name);
        this._dataType = dt;
        this._valueType = vt;
    }

    public DataIdentifier() {
        this._name = null;
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        DataIdentifier newId = new DataIdentifier(this);
        String newIdName = prefix + this._name;
        newId.setName(newIdName);
        return newId;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariable(this._name, this);
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        return null;
    }

    public boolean multipleReturns() {
        throw new LanguageException("multipleReturns() must be overridden in the subclass.");
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof DataIdentifier)) {
            return false;
        }
        DataIdentifier target = (DataIdentifier)that;
        if (this.getName() != null && !this.getName().equals(target.getName())) {
            return false;
        }
        if (this.getDataType() != null && !this.getDataType().equals((Object)target.getDataType())) {
            return false;
        }
        if (this.getValueType() != null && !this.getValueType().equals((Object)target.getValueType())) {
            return false;
        }
        if (this.getFileFormat() != null && this.getFileFormat() != target.getFileFormat()) {
            return false;
        }
        if (this.getDim1() != target.getDim1()) {
            return false;
        }
        return this.getDim2() == target.getDim2();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

