/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.runtime.codegen.SpoofCellwise;
import org.apache.sysds.runtime.codegen.SpoofMultiAggregate;
import org.apache.sysds.runtime.codegen.SpoofOuterProduct;
import org.apache.sysds.runtime.codegen.SpoofRowwise;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateTernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryFrameScalarCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CtableCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuaternaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysds.runtime.instructions.cp.SpoofCPInstruction;
import org.apache.sysds.runtime.instructions.cp.TernaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryMatrixCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateBinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateTernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AggregateUnaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.AppendFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.BinaryFrameScalarFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CentralMomentFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CovarianceFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.CtableFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.IndexingFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MMChainFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.MultiReturnParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ParameterizedBuiltinFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantilePickFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuantileSortFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReorgFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.ReshapeFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.SpoofFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TernaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.TsmmFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryMatrixFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.VariableFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendGAlignedSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendGSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryMatrixBVectorSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryMatrixMatrixSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryMatrixScalarSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryTensorTensorBroadcastSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryTensorTensorSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CentralMomentSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantilePickSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantileSortSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuaternarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SpoofSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.WriteSPInstruction;

public class FEDInstructionUtils {
    private static String[] PARAM_BUILTINS = new String[]{"replace", "rmempty", "lowertri", "uppertri", "transformdecode", "transformapply", "tokenize"};

    public static Instruction checkAndReplaceCP(Instruction inst, ExecutionContext ec) {
        FEDInstruction fedinst = null;
        if (inst instanceof AggregateBinaryCPInstruction) {
            AggregateBinaryCPInstruction instruction = (AggregateBinaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && instruction.input2.isMatrix()) {
                MatrixObject mo1 = ec.getMatrixObject(instruction.input1);
                MatrixObject mo2 = ec.getMatrixObject(instruction.input2);
                if (mo1.isFederated(FederationMap.FType.ROW) || mo2.isFederated(FederationMap.FType.ROW) || mo1.isFederated(FederationMap.FType.COL)) {
                    fedinst = AggregateBinaryFEDInstruction.parseInstruction(InstructionUtils.concatOperands(inst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()));
                }
            }
        } else if (inst instanceof MMChainCPInstruction) {
            MMChainCPInstruction linst = (MMChainCPInstruction)inst;
            MatrixObject mo = ec.getMatrixObject(linst.input1);
            if (mo.isFederated(FederationMap.FType.ROW)) {
                fedinst = MMChainFEDInstruction.parseInstruction(linst.getInstructionString());
            }
        } else if (inst instanceof MMTSJCPInstruction) {
            MMTSJCPInstruction linst = (MMTSJCPInstruction)inst;
            MatrixObject mo = ec.getMatrixObject(linst.input1);
            if (mo.isFederated(FederationMap.FType.ROW) && linst.getMMTSJType().isLeft() || mo.isFederated(FederationMap.FType.COL) && linst.getMMTSJType().isRight()) {
                fedinst = TsmmFEDInstruction.parseInstruction(linst.getInstructionString());
            }
        } else if (inst instanceof UnaryCPInstruction && !(inst instanceof IndexingCPInstruction)) {
            UnaryCPInstruction instruction = (UnaryCPInstruction)inst;
            if (inst instanceof ReorgCPInstruction && (inst.getOpcode().equals("r'") || inst.getOpcode().equals("rdiag") || inst.getOpcode().equals("rev"))) {
                ReorgCPInstruction rinst = (ReorgCPInstruction)inst;
                CacheableData<?> mo = ec.getCacheableData(rinst.input1);
                if ((mo instanceof MatrixObject || mo instanceof FrameObject) && mo.isFederated()) {
                    fedinst = ReorgFEDInstruction.parseInstruction(InstructionUtils.concatOperands(rinst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()));
                }
            } else if (instruction.input1 != null && instruction.input1.isMatrix() && ec.containsVariable(instruction.input1)) {
                MatrixObject mo1 = ec.getMatrixObject(instruction.input1);
                if (instruction.getOpcode().equalsIgnoreCase("cm") && mo1.isFederated()) {
                    fedinst = CentralMomentFEDInstruction.parseInstruction(inst.getInstructionString());
                } else if (inst.getOpcode().equalsIgnoreCase("qsort") && mo1.isFederated()) {
                    if (mo1.getFedMapping().getFederatedRanges().length == 1) {
                        fedinst = QuantileSortFEDInstruction.parseInstruction(inst.getInstructionString());
                    }
                } else if (inst.getOpcode().equalsIgnoreCase("rshape") && mo1.isFederated()) {
                    fedinst = ReshapeFEDInstruction.parseInstruction(inst.getInstructionString());
                } else if (inst instanceof AggregateUnaryCPInstruction && mo1.isFederated() && ((AggregateUnaryCPInstruction)instruction).getAUType() == AggregateUnaryCPInstruction.AUType.DEFAULT) {
                    fedinst = AggregateUnaryFEDInstruction.parseInstruction(InstructionUtils.concatOperands(inst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()));
                } else if (inst instanceof UnaryMatrixCPInstruction && mo1.isFederated() && UnaryMatrixFEDInstruction.isValidOpcode(inst.getOpcode()) && (!inst.getOpcode().equalsIgnoreCase("ucumk+*") || !mo1.isFederated(FederationMap.FType.COL))) {
                    fedinst = UnaryMatrixFEDInstruction.parseInstruction(inst.getInstructionString());
                }
            }
        } else if (inst instanceof BinaryCPInstruction) {
            BinaryCPInstruction instruction = (BinaryCPInstruction)inst;
            if (instruction.input1.isMatrix() && ec.getMatrixObject(instruction.input1).isFederated() || instruction.input2.isMatrix() && ec.getMatrixObject(instruction.input2).isFederated()) {
                fedinst = instruction.getOpcode().equals("append") ? AppendFEDInstruction.parseInstruction(inst.getInstructionString()) : (instruction.getOpcode().equals("qpick") ? QuantilePickFEDInstruction.parseInstruction(inst.getInstructionString()) : ("cov".equals(instruction.getOpcode()) && (ec.getMatrixObject(instruction.input1).isFederated(FederationMap.FType.ROW) || ec.getMatrixObject(instruction.input2).isFederated(FederationMap.FType.ROW)) ? CovarianceFEDInstruction.parseInstruction(inst.getInstructionString()) : BinaryFEDInstruction.parseInstruction(InstructionUtils.concatOperands(inst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()))));
            } else if (inst.getOpcode().equals("_map") && inst instanceof BinaryFrameScalarCPInstruction && !inst.getInstructionString().contains("UtilFunctions") && instruction.input1.isFrame() && ec.getFrameObject(instruction.input1).isFederated()) {
                fedinst = BinaryFrameScalarFEDInstruction.parseInstruction(InstructionUtils.concatOperands(inst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()));
            }
        } else if (inst instanceof ParameterizedBuiltinCPInstruction) {
            ParameterizedBuiltinCPInstruction pinst = (ParameterizedBuiltinCPInstruction)inst;
            if (ArrayUtils.contains((Object[])PARAM_BUILTINS, (Object)pinst.getOpcode()) && pinst.getTarget(ec).isFederated()) {
                fedinst = ParameterizedBuiltinFEDInstruction.parseInstruction(pinst.getInstructionString());
            }
        } else if (inst instanceof MultiReturnParameterizedBuiltinCPInstruction) {
            CacheableData<?> fo;
            MultiReturnParameterizedBuiltinCPInstruction minst = (MultiReturnParameterizedBuiltinCPInstruction)inst;
            if (minst.getOpcode().equals("transformencode") && minst.input1.isFrame() && (fo = ec.getCacheableData(minst.input1)).isFederated()) {
                fedinst = MultiReturnParameterizedBuiltinFEDInstruction.parseInstruction(minst.getInstructionString());
            }
        } else if (inst instanceof IndexingCPInstruction) {
            IndexingCPInstruction minst = (IndexingCPInstruction)inst;
            if ((minst.input1.isMatrix() || minst.input1.isFrame()) && ec.getCacheableData(minst.input1).isFederated()) {
                fedinst = IndexingFEDInstruction.parseInstruction(minst.getInstructionString());
            }
        } else if (inst instanceof TernaryCPInstruction) {
            TernaryCPInstruction tinst = (TernaryCPInstruction)inst;
            if (tinst.input1.isMatrix() && ec.getCacheableData(tinst.input1).isFederated() || tinst.input2.isMatrix() && ec.getCacheableData(tinst.input2).isFederated() || tinst.input3.isMatrix() && ec.getCacheableData(tinst.input3).isFederated()) {
                fedinst = TernaryFEDInstruction.parseInstruction(tinst.getInstructionString());
            }
        } else if (inst instanceof VariableCPInstruction) {
            VariableCPInstruction ins = (VariableCPInstruction)inst;
            if (ins.getVariableOpcode() == VariableCPInstruction.VariableOperationCode.Write && ins.getInput1().isMatrix() && ins.getInput3().getName().contains("federated")) {
                fedinst = VariableFEDInstruction.parseInstruction(ins);
            } else if (ins.getVariableOpcode() == VariableCPInstruction.VariableOperationCode.CastAsFrameVariable && ins.getInput1().isMatrix() && ec.getCacheableData(ins.getInput1()).isFederated()) {
                fedinst = VariableFEDInstruction.parseInstruction(ins);
            } else if (ins.getVariableOpcode() == VariableCPInstruction.VariableOperationCode.CastAsMatrixVariable && ins.getInput1().isFrame() && ec.getCacheableData(ins.getInput1()).isFederated()) {
                fedinst = VariableFEDInstruction.parseInstruction(ins);
            }
        } else if (inst instanceof AggregateTernaryCPInstruction) {
            AggregateTernaryCPInstruction ins = (AggregateTernaryCPInstruction)inst;
            if (ins.input1.isMatrix() && ec.getCacheableData(ins.input1).isFederated() && ins.input2.isMatrix() && ec.getCacheableData(ins.input2).isFederated()) {
                fedinst = AggregateTernaryFEDInstruction.parseInstruction(ins);
            }
        } else if (inst instanceof QuaternaryCPInstruction) {
            QuaternaryCPInstruction instruction = (QuaternaryCPInstruction)inst;
            Data data = ec.getVariable(instruction.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = QuaternaryFEDInstruction.parseInstruction(instruction.getInstructionString());
            }
        } else if (inst instanceof SpoofCPInstruction) {
            SpoofCPInstruction instruction = (SpoofCPInstruction)inst;
            Class<?> scla = instruction.getOperatorClass().getSuperclass();
            if ((scla == SpoofCellwise.class || scla == SpoofMultiAggregate.class || scla == SpoofOuterProduct.class) && instruction.isFederated(ec) || scla == SpoofRowwise.class && instruction.isFederated(ec, FederationMap.FType.ROW)) {
                fedinst = SpoofFEDInstruction.parseInstruction(instruction.getInstructionString());
            }
        } else if (inst instanceof CtableCPInstruction) {
            CtableCPInstruction cinst = (CtableCPInstruction)inst;
            if (inst.getOpcode().equalsIgnoreCase("ctable") && (ec.getCacheableData(cinst.input1).isFederated(FederationMap.FType.ROW) || cinst.input2.isMatrix() && ec.getCacheableData(cinst.input2).isFederated(FederationMap.FType.ROW) || cinst.input3.isMatrix() && ec.getCacheableData(cinst.input3).isFederated(FederationMap.FType.ROW))) {
                fedinst = CtableFEDInstruction.parseInstruction(cinst.getInstructionString());
            }
        }
        if (fedinst != null) {
            fedinst.setTID(ec.getTID());
            return fedinst;
        }
        return inst;
    }

    public static Instruction checkAndReplaceSP(Instruction inst, ExecutionContext ec) {
        SpoofSPInstruction instruction;
        Class<?> scla;
        FEDInstruction fedinst = null;
        if (inst instanceof MapmmSPInstruction) {
            MapmmSPInstruction instruction2 = (MapmmSPInstruction)inst;
            Data data = ec.getVariable(instruction2.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = new AggregateBinaryFEDInstruction(instruction2.getOperator(), instruction2.input1, instruction2.input2, instruction2.output, "ba+*", "FED...");
            }
        } else if (inst instanceof UnarySPInstruction) {
            if (inst instanceof CentralMomentSPInstruction) {
                CentralMomentSPInstruction instruction3 = (CentralMomentSPInstruction)inst;
                Data data = ec.getVariable(instruction3.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                    fedinst = CentralMomentFEDInstruction.parseInstruction(inst.getInstructionString());
                }
            } else if (inst instanceof QuantileSortSPInstruction) {
                QuantileSortSPInstruction instruction4 = (QuantileSortSPInstruction)inst;
                Data data = ec.getVariable(instruction4.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                    fedinst = QuantileSortFEDInstruction.parseInstruction(inst.getInstructionString());
                }
            } else if (inst instanceof AggregateUnarySPInstruction) {
                AggregateUnarySPInstruction instruction5 = (AggregateUnarySPInstruction)inst;
                Data data = ec.getVariable(instruction5.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                    fedinst = AggregateUnaryFEDInstruction.parseInstruction(InstructionUtils.concatOperands(inst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()));
                }
            }
        } else if (inst instanceof BinarySPInstruction) {
            if (inst instanceof QuantilePickSPInstruction) {
                QuantilePickSPInstruction instruction6 = (QuantilePickSPInstruction)inst;
                Data data = ec.getVariable(instruction6.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                    fedinst = QuantilePickFEDInstruction.parseInstruction(inst.getInstructionString());
                }
            } else if (inst instanceof AppendGAlignedSPInstruction) {
                AppendGAlignedSPInstruction instruction7 = (AppendGAlignedSPInstruction)inst;
                Data data = ec.getVariable(instruction7.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                    fedinst = AppendFEDInstruction.parseInstruction(instruction7.getInstructionString());
                }
            } else if (inst instanceof AppendGSPInstruction) {
                AppendGSPInstruction instruction8 = (AppendGSPInstruction)inst;
                Data data = ec.getVariable(instruction8.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                    fedinst = AppendFEDInstruction.parseInstruction(instruction8.getInstructionString());
                }
            } else if (inst instanceof BinaryMatrixScalarSPInstruction || inst instanceof BinaryMatrixMatrixSPInstruction || inst instanceof BinaryMatrixBVectorSPInstruction || inst instanceof BinaryTensorTensorSPInstruction || inst instanceof BinaryTensorTensorBroadcastSPInstruction) {
                BinarySPInstruction instruction9 = (BinarySPInstruction)inst;
                Data data = ec.getVariable(instruction9.input1);
                if (data instanceof MatrixObject && ((MatrixObject)data).isFederated() || data instanceof TensorObject && ((TensorObject)data).isFederated()) {
                    fedinst = BinaryFEDInstruction.parseInstruction(InstructionUtils.concatOperands(inst.getInstructionString(), FEDInstruction.FederatedOutput.NONE.name()));
                }
            }
        } else if (inst instanceof WriteSPInstruction) {
            WriteSPInstruction instruction10 = (WriteSPInstruction)inst;
            Data data = ec.getVariable(instruction10.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                return VariableCPInstruction.parseInstruction(instruction10.getInstructionString());
            }
        } else if (inst instanceof QuaternarySPInstruction) {
            QuaternarySPInstruction instruction11 = (QuaternarySPInstruction)inst;
            Data data = ec.getVariable(instruction11.input1);
            if (data instanceof MatrixObject && ((MatrixObject)data).isFederated()) {
                fedinst = QuaternaryFEDInstruction.parseInstruction(instruction11.getInstructionString());
            }
        } else if (inst instanceof SpoofSPInstruction && (((scla = (instruction = (SpoofSPInstruction)inst).getOperatorClass().getSuperclass()) == SpoofCellwise.class || scla == SpoofMultiAggregate.class || scla == SpoofOuterProduct.class) && instruction.isFederated(ec) || scla == SpoofRowwise.class && instruction.isFederated(ec, FederationMap.FType.ROW))) {
            fedinst = SpoofFEDInstruction.parseInstruction(inst.getInstructionString());
        }
        if (fedinst != null) {
            fedinst.setTID(ec.getTID());
            return fedinst;
        }
        return inst;
    }
}

