/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.ByteArrayInputStream;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.model.JPADomain;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.DomainRegistry;
import org.apache.syncope.core.persistence.jpa.spring.DomainRoutingEntityManagerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jndi.JndiObjectFactoryBean;

public class JPADomainRegistry
implements DomainRegistry<JPADomain> {
    protected final ConfigurableApplicationContext ctx;

    public JPADomainRegistry(ConfigurableApplicationContext ctx) {
        this.ctx = ctx;
    }

    protected DefaultListableBeanFactory beanFactory() {
        return (DefaultListableBeanFactory)this.ctx.getBeanFactory();
    }

    protected void unregisterSingleton(String name) {
        if (this.beanFactory().containsSingleton(name)) {
            this.beanFactory().destroySingleton(name);
        }
    }

    protected void registerSingleton(String name, Object bean) {
        this.unregisterSingleton(name);
        this.beanFactory().registerSingleton(name, bean);
    }

    protected DomainHolder<DataSource> domainHolder() {
        return (DomainHolder)this.beanFactory().getBean(DomainHolder.class);
    }

    public void register(JPADomain domain) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(domain.getJdbcDriver());
        hikariConfig.setJdbcUrl(domain.getJdbcURL());
        hikariConfig.setUsername(domain.getDbUsername());
        hikariConfig.setPassword(domain.getDbPassword());
        hikariConfig.setSchema(domain.getDbSchema());
        hikariConfig.setTransactionIsolation(domain.getTransactionIsolation().name());
        hikariConfig.setMaximumPoolSize(domain.getPoolMaxActive());
        hikariConfig.setMinimumIdle(domain.getPoolMinIdle());
        this.beanFactory().registerBeanDefinition(domain.getKey() + "DataSource", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(JndiObjectFactoryBean.class).addPropertyValue("jndiName", (Object)("java:comp/env/jdbc/syncope" + domain.getKey() + "DataSource")).addPropertyValue("defaultObject", (Object)new HikariDataSource(hikariConfig)).getBeanDefinition());
        DataSource initedDataSource = (DataSource)this.beanFactory().getBean(domain.getKey() + "DataSource", DataSource.class);
        this.domainHolder().getDomains().put(domain.getKey(), initedDataSource);
        ((DomainRoutingEntityManagerFactory)this.beanFactory().getBean(DomainRoutingEntityManagerFactory.class)).domain(domain, initedDataSource, this.ctx.getEnvironment().getProperty("openjpaMetaDataFactory"));
        this.beanFactory().registerBeanDefinition(domain.getKey() + "ContentXML", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ByteArrayInputStream.class).addConstructorArgValue((Object)domain.getContent().getBytes()).getBeanDefinition());
        this.beanFactory().registerBeanDefinition(domain.getKey() + "KeymasterConfParamsJSON", (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(ByteArrayInputStream.class).addConstructorArgValue((Object)domain.getKeymasterConfParams().getBytes()).getBeanDefinition());
    }

    public void unregister(String domain) {
        this.unregisterSingleton(domain + "KeymasterConfParamsJSON");
        this.beanFactory().removeBeanDefinition(domain + "KeymasterConfParamsJSON");
        this.unregisterSingleton(domain + "ContentXML");
        this.beanFactory().removeBeanDefinition(domain + "ContentXML");
        ((DomainRoutingEntityManagerFactory)this.beanFactory().getBean(DomainRoutingEntityManagerFactory.class)).remove(domain);
        this.unregisterSingleton(domain.toLowerCase() + "DataSourceInitializer");
        this.unregisterSingleton(domain.toLowerCase() + "ResourceDatabasePopulator");
        this.unregisterSingleton(domain + "DataSource");
        this.beanFactory().removeBeanDefinition(domain + "DataSource");
        ((DomainHolder)this.beanFactory().getBean(DomainHolder.class)).getDomains().remove(domain);
    }
}

