/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.signalfx.endpoint.SignalFxEndpoint;
import com.signalfx.shaded.apache.commons.io.IOUtils;
import com.signalfx.shaded.apache.http.client.utils.URIBuilder;
import com.signalfx.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.signalfx.shaded.fasterxml.jackson.core.type.TypeReference;
import com.signalfx.shaded.fasterxml.jackson.databind.DeserializationFeature;
import com.signalfx.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.signalfx.shaded.google.common.io.BaseEncoding;
import com.signalfx.shaded.google.common.util.concurrent.Uninterruptibles;
import com.signalfx.shaded.jetty.util.ssl.SslContextFactory;
import com.signalfx.shaded.jetty.websocket.api.Session;
import com.signalfx.shaded.jetty.websocket.api.WebSocketAdapter;
import com.signalfx.shaded.jetty.websocket.client.WebSocketClient;
import com.signalfx.signalflow.Channel;
import com.signalfx.signalflow.ChannelMessage;
import com.signalfx.signalflow.SignalFlowException;
import com.signalfx.signalflow.SignalFlowTransport;
import com.signalfx.signalflow.StreamMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
implements SignalFlowTransport {
    protected static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);
    public static final int DEFAULT_TIMEOUT = 1;
    protected final String token;
    protected final SignalFxEndpoint endpoint;
    protected final String path;
    protected final int timeout;
    protected final boolean compress;
    protected WebSocketClient webSocketClient;
    protected TransportConnection transportConnection;

    protected WebSocketTransport(String token, SignalFxEndpoint endpoint, int apiVersion, int timeout, boolean compress, int maxBinaryMessageSize) {
        this.token = token;
        this.endpoint = endpoint;
        this.path = "/v" + apiVersion + "/signalflow/connect";
        this.timeout = timeout;
        this.compress = compress;
        try {
            this.transportConnection = new TransportConnection(token);
            URI uri = new URIBuilder(String.format("%s://%s:%s%s", endpoint.getScheme(), endpoint.getHostname(), endpoint.getPort(), this.path)).build();
            this.webSocketClient = new WebSocketClient(new SslContextFactory());
            if (maxBinaryMessageSize > 0) {
                this.webSocketClient.getPolicy().setMaxBinaryMessageSize(maxBinaryMessageSize);
            }
            if (timeout > 0) {
                this.webSocketClient.setConnectTimeout(TimeUnit.SECONDS.toMillis(timeout));
            }
            this.webSocketClient.start();
            this.webSocketClient.connect(this.transportConnection, uri);
            this.transportConnection.awaitConnected(timeout, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            if (this.webSocketClient != null) {
                try {
                    this.webSocketClient.stop();
                }
                catch (Exception e) {
                    log.warn("error closing websocket client", (Throwable)e);
                }
            }
            throw new SignalFlowException("failed to construct websocket transport", ex);
        }
    }

    @Override
    public Channel attach(String handle, Map<String, String> parameters) {
        log.debug("attach: [ {} ] with parameters: {}", (Object)handle, parameters);
        TransportChannel channel = new TransportChannel(this.transportConnection);
        HashMap<String, String> request = new HashMap<String, String>(parameters);
        request.put("type", "attach");
        request.put("handle", handle);
        request.put("compress", Boolean.toString(this.compress));
        this.transportConnection.sendMessage(channel, request);
        return channel;
    }

    @Override
    public Channel execute(String program, Map<String, String> parameters) {
        log.debug("execute: [ {} ] with parameters: {}", (Object)program, parameters);
        TransportChannel channel = new TransportChannel(this.transportConnection);
        HashMap<String, String> request = new HashMap<String, String>(parameters);
        request.put("type", "execute");
        request.put("program", program);
        request.put("compress", Boolean.toString(this.compress));
        this.transportConnection.sendMessage(channel, request);
        return channel;
    }

    @Override
    public Channel preflight(String program, Map<String, String> parameters) {
        log.debug("preflight: [ {} ] with parameters: {}", (Object)program, parameters);
        TransportChannel channel = new TransportChannel(this.transportConnection);
        HashMap<String, String> request = new HashMap<String, String>(parameters);
        request.put("type", "preflight");
        request.put("program", program);
        this.transportConnection.sendMessage(channel, parameters);
        return channel;
    }

    @Override
    public void start(String program, Map<String, String> parameters) {
        log.debug("start: [ {} ] with parameters: {}", (Object)program, parameters);
        HashMap<String, String> request = new HashMap<String, String>(parameters);
        request.put("type", "start");
        request.put("program", program);
        this.transportConnection.sendMessage(request);
    }

    @Override
    public void stop(String handle, Map<String, String> parameters) {
        log.debug("stop: [ {} ] with parameters: {}", (Object)handle, parameters);
        HashMap<String, String> request = new HashMap<String, String>(parameters);
        request.put("type", "stop");
        request.put("handle", handle);
        this.transportConnection.sendMessage(request);
    }

    @Override
    public void close(int code, String reason) {
        if (this.transportConnection.getSession() != null && this.transportConnection.getSession().isOpen()) {
            this.transportConnection.close(code, reason);
            try {
                this.webSocketClient.stop();
            }
            catch (Exception e) {
                log.warn("error while close underlying websocket client", (Throwable)e);
            }
            log.debug("transport closed");
        }
    }

    @Override
    public void keepalive(String handle) {
        log.debug("keepalive: [ {} ]", (Object)handle);
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("type", "keepalive");
        request.put("handle", handle);
        this.transportConnection.sendMessage(request);
    }

    protected static class TransportEventStreamParser
    implements Iterator<StreamMessage> {
        protected Queue<StreamMessage> messageQueue;
        protected boolean isClosed = false;

        public TransportEventStreamParser(Queue<StreamMessage> messageQueue) {
            this.messageQueue = messageQueue;
        }

        @Override
        public boolean hasNext() {
            return !this.isClosed;
        }

        @Override
        public StreamMessage next() {
            StreamMessage streamMessage = null;
            block6: while (!this.isClosed && streamMessage == null) {
                streamMessage = this.messageQueue.poll();
                if (streamMessage != null) {
                    switch (streamMessage.getKind()) {
                        case CONTROL: {
                            ChannelMessage channelMessage = ChannelMessage.decodeStreamMessage(streamMessage);
                            if (channelMessage.getType() != ChannelMessage.Type.END_OF_CHANNEL && channelMessage.getType() != ChannelMessage.Type.CHANNEL_ABORT) continue block6;
                            this.close();
                            continue block6;
                        }
                        case ERROR: {
                            if (!(streamMessage instanceof SignalFlowExceptionStreamMessage)) continue block6;
                            this.close();
                            throw ((SignalFlowExceptionStreamMessage)streamMessage).getException();
                        }
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    this.close();
                }
            }
            if (streamMessage != null) {
                return streamMessage;
            }
            throw new NoSuchElementException("no more stream messages");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove from stream not supported");
        }

        public void close() {
            this.isClosed = true;
        }
    }

    protected static class TransportChannel
    extends Channel {
        protected static final Logger log = LoggerFactory.getLogger(TransportChannel.class);
        protected TransportConnection connection;
        protected Queue<StreamMessage> messageQueue = new ConcurrentLinkedQueue<StreamMessage>();
        protected TransportEventStreamParser parser = new TransportEventStreamParser(this.messageQueue);

        public TransportChannel(TransportConnection sharedConnection) {
            this.connection = sharedConnection;
            this.iterator = this.parser;
            this.connection.add(this);
            log.debug("constructed {} of type {}", (Object)this.toString(), (Object)this.getClass().getName());
        }

        public boolean offer(StreamMessage message) {
            return this.messageQueue.offer(message);
        }

        @Override
        public void close() {
            super.close();
            this.connection.remove(this);
        }
    }

    protected static class TransportConnection
    extends WebSocketAdapter {
        private static final Logger log = LoggerFactory.getLogger(TransportConnection.class);
        private static final Charset ASCII = Charset.forName("US-ASCII");
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private static final BaseEncoding base64Encoder = BaseEncoding.base64Url().omitPadding();
        private static final TypeReference<Map<String, Object>> MAP_TYPE_REF = new TypeReference<Map<String, Object>>(){};
        private static final int MAX_CHANNEL_NAME_LENGTH = 16;
        private static final int BINARY_PREAMBLE_LENGTH = 4;
        private static final int BINARY_HEADER_LENGTH = 20;
        private static final int LONG_TYPE = 1;
        private static final int DOUBLE_TYPE = 2;
        private static final int INT_TYPE = 3;
        private static final ObjectMapper objectMapper = new ObjectMapper();
        private final CountDownLatch latch = new CountDownLatch(1);
        private final String token;
        private final Map<String, TransportChannel> channels = Collections.synchronizedMap(new HashMap());
        private SignalFlowException error;

        protected TransportConnection(String token) {
            this.token = token;
        }

        @Override
        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            log.debug("websocket connected to {}", (Object)session.getRemoteAddress());
            HashMap<String, String> authRequest = new HashMap<String, String>();
            authRequest.put("type", "authenticate");
            authRequest.put("token", this.token);
            this.sendMessage(authRequest);
        }

        @Override
        public void onWebSocketClose(int code, String reason) {
            log.debug("websocket connection closed ({} {})", (Object)code, (Object)reason);
            if (code != 1000) {
                this.error = new SignalFlowException(code, reason);
                log.info("Lost WebSocket connection with {} ({}).", (Object)this.getSession().getRemoteAddress(), (Object)code);
                SignalFlowExceptionStreamMessage errorMessage = new SignalFlowExceptionStreamMessage(this.error);
                for (TransportChannel channel : this.channels.values()) {
                    channel.offer(errorMessage);
                }
            }
            this.channels.clear();
            super.onWebSocketClose(code, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWebSocketBinary(byte[] data, int offset, int length) {
            boolean json;
            boolean compressed;
            StreamMessage.Kind kind;
            byte flags;
            byte type;
            byte version = data[offset];
            switch (version) {
                case 1: {
                    type = data[offset + 1];
                    flags = data[offset + 2];
                    break;
                }
                case 2: {
                    type = data[offset + 2];
                    flags = data[offset + 3];
                    break;
                }
                default: {
                    log.error("ignoring message with unsupported encoding version {}", (Object)version);
                    return;
                }
            }
            try {
                kind = StreamMessage.Kind.fromBinaryType(type);
            }
            catch (IllegalArgumentException iae) {
                log.error("ignoring message with unsupported type {}", (Object)type);
                return;
            }
            String channelName = new String(data, offset + 4, 16, ASCII);
            byte[] body = Arrays.copyOfRange(data, offset + 20, offset + length);
            boolean bl = compressed = (flags & 1) != 0;
            if (compressed) {
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    GZIPInputStream gzip = new GZIPInputStream(bais);
                    try {
                        IOUtils.copy((InputStream)gzip, (OutputStream)baos);
                    }
                    finally {
                        IOUtils.closeQuietly(gzip);
                    }
                    body = baos.toByteArray();
                }
                catch (IOException ioe) {
                    log.error("failed to process message", (Throwable)ioe);
                    return;
                }
                finally {
                    IOUtils.closeQuietly(baos);
                    IOUtils.closeQuietly(bais);
                }
            }
            boolean bl2 = json = (flags & 2) != 0;
            if (json) {
                this.onWebSocketText(new String(body, UTF_8));
                return;
            }
            Map<String, Object> message = null;
            switch (kind) {
                case DATA: {
                    message = TransportConnection.decodeBinaryDataMessage(version, body);
                    break;
                }
                default: {
                    log.error("ignoring message with unsupported binary encoding of kind {}", (Object)kind);
                    return;
                }
            }
            if (message != null) {
                TransportChannel channel = this.channels.get(channelName);
                if (channel != null && !channel.isClosed()) {
                    try {
                        StreamMessage streamMessage = new StreamMessage("data", null, objectMapper.writeValueAsString(message));
                        channel.offer(streamMessage);
                    }
                    catch (JsonProcessingException ex) {
                        log.error("failed to process message", (Throwable)ex);
                    }
                } else {
                    log.debug("ignoring message. channel not found {}", (Object)channelName);
                }
            }
        }

        private static Map<String, Object> decodeBinaryDataMessage(byte version, byte[] data) {
            try {
                HashMap<String, Object> message = new HashMap<String, Object>();
                ByteBuffer buffer = ByteBuffer.wrap(data);
                switch (version) {
                    case 1: {
                        message.put("logicalTimestampMs", buffer.getLong());
                        break;
                    }
                    case 2: {
                        message.put("logicalTimestampMs", buffer.getLong());
                        message.put("maxDelayMs", buffer.getLong());
                    }
                }
                int count = buffer.getInt();
                ArrayList datapoints = new ArrayList(count);
                for (int element = 0; element < count; ++element) {
                    HashMap<String, Object> elementMap = new HashMap<String, Object>(3);
                    byte type = buffer.get();
                    byte[] tsIdBytes = new byte[8];
                    buffer.get(tsIdBytes);
                    elementMap.put("tsId", base64Encoder.encode(tsIdBytes));
                    switch (type) {
                        case 1: 
                        case 3: {
                            elementMap.put("value", buffer.getLong());
                            break;
                        }
                        case 2: {
                            elementMap.put("value", buffer.getDouble());
                            break;
                        }
                        default: {
                            log.warn("ignoring data message with unknown value type {}", (Object)type);
                            return null;
                        }
                    }
                    datapoints.add(elementMap);
                }
                message.put("data", datapoints);
                return message;
            }
            catch (Exception ex) {
                log.error("failed to construct transport data message", (Throwable)ex);
                return null;
            }
        }

        @Override
        public void onWebSocketText(String data) {
            try {
                Map<String, Object> dataMap = objectMapper.readValue(data, MAP_TYPE_REF);
                String event = (String)dataMap.get("event");
                if ("KEEP_ALIVE".equals(event)) {
                    return;
                }
                String type = (String)dataMap.get("type");
                if (type == null) {
                    log.debug("type missing so ignoring message. {}", dataMap);
                    return;
                }
                if (type.equals("authenticated")) {
                    log.info("WebSocket connection authenticated as {} (in {})", dataMap.get("userId"), dataMap.get("orgId"));
                    this.latch.countDown();
                } else {
                    String channelName = (String)dataMap.get("channel");
                    if (channelName != null) {
                        TransportChannel channel = this.channels.get(channelName);
                        if (channel != null && !channel.isClosed()) {
                            StreamMessage message = new StreamMessage(type, null, data);
                            channel.offer(message);
                        } else {
                            log.debug("ignoring message. channel not found {}", (Object)channelName);
                        }
                    }
                }
            }
            catch (IOException ex) {
                log.error("failed to process messages", (Throwable)ex);
            }
        }

        public void sendMessage(Map<String, String> request) {
            try {
                String message = objectMapper.writeValueAsString(request);
                this.getRemote().sendString(message);
            }
            catch (Exception ex) {
                throw new SignalFlowException("failed to send message", ex);
            }
        }

        public void sendMessage(Channel channel, Map<String, String> request) {
            try {
                HashMap<String, String> channelRequest = new HashMap<String, String>(request);
                channelRequest.put("channel", channel.getName());
                String message = objectMapper.writeValueAsString(channelRequest);
                this.getRemote().sendString(message);
            }
            catch (Exception ex) {
                throw new SignalFlowException("failed to send message for channel " + channel.getName(), ex);
            }
        }

        public void add(TransportChannel channel) {
            this.channels.put(channel.getName(), channel);
        }

        public void remove(TransportChannel channel) {
            this.channels.remove(channel);
        }

        public void close(int code, String reason) {
            for (Channel channel : this.channels.values()) {
                channel.close();
            }
            this.channels.clear();
            this.getSession().close(code, reason);
            this.latch.countDown();
        }

        public void awaitConnected(long timeout, TimeUnit unit) throws TimeoutException {
            if (!Uninterruptibles.awaitUninterruptibly(this.latch, timeout, unit)) {
                throw new TimeoutException("timeout establishing connection");
            }
        }

        static {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }

    protected static class SignalFlowExceptionStreamMessage
    extends StreamMessage {
        protected SignalFlowException exception;

        public SignalFlowExceptionStreamMessage(SignalFlowException exception) {
            super("error", null, exception.getMessage());
            this.exception = exception;
        }

        public SignalFlowException getException() {
            return this.exception;
        }
    }

    public static class TransportBuilder {
        private String token;
        private String protocol = "wss";
        private String host = "stream.signalfx.com";
        private int port = 443;
        private int timeout = 1;
        private int version = 2;
        private boolean compress = true;
        private int maxBinaryMessageSize = -1;

        public TransportBuilder(String token) {
            this.token = token;
        }

        public TransportBuilder setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public TransportBuilder setHost(String host) {
            this.host = host;
            return this;
        }

        public TransportBuilder setPort(int port) {
            this.port = port;
            return this;
        }

        public TransportBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public TransportBuilder setAPIVersion(int version) {
            this.version = version;
            return this;
        }

        public TransportBuilder useCompression(boolean compress) {
            this.compress = compress;
            return this;
        }

        public TransportBuilder setMaxBinaryMessageSize(int size) {
            this.maxBinaryMessageSize = size;
            return this;
        }

        public WebSocketTransport build() {
            SignalFxEndpoint endpoint = new SignalFxEndpoint(this.protocol, this.host, this.port);
            WebSocketTransport transport = new WebSocketTransport(this.token, endpoint, this.version, this.timeout, this.compress, this.maxBinaryMessageSize);
            return transport;
        }
    }
}

