/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.scheduler;

import io.micrometer.shaded.reactor.blockhound.BlockHound;
import io.micrometer.shaded.reactor.blockhound.integration.BlockHoundIntegration;
import io.micrometer.shaded.reactor.core.scheduler.BoundedElasticScheduler;
import io.micrometer.shaded.reactor.core.scheduler.NonBlocking;
import io.micrometer.shaded.reactor.core.scheduler.SchedulerTask;
import io.micrometer.shaded.reactor.core.scheduler.WorkerTask;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

public final class ReactorBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        builder.nonBlockingThreadPredicate(current -> current.or(NonBlocking.class::isInstance));
        builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "offer");
        builder.allowBlockingCallsInside(ScheduledThreadPoolExecutor.class.getName() + "$DelayedWorkQueue", "take");
        builder.allowBlockingCallsInside(BoundedElasticScheduler.class.getName() + "$BoundedScheduledExecutorService", "ensureQueueCapacity");
        builder.allowBlockingCallsInside(SchedulerTask.class.getName(), "dispose");
        builder.allowBlockingCallsInside(WorkerTask.class.getName(), "dispose");
        builder.allowBlockingCallsInside(ThreadPoolExecutor.class.getName(), "processWorkerExit");
        builder.allowBlockingCallsInside("io.micrometer.shaded.reactor.core.publisher.ContextPropagation", "<clinit>");
        builder.allowBlockingCallsInside(FutureTask.class.getName(), "handlePossibleCancellationInterrupt");
    }
}

