/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.datetime.DatetimePickerIconConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.inputmask.InputMaskBehavior;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.util.Json;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.wicket.behavior.Behavior;

@Deprecated
public class DatetimePickerConfig
extends AbstractConfig {
    private static final long serialVersionUID = 1L;
    private static final String DIGITS_PATTERN = "(?i)(y|m|d|h|s)";
    private static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String BTN_SHOW_TODAY = "showToday";
    public static final String BTN_SHOW_CLEAR = "showClear";
    public static final String BTN_SHOW_CLOSE = "showClose";
    private static final IKey<String> Format = DatetimePickerConfig.newKey((String)"format", null);
    private static final IKey<Boolean> UseCurrent = DatetimePickerConfig.newKey((String)"useCurrent", (Object)true);
    private static final IKey<Boolean> CalendarWeeks = DatetimePickerConfig.newKey((String)"calendarWeeks", (Object)false);
    private static final IKey<Integer> MinuteStepping = DatetimePickerConfig.newKey((String)"stepping", (Object)1);
    private static final IKey<String> Date = DatetimePickerConfig.newKey((String)"date", null);
    private static final IKey<String> MinDate = DatetimePickerConfig.newKey((String)"minDate", null);
    private static final IKey<String> MaxDate = DatetimePickerConfig.newKey((String)"maxDate", null);
    private static final IKey<String> DefaultDate = DatetimePickerConfig.newKey((String)"defaultDate", null);
    private static final IKey<String> ViewMode = DatetimePickerConfig.newKey((String)"viewMode", null);
    private static final IKey<String> Locale = DatetimePickerConfig.newKey((String)"locale", null);
    private static final IKey<Boolean> ShowToday = DatetimePickerConfig.newKey((String)"showTodayButton", (Object)false);
    private static final IKey<Boolean> ShowClose = DatetimePickerConfig.newKey((String)"showClose", (Object)false);
    private static final IKey<Boolean> Collapse = DatetimePickerConfig.newKey((String)"collapse", (Object)true);
    private static final IKey<Boolean> SideBySide = DatetimePickerConfig.newKey((String)"sideBySide", (Object)false);
    private static final IKey<Boolean> Strict = DatetimePickerConfig.newKey((String)"useStrict", (Object)false);
    private static final IKey<String[]> DisabledDates = DatetimePickerConfig.newKey((String)"disabledDates", null);
    private static final IKey<String[]> EnabledDates = DatetimePickerConfig.newKey((String)"enabledDates", null);
    private static final IKey<String[]> ExtraFormats = DatetimePickerConfig.newKey((String)"extraFormats", null);
    private static final IKey<Map<String, Boolean>> Buttons = DatetimePickerConfig.newKey((String)"buttons", Map.of("showToday", false, "showClear", false, "showClose", false));
    private static final IKey<DatetimePickerIconConfig> Icons = DatetimePickerConfig.newKey((String)"icons", null);
    private static final IKey<Boolean> KeepInvalid = DatetimePickerConfig.newKey((String)"keepInvalid", (Object)false);
    private static final IKey<Json.RawValue> ParseInputDate = DatetimePickerConfig.newKey((String)"parseInputDate", null);
    private boolean maskInput = false;

    public DatetimePickerConfig() {
        this.useLocale("en-gb");
        this.withFormat("MM/dd/yyyy");
        this.withExtraFormats(new String[0]);
    }

    public DatetimePickerConfig useLocale(String locale) {
        this.put(Locale, locale);
        return this;
    }

    public DatetimePickerConfig useMaskInput(boolean maskInput) {
        this.maskInput = maskInput;
        return this;
    }

    public boolean getMaskInput() {
        return this.maskInput;
    }

    public DatetimePickerConfig withFormat(String format) {
        this.put(Format, DatetimePickerConfig.toJavaScriptDateFormat(format));
        return this;
    }

    public DatetimePickerConfig withExtraFormats(String ... formats) {
        this.put(ExtraFormats, (String[])Stream.concat(Arrays.stream(formats), Stream.of(ISO_DATE_TIME_FORMAT)).map(DatetimePickerConfig::toJavaScriptDateFormat).toArray(String[]::new));
        return this;
    }

    public DatetimePickerConfig withButtons(Map<String, Boolean> buttons) {
        this.put(Buttons, Map.of(BTN_SHOW_TODAY, Boolean.TRUE.equals(buttons.get(BTN_SHOW_TODAY)), BTN_SHOW_CLEAR, Boolean.TRUE.equals(buttons.get(BTN_SHOW_CLEAR)), BTN_SHOW_CLOSE, Boolean.TRUE.equals(buttons.get(BTN_SHOW_CLOSE))));
        return this;
    }

    public DatetimePickerConfig with(DatetimePickerIconConfig iconConfig) {
        this.put(Icons, (Object)iconConfig);
        return this;
    }

    public DatetimePickerConfig useView(ViewModeType view) {
        this.put(ViewMode, view.getCode());
        return this;
    }

    public DatetimePickerConfig useSideBySide(boolean sideBySide) {
        this.put(SideBySide, sideBySide);
        return this;
    }

    public DatetimePickerConfig useStrictParsing(boolean strict) {
        this.put(Strict, strict);
        return this;
    }

    public DatetimePickerConfig useCurrent(boolean useCurrent) {
        this.put(UseCurrent, useCurrent);
        return this;
    }

    public DatetimePickerConfig useCalendarWeeks(boolean calendarWeeks) {
        this.put(CalendarWeeks, calendarWeeks);
        return this;
    }

    public DatetimePickerConfig withMinuteStepping(int minuteStepping) {
        this.put(MinuteStepping, minuteStepping);
        return this;
    }

    public DatetimePickerConfig withMinDate(Date minDate) {
        this.put(MinDate, this.defaultDateValueFormatter().format(minDate));
        return this;
    }

    public DatetimePickerConfig withMinDate(LocalDate minDate) {
        this.put(MinDate, DateTimeFormatter.ISO_LOCAL_DATE.format(minDate));
        return this;
    }

    public DatetimePickerConfig withMinDate(LocalDateTime minDate) {
        this.put(MinDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(minDate));
        return this;
    }

    public DatetimePickerConfig withMaxDate(Date maxDate) {
        this.put(MaxDate, this.defaultDateValueFormatter().format(maxDate));
        return this;
    }

    public DatetimePickerConfig withMaxDate(LocalDate maxDate) {
        this.put(MaxDate, DateTimeFormatter.ISO_LOCAL_DATE.format(maxDate));
        return this;
    }

    public DatetimePickerConfig withMaxDate(LocalDateTime maxDate) {
        this.put(MaxDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(maxDate));
        return this;
    }

    public DatetimePickerConfig withDate(Date date) {
        this.put(Date, this.defaultDateValueFormatter().format(date));
        return this;
    }

    public DatetimePickerConfig withDate(LocalDate date) {
        this.put(Date, DateTimeFormatter.ISO_LOCAL_DATE.format(date));
        return this;
    }

    public DatetimePickerConfig withDate(LocalDateTime date) {
        this.put(Date, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(date));
        return this;
    }

    public DatetimePickerConfig withDefaultDate(Date defaultDate) {
        this.put(DefaultDate, this.defaultDateValueFormatter().format(defaultDate));
        return this;
    }

    public DatetimePickerConfig withDefaultDate(LocalDate defaultDate) {
        this.put(DefaultDate, DateTimeFormatter.ISO_LOCAL_DATE.format(defaultDate));
        return this;
    }

    public DatetimePickerConfig withDefaultDate(LocalDateTime defaultDate) {
        this.put(DefaultDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(defaultDate));
        return this;
    }

    private SimpleDateFormat defaultDateValueFormatter() {
        return new SimpleDateFormat(ISO_DATE_TIME_FORMAT);
    }

    public DatetimePickerConfig setShowToday(boolean showToday) {
        this.put(ShowToday, showToday);
        return this;
    }

    public DatetimePickerConfig setShowClose(boolean showClose) {
        this.put(ShowClose, showClose);
        return this;
    }

    public DatetimePickerConfig setCollapse(Boolean collapse) {
        this.put(Collapse, collapse);
        return this;
    }

    public DatetimePickerConfig withDisabledDates(Date[] disabledDates) {
        this.put(DisabledDates, this.convertDatesToStrings(disabledDates));
        return this;
    }

    public DatetimePickerConfig withEnabledDates(Date[] enabledDates) {
        this.put(EnabledDates, this.convertDatesToStrings(enabledDates));
        return this;
    }

    public DatetimePickerConfig withParseInputDate(String func) {
        this.put(ParseInputDate, new Json.RawValue(func));
        return this;
    }

    public DatetimePickerConfig withKeepInvalid(boolean keep) {
        this.put(KeepInvalid, keep);
        return this;
    }

    public String getFormat() {
        return DatetimePickerConfig.toJavaDateFormat(this.getString(Format));
    }

    public String getMinuteStepping() {
        return this.getString(MinuteStepping);
    }

    public ViewModeType getViewMode() {
        return ViewModeType.valueOf(this.getString(ViewMode));
    }

    private String[] convertDatesToStrings(Date[] dates) {
        String[] stringDates = new String[dates.length];
        SimpleDateFormat formatter = this.defaultDateValueFormatter();
        int i = 0;
        for (Date date : dates) {
            stringDates[i++] = formatter.format(date);
        }
        return stringDates;
    }

    public static String toJavaDateFormat(String javaScriptDateFormat) {
        return Strings2.nullToEmpty((String)javaScriptDateFormat).replace('D', 'd').replace('Y', 'y').replace('A', 'a');
    }

    public static String toJavaScriptDateFormat(String javaDateFormat) {
        return Strings2.nullToEmpty((String)javaDateFormat).replace('d', 'D').replace('y', 'Y').replace('a', 'A');
    }

    public Behavior newMaskBehavior() {
        String mask = this.getFormat().replaceAll(DIGITS_PATTERN, "9");
        return new InputMaskBehavior(mask);
    }

    public static enum ViewModeType {
        YEARS("years"),
        MONTHS("months"),
        DAYS("days");

        private final String code;

        private ViewModeType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

