/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator.test;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;

public class SimpleTestUsernamePasswordAuthenticator
implements Authenticator {
    public Optional<Credentials> validate(CallContext ctx, Credentials cred) {
        if (cred == null) {
            throw new CredentialsException("No credential");
        }
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)cred;
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new CredentialsException("Username cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new CredentialsException("Password cannot be blank");
        }
        if (!StringUtils.equals((CharSequence)username, (CharSequence)password)) {
            throw new CredentialsException("Username : '" + username + "' does not match password");
        }
        CommonProfile profile = new CommonProfile();
        profile.setId(username);
        profile.addAttribute("username", (Object)username);
        credentials.setUserProfile((UserProfile)profile);
        return Optional.of(credentials);
    }
}

