/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.SamlIdPMetadataProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.io.FileWatcherService;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.audit.annotation.Audit;
import org.hjson.JsonValue;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JsonResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResourceMetadataResolver.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final String metadataTemplate;
    private final Resource jsonResource;
    private Map<String, SamlServiceProviderMetadata> metadataMap = new HashMap<String, SamlServiceProviderMetadata>();
    private FileWatcherService watcherService;

    public JsonResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
        this.metadataTemplate = (String)FunctionUtils.doUnchecked(() -> {
            InputStream inputStream = new ClassPathResource("metadata/sp-metadata-template.xml").getInputStream();
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        });
        SamlIdPMetadataProperties md = samlIdPProperties.getMetadata();
        String location = SpringExpressionLanguageValueResolver.getInstance().resolve(md.getFileSystem().getLocation());
        File metadataDir = (File)FunctionUtils.doUnchecked(() -> ResourceUtils.getRawResourceFrom((String)location).getFile());
        this.jsonResource = new FileSystemResource(new File(metadataDir, "saml-sp-metadata.json"));
        LOGGER.debug("Service provider metadata as JSON may be found at [{}]", (Object)this.jsonResource);
        if (this.jsonResource.exists()) {
            this.metadataMap = this.readDecisionsFromJsonResource();
            this.watcherService = (FileWatcherService)FunctionUtils.doUnchecked(() -> new FileWatcherService(this.jsonResource.getFile(), file -> {
                this.metadataMap = this.readDecisionsFromJsonResource();
            }));
            this.watcherService.start(this.getClass().getSimpleName());
        }
    }

    @Override
    @Audit(action="SAML2_METADATA_RESOLUTION", actionResolverName="SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", resourceResolverName="SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER")
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        if (this.metadataMap.containsKey(service.getServiceId())) {
            return (Collection)FunctionUtils.doUnchecked(() -> {
                SamlServiceProviderMetadata sp = this.metadataMap.get(service.getServiceId());
                String metadata = this.metadataTemplate.replace("${entityId}", sp.getEntityId()).replace("${certificate}", sp.getCertificate()).replace("${binding}", sp.getBinding()).replace("${assertionConsumerServiceUrl}", sp.getAssertionConsumerServiceUrl());
                ByteArrayInputStream metadataResource = new ByteArrayInputStream(metadata.getBytes(StandardCharsets.UTF_8));
                InMemoryResourceMetadataResolver resolver = new InMemoryResourceMetadataResolver((InputStream)metadataResource, this.configBean);
                this.configureAndInitializeSingleMetadataResolver((AbstractMetadataResolver)resolver, service);
                return CollectionUtils.wrap((Object)resolver);
            });
        }
        return new ArrayList();
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        String metadataLocation = service.getMetadataLocation();
        return metadataLocation.trim().startsWith("json://");
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        return ResourceUtils.doesResourceExist((Resource)this.jsonResource);
    }

    public void destroy() {
        if (this.watcherService != null) {
            this.watcherService.close();
        }
    }

    private Map<String, SamlServiceProviderMetadata> readDecisionsFromJsonResource() {
        return (Map)FunctionUtils.doUnchecked(() -> {
            try (InputStreamReader reader = new InputStreamReader(this.jsonResource.getInputStream(), StandardCharsets.UTF_8);){
                TypeReference<Map<String, SamlServiceProviderMetadata>> personList = new TypeReference<Map<String, SamlServiceProviderMetadata>>(this){};
                Map map = (Map)MAPPER.readValue(JsonValue.readHjson((Reader)reader).toString(), (TypeReference)personList);
                return map;
            }
        });
    }

    public static class SamlServiceProviderMetadata
    implements Serializable {
        private static final long serialVersionUID = -7347473226470492601L;
        private String entityId;
        private String certificate;
        private String assertionConsumerServiceUrl;
        private String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";

        @Generated
        public String getEntityId() {
            return this.entityId;
        }

        @Generated
        public String getCertificate() {
            return this.certificate;
        }

        @Generated
        public String getAssertionConsumerServiceUrl() {
            return this.assertionConsumerServiceUrl;
        }

        @Generated
        public String getBinding() {
            return this.binding;
        }

        @Generated
        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Generated
        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Generated
        public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
            this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        }

        @Generated
        public void setBinding(String binding) {
            this.binding = binding;
        }
    }
}

