/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.table.security;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.tirasa.connid.bundles.db.table.security.EncodeAlgorithm;
import net.tirasa.connid.bundles.db.table.security.PasswordDecodingException;
import net.tirasa.connid.bundles.db.table.security.PasswordEncodingException;
import net.tirasa.connid.bundles.db.table.security.UnsupportedPasswordCharsetException;

public class ClearText
extends EncodeAlgorithm {
    private static final String NAME = "CLEARTEXT";

    @Override
    public String encode(String clearPwd, String charsetName) throws PasswordEncodingException, UnsupportedPasswordCharsetException {
        try {
            Charset charset = Charset.forName(charsetName);
            return new String(clearPwd.getBytes(charset), charset);
        }
        catch (Exception e) {
            throw new UnsupportedPasswordCharsetException("Unsupported password charset.", e);
        }
    }

    @Override
    public String decode(String encodedPwd, String charsetName) throws PasswordDecodingException {
        try {
            Charset charset = Charset.forName(charsetName);
            return new String(encodedPwd.getBytes(charset), charset);
        }
        catch (Exception e) {
            throw new PasswordDecodingException("Unsupported password charset.");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setKey(String key) throws UnsupportedEncodingException {
    }
}

