/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import de.agilecoders.wicket.jquery.Attr;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.function.ClosestJqueryFunction;
import de.agilecoders.wicket.jquery.function.ConfigurableFunction;
import de.agilecoders.wicket.jquery.function.FindJqueryFunction;
import de.agilecoders.wicket.jquery.function.IFunction;
import de.agilecoders.wicket.jquery.function.JavaScriptInlineFunction;
import de.agilecoders.wicket.jquery.function.OnJqueryFunction;
import de.agilecoders.wicket.jquery.function.SimpleFunction;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.Strings;

public class JQuery
implements IClusterable {
    private static final Function<IFunction, String> FUNCTION_TRANSFORMER = new Function<IFunction, String>(){

        @Override
        public String apply(IFunction function) {
            return function != null ? function.build() : null;
        }
    };
    private final Attr selector;
    private final List<IFunction> functions;

    public static Attr quoted(CharSequence value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            return new Attr.Quoted(value);
        }
        return Attr.nullValue();
    }

    public static Attr plain(CharSequence value) {
        if (!Strings.isEmpty((CharSequence)value)) {
            return new Attr.Plain(value);
        }
        return Attr.nullValue();
    }

    public static Attr.MarkupId markupId(Component component) {
        return new Attr.MarkupId(component);
    }

    public static Attr.MarkupId markupId(CharSequence markupId) {
        return new Attr.MarkupId(markupId);
    }

    public static Attr auto(Object value) {
        if (value instanceof Attr) {
            return (Attr)value;
        }
        if (value != null) {
            return new Attr.Auto(value);
        }
        return Attr.nullValue();
    }

    public static JQuery $(CharSequence selector) {
        return new JQuery(JQuery.quoted(selector));
    }

    public static JQuery $(Attr selector) {
        if (selector instanceof Attr.MarkupId) {
            return new JQuery(((Attr.MarkupId)selector).quoted());
        }
        return new JQuery(selector);
    }

    public static JQuery $(Component component) {
        return JQuery.$(JQuery.markupId(component));
    }

    public static JQuery $(Component component, CharSequence ... additionalSelector) {
        ArrayList<Attr> selectors = Generics2.newArrayList(new Attr[0]);
        selectors.add(JQuery.markupId(component));
        if (additionalSelector != null) {
            for (CharSequence selector : additionalSelector) {
                selectors.add(JQuery.plain(selector));
            }
        }
        return JQuery.$(Generics2.join(selectors, ' '));
    }

    public static JQuery $(Component component, Attr ... additionalSelector) {
        ArrayList<Attr> selector = Generics2.newArrayList(new Attr[0]);
        selector.add(JQuery.markupId(component));
        if (additionalSelector != null) {
            selector.addAll(Generics2.newArrayList(additionalSelector));
        }
        return JQuery.$(Generics2.join(selector, ' '));
    }

    public static JQuery $() {
        return JQuery.$(Attr.noSelector());
    }

    private JQuery(Attr selector) {
        this.selector = selector;
        this.functions = Generics2.newArrayList(new IFunction[0]);
    }

    public JQuery chain(IFunction function) {
        this.functions.add(function);
        return this;
    }

    public JQuery on(CharSequence events, JavaScriptInlineFunction handler) {
        return this.chain(OnJqueryFunction.on(events, handler));
    }

    public JQuery on(CharSequence events, CharSequence selector, JavaScriptInlineFunction handler) {
        return this.on(JQuery.quoted(events), JQuery.quoted(selector), handler);
    }

    public JQuery on(Attr events, Attr selector, JavaScriptInlineFunction handler) {
        return this.chain(OnJqueryFunction.on(events, selector, handler));
    }

    public JQuery on(Attr events, JavaScriptInlineFunction handler) {
        return this.on(events, Attr.nullValue(), handler);
    }

    public JQuery closest(CharSequence selector) {
        return this.closest(JQuery.quoted(selector));
    }

    public JQuery closest(Attr selector) {
        return this.chain(ClosestJqueryFunction.closest(selector));
    }

    public JQuery find(CharSequence selector) {
        return this.find(JQuery.quoted(selector));
    }

    public JQuery find(Attr selector) {
        return this.chain(new FindJqueryFunction(selector));
    }

    public JQuery chain(CharSequence functionName) {
        this.functions.add(new SimpleFunction(functionName));
        return this;
    }

    public String get() {
        return this.build() + ";";
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        if (this.selector == Attr.noSelector()) {
            builder.append("$");
        } else {
            builder.append("$(").append(this.selector).append(")");
        }
        builder.append(this.createFunctionString());
        return builder.toString();
    }

    public OnDomReadyHeaderItem asDomReadyScript() {
        return OnDomReadyHeaderItem.forScript((CharSequence)this.get());
    }

    private String createFunctionString() {
        return this.functions.isEmpty() ? "" : "." + Generics2.join(Generics2.transform(this.functions, FUNCTION_TRANSFORMER), '.');
    }

    public JQuery chain(CharSequence functionName, Config config, Config ... extraConfigs) {
        this.functions.add(new ConfigurableFunction(functionName, config, extraConfigs));
        return this;
    }
}

