/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.authn;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20ClientAuthenticationMethods;
import org.apereo.cas.support.oauth.authenticator.OAuth20ClientIdClientSecretAuthenticator;
import org.apereo.cas.support.oauth.profile.OAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.pac4j.core.context.CallContext;
import org.springframework.context.ConfigurableApplicationContext;

public class OidcClientIdClientSecretAuthenticator
extends OAuth20ClientIdClientSecretAuthenticator {
    private final OidcServerDiscoverySettings oidcServerDiscoverySettings;

    public OidcClientIdClientSecretAuthenticator(ServicesManager servicesManager, ServiceFactory<WebApplicationService> webApplicationServiceServiceFactory, AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry, PrincipalResolver principalResolver, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator, OAuth20ProfileScopeToAttributesFilter profileScopeToAttributesFilter, TicketFactory ticketFactory, ConfigurableApplicationContext applicationContext, OidcServerDiscoverySettings oidcServerDiscoverySettings) {
        super(servicesManager, webApplicationServiceServiceFactory, registeredServiceAccessStrategyEnforcer, ticketRegistry, principalResolver, requestParameterResolver, clientSecretValidator, profileScopeToAttributesFilter, ticketFactory, applicationContext);
        this.oidcServerDiscoverySettings = oidcServerDiscoverySettings;
    }

    protected boolean isAuthenticationMethodSupported(CallContext callContext, OAuthRegisteredService registeredService, OAuth20ClientAuthenticationMethods requiredAuthnMethod) {
        boolean authMethodSupported = this.oidcServerDiscoverySettings.getTokenEndpointAuthMethodsSupported().stream().map(OAuth20ClientAuthenticationMethods::parse).anyMatch(method -> method == requiredAuthnMethod);
        return super.isAuthenticationMethodSupported(callContext, registeredService, requiredAuthnMethod) && authMethodSupported;
    }
}

