/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.logout.handler.SessionLogoutHandler;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.exceptions.OidcException;
import org.pac4j.oidc.exceptions.UserInfoErrorResponseException;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.OidcProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileCreator
extends ProfileDefinitionAware
implements ProfileCreator {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcProfileCreator.class);
    protected OidcConfiguration configuration;
    protected OidcClient client;

    public OidcProfileCreator(OidcConfiguration configuration, OidcClient client) {
        this.configuration = configuration;
        this.client = client;
    }

    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.setProfileDefinitionIfUndefined((ProfileDefinition)new OidcProfileDefinition());
    }

    public Optional<UserProfile> create(CallContext ctx, Credentials credentials) {
        this.init();
        OidcCredentials oidcCredentials = null;
        AccessToken accessToken = null;
        boolean regularOidcFlow = credentials instanceof OidcCredentials;
        if (regularOidcFlow) {
            oidcCredentials = (OidcCredentials)credentials;
            accessToken = oidcCredentials.toAccessToken();
        } else {
            String token = ((TokenCredentials)credentials).getToken();
            accessToken = new BearerAccessToken(token);
        }
        OidcProfile profile = (OidcProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setAccessToken(accessToken);
        if (oidcCredentials != null) {
            RefreshToken refreshToken;
            if (oidcCredentials.getIdToken() != null) {
                profile.setIdTokenString(oidcCredentials.toIdToken().getParsedString());
            }
            if ((refreshToken = oidcCredentials.toRefreshToken()) != null && !refreshToken.getValue().isEmpty()) {
                profile.setRefreshToken(refreshToken);
                LOGGER.debug("Refresh Token successful retrieved");
            }
        }
        try {
            Nonce nonce;
            block15: {
                nonce = this.configuration.isUseNonce() ? new Nonce((String)ctx.sessionStore().get(ctx.webContext(), this.client.getNonceSessionAttributeName()).orElse(null)) : null;
                if (oidcCredentials != null && oidcCredentials.getIdToken() != null) {
                    IDTokenClaimsSet claimsSet = this.configuration.getOpMetadataResolver().getTokenValidator().validate(oidcCredentials.toIdToken(), nonce);
                    CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
                    profile.setId(ProfileHelper.sanitizeIdentifier((Object)claimsSet.getSubject()));
                    String sid = (String)claimsSet.getClaim("sid");
                    SessionLogoutHandler sessionLogoutHandler = this.client.findSessionLogoutHandler();
                    if (StringUtils.isNotBlank((CharSequence)sid) && sessionLogoutHandler != null) {
                        sessionLogoutHandler.recordSession(ctx, sid);
                    }
                }
                if (this.configuration.isCallUserInfoEndpoint()) {
                    URI uri = ((OIDCProviderMetadata)this.configuration.getOpMetadataResolver().load()).getUserInfoEndpointURI();
                    try {
                        this.callUserInfoEndpoint(uri, accessToken, (UserProfile)profile);
                    }
                    catch (UserInfoErrorResponseException e) {
                        if (regularOidcFlow) break block15;
                        return Optional.empty();
                    }
                }
            }
            if (oidcCredentials != null && oidcCredentials.getIdToken() != null) {
                for (Map.Entry entry : oidcCredentials.toIdToken().getJWTClaimsSet().getClaims().entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                    this.getProfileDefinition().convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
                }
            }
            if (oidcCredentials != null && this.configuration.isIncludeAccessTokenClaimsInProfile()) {
                this.collectClaimsFromAccessTokenIfAny(oidcCredentials, nonce, (UserProfile)profile);
            }
            profile.setTokenExpirationAdvance(this.configuration.getTokenExpirationAdvance());
            return Optional.of(profile);
        }
        catch (JOSEException | BadJOSEException | com.nimbusds.oauth2.sdk.ParseException | IOException | ParseException e) {
            throw new OidcException(e);
        }
    }

    public void callUserInfoEndpoint(URI userInfoEndpointUri, AccessToken accessToken, UserProfile profile) throws IOException, com.nimbusds.oauth2.sdk.ParseException, ParseException, UserInfoErrorResponseException {
        OIDCProviderMetadata opMetadata = (OIDCProviderMetadata)this.configuration.getOpMetadataResolver().load();
        if (opMetadata.getUserInfoEndpointURI() != null && accessToken != null) {
            UserInfoRequest userInfoRequest = new UserInfoRequest(opMetadata.getUserInfoEndpointURI(), accessToken);
            HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
            this.configuration.configureHttpRequest(userInfoHttpRequest);
            HTTPResponse httpResponse = userInfoHttpRequest.send();
            LOGGER.debug("User info response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                ErrorObject error = ((UserInfoErrorResponse)userInfoResponse).getErrorObject();
                LOGGER.error("Bad User Info response, error={}", (Object)error);
                throw new UserInfoErrorResponseException(error.toString());
            }
            UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
            JWTClaimsSet userInfoClaimsSet = userInfoSuccessResponse.getUserInfo() != null ? userInfoSuccessResponse.getUserInfo().toJWTClaimsSet() : userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet();
            if (userInfoClaimsSet != null) {
                String subject = userInfoClaimsSet.getSubject();
                if (StringUtils.isBlank((CharSequence)profile.getId()) && StringUtils.isNotBlank((CharSequence)subject)) {
                    profile.setId(ProfileHelper.sanitizeIdentifier((Object)subject));
                }
                this.getProfileDefinition().convertAndAdd(profile, userInfoClaimsSet.getClaims(), null);
            } else {
                LOGGER.warn("Cannot retrieve claims from user info");
            }
        }
    }

    private void collectClaimsFromAccessTokenIfAny(OidcCredentials credentials, Nonce nonce, UserProfile profile) {
        try {
            AccessToken accessToken = credentials.toAccessToken();
            if (accessToken != null) {
                JWT accessTokenJwt = JWTParser.parse((String)accessToken.getValue());
                IDTokenClaimsSet accessTokenClaims = this.configuration.getOpMetadataResolver().getTokenValidator().validate(accessTokenJwt, nonce);
                for (Map.Entry entry : accessTokenClaims.toJWTClaimsSet().getClaims().entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                    this.getProfileDefinition().convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
                }
            }
        }
        catch (JOSEException | BadJOSEException | com.nimbusds.oauth2.sdk.ParseException | ParseException e) {
            LOGGER.debug(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new OidcException(e);
        }
    }
}

