/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.util.StringUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ResultObjectBasedEventFactory
extends EventFactorySupport
implements ResultEventFactory {
    @Override
    public Event createResultEvent(Object source, Object resultObject, RequestContext context) {
        if (resultObject == null) {
            return this.event(source, this.getNullEventId());
        }
        if (this.isBoolean(resultObject.getClass())) {
            return this.event(source, (Boolean)resultObject);
        }
        if (this.isEnum(resultObject.getClass())) {
            String eventId = EnumUtils.getEnumName(resultObject);
            return this.event(source, eventId, this.getResultAttributeName(), resultObject);
        }
        if (this.isString(resultObject.getClass())) {
            String resultString = (String)resultObject;
            if (StringUtils.hasText((String)resultString)) {
                return this.event(source, resultString);
            }
            return this.event(source, this.getNullEventId());
        }
        if (this.isEvent(resultObject.getClass())) {
            return (Event)resultObject;
        }
        throw new IllegalArgumentException("Cannot deal with result object '" + resultObject + "' of type '" + resultObject.getClass() + "'");
    }

    public boolean isMappedValueType(Class<?> type) {
        return this.isBoolean(type) || this.isEnum(type) || this.isString(type) || this.isEvent(type);
    }

    private boolean isBoolean(Class<?> type) {
        return Boolean.class.equals(type) || Boolean.TYPE.equals(type);
    }

    private boolean isEnum(Class<?> type) {
        return EnumUtils.isEnum(type);
    }

    private boolean isString(Class<?> type) {
        return String.class.equals(type);
    }

    private boolean isEvent(Class<?> type) {
        return Event.class.isAssignableFrom(type);
    }

    private static class EnumUtils {
        private EnumUtils() {
        }

        public static String getEnumName(Object enumValue) {
            return ((Enum)enumValue).name();
        }

        public static boolean isEnum(Class<?> type) {
            return Enum.class.isAssignableFrom(type);
        }
    }
}

