/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimerTest {
    private final MockTime time = new MockTime();

    @Test
    public void testTimerUpdate() {
        Timer timer = this.time.timer(500L);
        Assertions.assertEquals((long)500L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)500L, (long)timer.remainingMs());
        Assertions.assertEquals((long)0L, (long)timer.elapsedMs());
        this.time.sleep(100L);
        timer.update();
        Assertions.assertEquals((long)500L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)400L, (long)timer.remainingMs());
        Assertions.assertEquals((long)100L, (long)timer.elapsedMs());
        this.time.sleep(400L);
        timer.update(this.time.milliseconds());
        Assertions.assertEquals((long)500L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)0L, (long)timer.remainingMs());
        Assertions.assertEquals((long)500L, (long)timer.elapsedMs());
        Assertions.assertTrue((boolean)timer.isExpired());
        this.time.sleep(200L);
        timer.update(this.time.milliseconds());
        Assertions.assertTrue((boolean)timer.isExpired());
        Assertions.assertEquals((long)500L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)0L, (long)timer.remainingMs());
        Assertions.assertEquals((long)700L, (long)timer.elapsedMs());
    }

    @Test
    public void testTimerUpdateAndReset() {
        Timer timer = this.time.timer(500L);
        timer.sleep(200L);
        Assertions.assertEquals((long)500L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)300L, (long)timer.remainingMs());
        Assertions.assertEquals((long)200L, (long)timer.elapsedMs());
        timer.updateAndReset(400L);
        Assertions.assertEquals((long)400L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)400L, (long)timer.remainingMs());
        Assertions.assertEquals((long)0L, (long)timer.elapsedMs());
        timer.sleep(400L);
        Assertions.assertTrue((boolean)timer.isExpired());
        timer.updateAndReset(200L);
        Assertions.assertEquals((long)200L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)200L, (long)timer.remainingMs());
        Assertions.assertEquals((long)0L, (long)timer.elapsedMs());
        Assertions.assertFalse((boolean)timer.isExpired());
    }

    @Test
    public void testTimerResetUsesCurrentTime() {
        Timer timer = this.time.timer(500L);
        timer.sleep(200L);
        Assertions.assertEquals((long)300L, (long)timer.remainingMs());
        Assertions.assertEquals((long)200L, (long)timer.elapsedMs());
        this.time.sleep(300L);
        timer.reset(500L);
        Assertions.assertEquals((long)500L, (long)timer.remainingMs());
        timer.update();
        Assertions.assertEquals((long)200L, (long)timer.remainingMs());
    }

    @Test
    public void testTimerResetDeadlineUsesCurrentTime() {
        Timer timer = this.time.timer(500L);
        timer.sleep(200L);
        Assertions.assertEquals((long)300L, (long)timer.remainingMs());
        Assertions.assertEquals((long)200L, (long)timer.elapsedMs());
        timer.sleep(100L);
        timer.resetDeadline(this.time.milliseconds() + 200L);
        Assertions.assertEquals((long)200L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)200L, (long)timer.remainingMs());
        timer.sleep(100L);
        Assertions.assertEquals((long)200L, (long)timer.timeoutMs());
        Assertions.assertEquals((long)100L, (long)timer.remainingMs());
    }

    @Test
    public void testTimeoutOverflow() {
        Timer timer = this.time.timer(Long.MAX_VALUE);
        Assertions.assertEquals((long)(Long.MAX_VALUE - timer.currentTimeMs()), (long)timer.remainingMs());
        Assertions.assertEquals((long)0L, (long)timer.elapsedMs());
    }

    @Test
    public void testNonMonotonicUpdate() {
        Timer timer = this.time.timer(100L);
        long currentTimeMs = timer.currentTimeMs();
        timer.update(currentTimeMs - 1L);
        Assertions.assertEquals((long)currentTimeMs, (long)timer.currentTimeMs());
        Assertions.assertEquals((long)100L, (long)timer.remainingMs());
        Assertions.assertEquals((long)0L, (long)timer.elapsedMs());
    }

    @Test
    public void testTimerSleep() {
        Timer timer = this.time.timer(500L);
        long currentTimeMs = timer.currentTimeMs();
        timer.sleep(200L);
        Assertions.assertEquals((long)this.time.milliseconds(), (long)timer.currentTimeMs());
        Assertions.assertEquals((long)(currentTimeMs + 200L), (long)timer.currentTimeMs());
        timer.sleep(1000L);
        Assertions.assertEquals((long)this.time.milliseconds(), (long)timer.currentTimeMs());
        Assertions.assertEquals((long)(currentTimeMs + 500L), (long)timer.currentTimeMs());
        Assertions.assertTrue((boolean)timer.isExpired());
    }
}

