/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.audit;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;

public class SurrogateEligibilityVerificationAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    public String[] resolveFrom(JoinPoint auditableTarget, Object returnValue) {
        Objects.requireNonNull(returnValue, "AuditableExecutionResult must not be null");
        AuditableExecutionResult surrogateEligibilityResult = (AuditableExecutionResult)returnValue;
        String outcome = "Surrogate Authentication " + BooleanUtils.toString((boolean)surrogateEligibilityResult.getProperties().containsKey("eligible"), (String)"Eligible", (String)"Ineligible");
        HashMap<String, CallSite> values = new HashMap<String, CallSite>();
        values.put("result", (CallSite)((Object)outcome));
        surrogateEligibilityResult.getService().ifPresent(it -> values.put("service", (CallSite)((Object)it.getId())));
        surrogateEligibilityResult.getAuthentication().ifPresent(it -> values.put("selfPrincipal", (CallSite)it.getPrincipal()));
        values.put("surrogatePrincipal", (CallSite)surrogateEligibilityResult.getProperties().get("targetUserId"));
        return new String[]{this.auditFormat.serialize(values)};
    }
}

