/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.implementation;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class GroovySandbox {
    protected static final Logger LOG = LoggerFactory.getLogger(GroovySandbox.class);
    protected final Whitelist whitelist;

    public GroovySandbox(Whitelist whitelist) {
        this.whitelist = whitelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *(..))")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        SandboxInterceptor interceptor = new SandboxInterceptor(this.whitelist);
        try {
            interceptor.register();
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            interceptor.unregister();
        }
    }
}

