/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.rest;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialTrait;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.SurrogateAuthenticationException;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.configuration.model.support.surrogate.SurrogateAuthenticationProperties;
import org.apereo.cas.rest.factory.UsernamePasswordRestHttpRequestCredentialFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

public class SurrogateAuthenticationRestHttpRequestCredentialFactory
extends UsernamePasswordRestHttpRequestCredentialFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogateAuthenticationRestHttpRequestCredentialFactory.class);
    public static final String REQUEST_HEADER_SURROGATE_PRINCIPAL = "X-Surrogate-Principal";
    private final SurrogateAuthenticationService surrogateAuthenticationService;
    private final SurrogateAuthenticationProperties properties;

    public int getOrder() {
        return super.getOrder() - 1;
    }

    public List<Credential> fromRequest(HttpServletRequest request, MultiValueMap<String, String> requestBody) throws Throwable {
        String surrogateUsername;
        List credentials = super.fromRequest(request, requestBody);
        if (credentials.isEmpty()) {
            return credentials;
        }
        MutableCredential credential = (MutableCredential)FunctionUtils.doUnchecked(() -> this.extractCredential(request, credentials));
        if (credential == null) {
            LOGGER.trace("Not a surrogate authentication attempt, returning parent class credentials");
            return credentials;
        }
        Collection surrogateAccounts = this.surrogateAuthenticationService.getImpersonationAccounts(credential.getId(), Optional.empty());
        if (!surrogateAccounts.contains(surrogateUsername = credential.getCredentialMetadata().getTrait(SurrogateCredentialTrait.class).map(SurrogateCredentialTrait::getSurrogateUsername).orElseThrow())) {
            throw new SurrogateAuthenticationException("Unable to authorize surrogate authentication request for " + surrogateUsername);
        }
        return CollectionUtils.wrapList((Object[])new Credential[]{this.prepareCredential(request, (Credential)credential)});
    }

    protected MutableCredential extractCredential(HttpServletRequest request, List<Credential> credentials) {
        MutableCredential credential = (MutableCredential)credentials.getFirst();
        if (credential != null) {
            String separator;
            String surrogateUsername = request.getHeader(REQUEST_HEADER_SURROGATE_PRINCIPAL);
            if (StringUtils.isNotBlank((CharSequence)surrogateUsername)) {
                LOGGER.debug("Request surrogate principal [{}]", (Object)surrogateUsername);
                credential.getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateUsername));
                return credential;
            }
            String username = credential.getId();
            if (username.contains(separator = this.properties.getCore().getSeparator())) {
                surrogateUsername = username.substring(0, username.indexOf(separator));
                String realUsername = username.substring(username.indexOf(separator) + separator.length());
                credential.setId(realUsername);
                credential.getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateUsername));
                return credential;
            }
        }
        return null;
    }

    @Generated
    public SurrogateAuthenticationRestHttpRequestCredentialFactory(SurrogateAuthenticationService surrogateAuthenticationService, SurrogateAuthenticationProperties properties) {
        this.surrogateAuthenticationService = surrogateAuthenticationService;
        this.properties = properties;
    }
}

