/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.setup;

import jakarta.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.servlet.setup.AbstractMockMvcBuilder;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DefaultMockMvcBuilder
extends AbstractMockMvcBuilder<DefaultMockMvcBuilder> {
    private final WebApplicationContext webAppContext;

    protected DefaultMockMvcBuilder(WebApplicationContext webAppContext) {
        Assert.notNull((Object)webAppContext, (String)"WebApplicationContext is required");
        Assert.notNull((Object)webAppContext.getServletContext(), (String)"WebApplicationContext must have a ServletContext");
        this.webAppContext = webAppContext;
    }

    @Override
    protected WebApplicationContext initWebAppContext() {
        ServletContext servletContext = this.webAppContext.getServletContext();
        Assert.state((servletContext != null ? 1 : 0) != 0, (String)"No ServletContext");
        WebApplicationContext rootWac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (rootWac == null) {
            rootWac = this.webAppContext;
            for (ApplicationContext parent = this.webAppContext.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof WebApplicationContext) || parent.getParent() instanceof WebApplicationContext) continue;
                rootWac = parent;
                break;
            }
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)rootWac);
        }
        return this.webAppContext;
    }
}

