/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.atlas.AtlasDistributionSummary;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class AtlasDistSummaryBatchUpdater
implements DistributionSummary.BatchUpdater,
Consumer<Supplier<DistributionSummary>> {
    private Supplier<DistributionSummary> distSummarySupplier;
    private final int batchSize;
    private int count;
    private long total;
    private double totalOfSquares;
    private long max;

    AtlasDistSummaryBatchUpdater(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void accept(Supplier<DistributionSummary> distSummarySupplier) {
        this.distSummarySupplier = distSummarySupplier;
    }

    private AtlasDistributionSummary getDistributionSummary() {
        if (this.distSummarySupplier != null) {
            DistributionSummary d = this.distSummarySupplier.get();
            return d instanceof AtlasDistributionSummary ? (AtlasDistributionSummary)d : null;
        }
        return null;
    }

    public void record(long amount) {
        ++this.count;
        if (amount > 0L) {
            this.total += amount;
            this.totalOfSquares += (double)amount * (double)amount;
            if (amount > this.max) {
                this.max = amount;
            }
        }
        if (this.count >= this.batchSize) {
            this.flush();
        }
    }

    public void flush() {
        AtlasDistributionSummary distSummary = this.getDistributionSummary();
        if (distSummary != null) {
            distSummary.update(this.count, this.total, this.totalOfSquares, this.max);
            this.count = 0;
            this.total = 0L;
            this.totalOfSquares = 0.0;
            this.max = 0L;
        }
    }

    public void close() throws Exception {
        this.flush();
    }
}

