/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.resource.Resource;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.slf4j.Logger;

public class ResourceBackedMetadataResolver
extends AbstractReloadingMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResourceBackedMetadataResolver.class);
    @NonnullAfterInit
    private Resource metadataResource;

    public ResourceBackedMetadataResolver(@ParameterName(name="timer") @Nullable Timer timer, @ParameterName(name="resource") @Nonnull Resource resource) throws IOException {
        super(timer);
        if (!resource.exists()) {
            throw new IOException("Resource " + resource.getDescription() + " does not exist.");
        }
        this.metadataResource = resource;
    }

    public ResourceBackedMetadataResolver(@ParameterName(name="resource") @Nonnull Resource resource) throws IOException {
        if (!resource.exists()) {
            throw new IOException("Resource " + resource.getDescription() + " does not exist.");
        }
        this.metadataResource = resource;
    }

    @Override
    protected void doDestroy() {
        this.metadataResource = null;
        super.doDestroy();
    }

    @Override
    @Nonnull
    protected String getMetadataIdentifier() {
        return this.metadataResource.getDescription();
    }

    @Override
    @Nullable
    protected byte[] fetchMetadata() throws ResolverException {
        try {
            Instant metadataUpdateTime = Instant.ofEpochMilli(this.metadataResource.lastModified());
            this.log.debug("{} Resource {} was last modified {}", new Object[]{this.getLogPrefix(), this.metadataResource.getDescription(), metadataUpdateTime});
            if (this.getLastRefresh() == null || metadataUpdateTime.isAfter(this.getLastRefresh())) {
                return this.inputstreamToByteArray(this.metadataResource.getInputStream());
            }
            return null;
        }
        catch (IOException e) {
            String errorMsg = "Unable to read metadata file";
            this.log.error("{} {}: {}", new Object[]{this.getLogPrefix(), "Unable to read metadata file", e.getMessage()});
            throw new ResolverException("Unable to read metadata file", (Exception)e);
        }
    }
}

