/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.xml.eventing.EventSourceFactory;
import org.apache.synapse.config.xml.eventing.EventSourceSerializer;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;
import org.apache.synapse.eventing.SynapseEventSource;

public class EventSourceDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(EventSourceDeployer.class);

    @Override
    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("EventSource Deployment from file : " + fileName + " : Started"));
        }
        try {
            SynapseEventSource es = EventSourceFactory.createEventSource(artifactConfig, properties);
            if (es != null) {
                es.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EventSource named '" + es.getName() + "' has been built from the file " + fileName));
                }
                es.buildService(this.getSynapseConfiguration().getAxisConfiguration());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the EventSource : " + es.getName()));
                }
                this.getSynapseConfiguration().addEventSource(es.getName(), es);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EventSource Deployment from file : " + fileName + " : Completed"));
                }
                log.info((Object)("EventSource named '" + es.getName() + "' has been deployed from file : " + fileName));
                return es.getName();
            }
            this.handleSynapseArtifactDeploymentError("EventSource Deployment Failed. The artifact described in the file " + fileName + " is not an EventSource");
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("EventSource Deployment from the file : " + fileName + " : Failed.", e);
        }
        return null;
    }

    @Override
    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("EventSource Update from file : " + fileName + " : Started"));
        }
        try {
            SynapseEventSource es = EventSourceFactory.createEventSource(artifactConfig, properties);
            if (es != null) {
                es.setFileName(new File(fileName).getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EventSource named '" + es.getName() + "' has been built from the file " + fileName));
                }
                this.getSynapseConfiguration().removeEventSource(existingArtifactName);
                if (!existingArtifactName.equals(es.getName())) {
                    log.info((Object)("EventSource named " + existingArtifactName + " has been Undeployed"));
                }
                es.buildService(this.getSynapseConfiguration().getAxisConfiguration());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialized the EventSource : " + es.getName()));
                }
                this.getSynapseConfiguration().addEventSource(es.getName(), es);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EventSource " + (existingArtifactName.equals(es.getName()) ? "update" : "deployment") + " from file : " + fileName + " : Completed"));
                }
                log.info((Object)("EventSource named '" + es.getName() + "' has been " + (existingArtifactName.equals(es.getName()) ? "update" : "deployed") + " from file : " + fileName));
                return es.getName();
            }
            this.handleSynapseArtifactDeploymentError("EventSource Update Failed. The artifact described in the file " + fileName + " is not a EventSource");
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("EventSource Update from the file : " + fileName + " : Failed.", (Exception)((Object)e));
        }
        catch (AxisFault e) {
            this.handleSynapseArtifactDeploymentError("Error while initializing the event source", (Exception)((Object)e));
        }
        return null;
    }

    @Override
    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("EventSource Undeployment of the event source named : " + artifactName + " : Started"));
        }
        try {
            SynapseEventSource es = this.getSynapseConfiguration().getEventSource(artifactName);
            if (es != null) {
                this.getSynapseConfiguration().removeEventSource(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EventSource Undyou neeeployment of the EventSource named : " + artifactName + " : Completed"));
                }
                log.info((Object)("EventSource named '" + es.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Event source " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("EventSource Undeployement of EventSource named : " + artifactName + " : Failed", e);
        }
    }

    @Override
    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the EventSource with name : " + artifactName + " : Started"));
        }
        try {
            SynapseEventSource es = this.getSynapseConfiguration().getEventSource(artifactName);
            OMElement esElem = EventSourceSerializer.serializeEventSource(null, es);
            if (es.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "event-sources" + File.separator + es.getFileName();
                this.writeToFile(esElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the EventSource with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("EventSource named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the EventSource named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the EventSource named '" + artifactName + "' has failed", e);
        }
    }
}

