/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.sql.Timestamp;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.membership.McastService;
import org.apache.catalina.tribes.transport.ReplicationTransmitter;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.transport.nio.NioReceiver;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.Logs;

public class ChannelCoordinator
extends ChannelInterceptorBase
implements MessageListener {
    private ChannelReceiver clusterReceiver = new NioReceiver();
    private ChannelSender clusterSender = new ReplicationTransmitter();
    private MembershipService membershipService = new McastService();
    protected int optionFlag = 7;
    private int startLevel = 0;

    public int getOptionFlag() {
        return this.optionFlag;
    }

    public void setOptionFlag(int flag) {
        this.optionFlag = flag;
    }

    public ChannelCoordinator() {
    }

    public ChannelCoordinator(ChannelReceiver receiver, ChannelSender sender, MembershipService service) {
        this();
        this.setClusterReceiver(receiver);
        this.setClusterSender(sender);
        this.setMembershipService(service);
    }

    public void sendMessage(Member[] destination, ChannelMessage msg, InterceptorPayload payload) throws ChannelException {
        if (destination == null) {
            destination = this.membershipService.getMembers();
        }
        this.clusterSender.sendMessage(msg, destination);
        if (Logs.MESSAGES.isTraceEnabled()) {
            Logs.MESSAGES.trace((Object)("ChannelCoordinator - Sent msg:" + new UniqueId(msg.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + Arrays.toNameString(destination)));
        }
    }

    public void start(int svc) throws ChannelException {
        this.internalStart(svc);
    }

    public void stop(int svc) throws ChannelException {
        this.internalStop(svc);
    }

    protected synchronized void internalStart(int svc) throws ChannelException {
        try {
            boolean valid = false;
            svc &= 0xF;
            if (this.startLevel == 15) {
                return;
            }
            if (svc == 0) {
                return;
            }
            if (svc == (svc & this.startLevel)) {
                throw new ChannelException("Channel already started for level:" + svc);
            }
            if (1 == (svc & 1)) {
                this.clusterReceiver.setMessageListener(this);
                this.clusterReceiver.start();
                this.membershipService.setLocalMemberProperties(this.getClusterReceiver().getHost(), this.getClusterReceiver().getPort());
                valid = true;
            }
            if (2 == (svc & 2)) {
                this.clusterSender.start();
                valid = true;
            }
            if (4 == (svc & 4)) {
                this.membershipService.setMembershipListener(this);
                this.membershipService.start(4);
                valid = true;
            }
            if (8 == (svc & 8)) {
                this.membershipService.start(8);
                valid = true;
            }
            if (!valid) {
                throw new IllegalArgumentException("Invalid start level, valid levels are:SND_RX_SEQ,SND_TX_SEQ,MBR_TX_SEQ,MBR_RX_SEQ");
            }
            this.startLevel |= svc;
        }
        catch (ChannelException cx) {
            throw cx;
        }
        catch (Exception x) {
            throw new ChannelException(x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void internalStop(int svc) throws ChannelException {
        try {
            try {
                svc &= 0xF;
                if (this.startLevel == 0) {
                    return;
                }
                if (svc == 0) {
                    return;
                }
                boolean valid = false;
                if (1 == (svc & 1)) {
                    this.clusterReceiver.stop();
                    this.clusterReceiver.setMessageListener(null);
                    valid = true;
                }
                if (2 == (svc & 2)) {
                    this.clusterSender.stop();
                    valid = true;
                }
                if (4 == (svc & 4)) {
                    this.membershipService.stop(4);
                    this.membershipService.setMembershipListener(null);
                    valid = true;
                }
                if (8 == (svc & 8)) {
                    valid = true;
                    this.membershipService.stop(8);
                }
                if (!valid) {
                    throw new IllegalArgumentException("Invalid start level, valid levels are:SND_RX_SEQ,SND_TX_SEQ,MBR_TX_SEQ,MBR_RX_SEQ");
                }
                this.startLevel &= ~svc;
                return;
            }
            catch (Exception x) {
                throw new ChannelException(x);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            throw throwable;
        }
    }

    public void memberAdded(Member member) {
        SenderState.getSenderState(member);
        super.memberAdded(member);
    }

    public void memberDisappeared(Member member) {
        SenderState.removeSenderState(member);
        super.memberDisappeared(member);
    }

    public void messageReceived(ChannelMessage msg) {
        if (Logs.MESSAGES.isTraceEnabled()) {
            Logs.MESSAGES.trace((Object)("ChannelCoordinator - Received msg:" + new UniqueId(msg.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " from " + msg.getAddress().getName()));
        }
        super.messageReceived(msg);
    }

    public ChannelReceiver getClusterReceiver() {
        return this.clusterReceiver;
    }

    public ChannelSender getClusterSender() {
        return this.clusterSender;
    }

    public MembershipService getMembershipService() {
        return this.membershipService;
    }

    public void setClusterReceiver(ChannelReceiver clusterReceiver) {
        if (clusterReceiver != null) {
            this.clusterReceiver = clusterReceiver;
            this.clusterReceiver.setMessageListener(this);
        } else {
            if (this.clusterReceiver != null) {
                this.clusterReceiver.setMessageListener(null);
            }
            this.clusterReceiver = null;
        }
    }

    public void setClusterSender(ChannelSender clusterSender) {
        this.clusterSender = clusterSender;
    }

    public void setMembershipService(MembershipService membershipService) {
        this.membershipService = membershipService;
        this.membershipService.setMembershipListener(this);
    }

    public void heartbeat() {
        if (this.clusterSender != null) {
            this.clusterSender.heartbeat();
        }
        super.heartbeat();
    }

    public boolean hasMembers() {
        return this.getMembershipService().hasMembers();
    }

    public Member[] getMembers() {
        return this.getMembershipService().getMembers();
    }

    public Member getMember(Member mbr) {
        return this.getMembershipService().getMember(mbr);
    }

    public Member getLocalMember(boolean incAlive) {
        return this.getMembershipService().getLocalMember(incAlive);
    }
}

