/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.config;

import org.apache.synapse.transport.utils.config.HttpTransportConfiguration;

public class PassThroughConfiguration
extends HttpTransportConfiguration {
    private static final int DEFAULT_WORKER_POOL_SIZE_CORE = 40;
    private static final int DEFAULT_WORKER_POOL_SIZE_MAX = 200;
    private static final int DEFAULT_WORKER_THREAD_KEEPALIVE_SEC = 60;
    private static final int DEFAULT_WORKER_POOL_QUEUE_LENGTH = -1;
    private static final int DEFAULT_IO_THREADS_PER_REACTOR = Runtime.getRuntime().availableProcessors();
    private static PassThroughConfiguration _instance = new PassThroughConfiguration();

    private PassThroughConfiguration() {
        super("passthru-http");
    }

    public static PassThroughConfiguration getInstance() {
        return _instance;
    }

    public int getWorkerPoolCoreSize() {
        return this.getIntProperty("worker_pool_size_core", 40);
    }

    public int getWorkerPoolMaxSize() {
        return this.getIntProperty("worker_pool_size_max", 200);
    }

    public int getWorkerThreadKeepaliveSec() {
        return this.getIntProperty("worker_thread_keepalive_sec", 60);
    }

    public int getWorkerPoolQueueLen() {
        return this.getIntProperty("worker_pool_queue_length", -1);
    }

    @Override
    protected int getThreadsPerReactor() {
        return this.getIntProperty("io_threads_per_reactor", DEFAULT_IO_THREADS_PER_REACTOR);
    }

    public String getPreserveHttpHeaders() {
        return this.getStringProperty("http.headers.preserve", "");
    }
}

