/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.bean.BeanMediator;

public class BeanMediatorSerializer
extends AbstractMediatorSerializer {
    private static final String BEAN = "bean";

    @Override
    public OMElement serializeSpecificMediator(Mediator m) {
        if (!(m instanceof BeanMediator)) {
            this.handleException("Unsupported mediator was passed in for serialization: " + m.getType());
            return null;
        }
        BeanMediator mediator = (BeanMediator)m;
        OMElement mediatorElem = fac.createOMElement(BEAN, synNS);
        BeanMediatorSerializer.saveTracingState(mediatorElem, mediator);
        if (mediator.getAction() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("action", nullNS, mediator.getAction().toString()));
        } else {
            this.handleException();
        }
        if (mediator.getVarName() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("var", nullNS, mediator.getVarName()));
        } else {
            this.handleException();
        }
        switch (mediator.getAction()) {
            case CREATE: {
                this.serializeCreateBeanCase(mediatorElem, mediator);
                break;
            }
            case REMOVE: {
                break;
            }
            case SET_PROPERTY: {
                this.serializeSetPropertyCase(mediatorElem, mediator);
                break;
            }
            case GET_PROPERTY: {
                this.serializeGetPropertyCase(mediatorElem, mediator);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return mediatorElem;
    }

    private void serializeCreateBeanCase(OMElement mediatorElem, BeanMediator mediator) {
        if (mediator.getClazz() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("class", nullNS, mediator.getClazz().getName()));
        } else {
            this.handleException();
        }
        if (!mediator.isReplace()) {
            mediatorElem.addAttribute(fac.createOMAttribute("replace", nullNS, Boolean.toString(false)));
        }
    }

    private void serializeSetPropertyCase(OMElement mediatorElem, BeanMediator mediator) {
        this.serializePropertyName(mediatorElem, mediator);
        if (mediator.getValue() != null) {
            new ValueSerializer().serializeValue(mediator.getValue(), "value", mediatorElem);
        } else {
            this.handleException();
        }
    }

    private void serializeGetPropertyCase(OMElement mediatorElem, BeanMediator mediator) {
        this.serializePropertyName(mediatorElem, mediator);
        if (mediator.getTarget() != null) {
            mediator.getTarget().serializeTarget("target", mediatorElem);
        } else {
            this.handleException();
        }
    }

    private void serializePropertyName(OMElement mediatorElem, BeanMediator mediator) {
        if (mediator.getPropertyName() != null) {
            mediatorElem.addAttribute(fac.createOMAttribute("property", nullNS, mediator.getPropertyName()));
        } else {
            this.handleException();
        }
    }

    @Override
    public String getMediatorClassName() {
        return BeanMediator.class.getName();
    }

    private void handleException() {
        this.handleException("Invalid bean mediator was passed in for serialization");
    }
}

