/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn;

import java.net.InetSocketAddress;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.reactor.ssl.SSLIOSession;
import org.apache.http.nio.reactor.ssl.SSLMode;
import org.apache.http.nio.reactor.ssl.SSLSetupHandler;
import org.apache.synapse.transport.utils.conn.SynapseNHttpClientConnectionFactory;

public class SynapseNHttpSSLClientConnectionFactory
extends SynapseNHttpClientConnectionFactory {
    private SSLContext sslContext;
    private SSLSetupHandler sslSetupHandler;
    private Map<String, SSLContext> customContexts;

    public SynapseNHttpSSLClientConnectionFactory(ConnectionConfig config, SSLContext sslContext, SSLSetupHandler sslSetupHandler, Map<String, SSLContext> customContexts) {
        super(config);
        this.sslContext = sslContext;
        this.sslSetupHandler = sslSetupHandler;
        this.customContexts = customContexts;
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession session) {
        SSLIOSession ssliosession = new SSLIOSession(session, SSLMode.CLIENT, this.getSSLContext(session), this.sslSetupHandler);
        session.setAttribute("http.session.ssl", (Object)ssliosession);
        return super.createConnection((IOSession)ssliosession);
    }

    private SSLContext getSSLContext(IOSession session) {
        InetSocketAddress address = (InetSocketAddress)session.getRemoteAddress();
        String host = address.getHostName() + ":" + address.getPort();
        SSLContext customContext = null;
        if (this.customContexts != null) {
            customContext = this.customContexts.get(host);
        }
        if (customContext == null) {
            customContext = this.sslContext;
        }
        return customContext;
    }
}

