/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.osgi.OsgiHostFactory;
import org.apache.struts2.osgi.host.OsgiHost;

public class StrutsOsgiListener
implements ServletContextListener {
    public static final String OSGI_HOST = "__struts_osgi_host";
    public static final String PLATFORM_KEY = "struts.osgi.host";
    private static final Logger LOG = LogManager.getLogger(StrutsOsgiListener.class);
    private OsgiHost osgiHost;

    public void contextInitialized(ServletContextEvent sce) {
        LOG.trace("StrutsOsgiListener attempting to start. ContextInitialized called.  SCE: [{}]", (Object)sce);
        if (sce == null) {
            throw new StrutsException("ServletContextEvent is null.  Cannot init OSGi platform!");
        }
        ServletContext servletContext = sce.getServletContext();
        LOG.trace("StrutsOsgiListener attempting to start. ServletContext: [{}]", (Object)servletContext);
        if (servletContext == null) {
            throw new StrutsException("ServletContext is null within the ServletContextEvent.  Cannot init OSGi platform!");
        }
        String platform = servletContext.getInitParameter(PLATFORM_KEY);
        LOG.debug("Defined OSGi platform as [{}] via context-param [{}]", (Object)platform, (Object)PLATFORM_KEY);
        try {
            this.osgiHost = OsgiHostFactory.createOsgiHost(platform);
            LOG.trace("StrutsOsgiListener attempting to start. OSGi Host constructed: [{}]", (Object)this.osgiHost);
        }
        catch (Throwable t) {
            throw new StrutsException("StrutsOsgiListener failed to create an OSGi Host!", t);
        }
        servletContext.setAttribute(OSGI_HOST, (Object)this.osgiHost);
        try {
            this.osgiHost.init(servletContext);
        }
        catch (Exception e) {
            throw new StrutsException("StrutsOsgiListener failed to initialize the OSGi Host platform!", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            this.osgiHost.destroy();
        }
        catch (Exception e) {
            throw new StrutsException("StrutsOsgiListener cannot stop the OSGi Host platform!", (Throwable)e);
        }
    }
}

