/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.alerts;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.fs.DummyFileSystem;
import com.google.gxp.compiler.fs.FileRef;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class SourcePosition
implements Serializable {
    private final FileRef source;
    private final int line;
    private final int column;

    public SourcePosition(FileRef source) {
        this.source = Preconditions.checkNotNull(source);
        this.line = 0;
        this.column = 0;
    }

    public SourcePosition(FileRef source, int line, int column) {
        this.source = Preconditions.checkNotNull(source);
        if (line < 1) {
            throw new IllegalArgumentException("line must be >= 1");
        }
        this.line = line;
        if (column < 1) {
            throw new IllegalArgumentException("column must be >= 1");
        }
        this.column = column;
    }

    public SourcePosition(String sourceName) {
        this(DummyFileSystem.INSTANCE.parseFilename(Preconditions.checkNotNull(sourceName)));
    }

    public SourcePosition(String sourceName, int line, int column) {
        this(DummyFileSystem.INSTANCE.parseFilename(Preconditions.checkNotNull(sourceName)), line, column);
    }

    public FileRef getSource() {
        return this.source;
    }

    public String getSourceName() {
        return this.source.toFilename();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return this.getSource().toRelativeFilename() + ":" + this.line + ":" + this.column + ":" + this.line + ":" + this.column;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SourcePosition && this.equals((SourcePosition)that);
    }

    private boolean equals(SourcePosition that) {
        return Objects.equal(this.source.toFilename(), that.source.toFilename()) && this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hashCode(this.source.toFilename(), this.line, this.column);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializableSourcePosition(this.getSourceName(), this.line, this.column);
    }

    private static class SerializableSourcePosition
    implements Serializable {
        private final int line;
        private final int column;
        private final String sourceName;

        private SerializableSourcePosition(String sourceName, int line, int column) {
            this.line = line;
            this.column = column;
            this.sourceName = sourceName;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        private Object readResolve() throws ObjectStreamException {
            return this.line > 0 && this.column > 0 ? new SourcePosition(this.sourceName, this.line, this.column) : new SourcePosition(this.sourceName);
        }
    }
}

