/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.ServerContext;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.extend.Builder;

public class DefaultBuilder<T>
implements Builder<T> {
    private static final Map<Container, Map<Class<?>, Object>> lookup = new HashMap();
    private final Class<? extends T> created;
    private static final Log log = LogFactory.getLog(DefaultBuilder.class);

    public DefaultBuilder(Class<? extends T> created) {
        this.created = created;
    }

    @Override
    public T get() {
        ServerContext serverContext = ServerContextFactory.get();
        return this.get(serverContext);
    }

    @Override
    public T get(ServerContext serverContext) {
        Container container = serverContext.getContainer();
        Map<Class<?>, Object> contextObjects = lookup.get(container);
        if (contextObjects == null) {
            throw new IllegalStateException("The passed ServerContext in unknown to the DefaultBuilder");
        }
        Object t = contextObjects.get(this.created);
        if (t == null) {
            throw new IllegalStateException("The DefaultBuilder knows nothing about objects of type " + this.created.getName());
        }
        return (T)t;
    }

    @Override
    public T attach(Container container) {
        try {
            T t = container.newInstance(this.created);
            Map<Class<?>, Object> contextObjects = lookup.get(container);
            if (contextObjects == null) {
                contextObjects = new HashMap();
                lookup.put(container, contextObjects);
            }
            contextObjects.put(this.created, t);
            return t;
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to create an instance of " + this.created.getName()));
            throw new RuntimeException(ex);
        }
    }
}

