/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.impl.DefaultConfiguration;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.fs.DefaultFileManagerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.config.StrutsXmlConfigurationProvider;
import org.apache.struts2.osgi.PackageLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundlePackageLoader
implements PackageLoader {
    private static final Logger LOG = LogManager.getLogger(BundlePackageLoader.class);
    private Container contextContainer = null;

    @Override
    @Deprecated
    public List<PackageConfig> loadPackages(Bundle bundle, BundleContext bundleContext, ObjectFactory objectFactory, FileManagerFactory fileManagerFactory, Map<String, PackageConfig> pkgConfigs) throws ConfigurationException {
        if (pkgConfigs == null) {
            throw new IllegalArgumentException("Cannot load packages from a null package configuration");
        }
        DefaultConfiguration config = new DefaultConfiguration("struts.xml");
        LOG.trace("LoadPackages - After config constructed.  Before BundleConfigurationProvider constructed");
        BundleConfigurationProvider prov = new BundleConfigurationProvider("struts.xml", bundle, bundleContext);
        LOG.trace("LoadPackages - After BundleConfigurationProvider constructed.  Before config.addPackageConfig loop");
        for (PackageConfig pkg : pkgConfigs.values()) {
            config.addPackageConfig(pkg.getName(), pkg);
        }
        LOG.trace("LoadPackages - After config.addPackageConfig loop.  Before prov.setObjectFactory()");
        prov.setObjectFactory(objectFactory);
        if (fileManagerFactory == null || fileManagerFactory.getFileManager() == null) {
            LOG.warn("LoadPackages - FileManagerFactory parameter is null or produces a null FileManager, replacing with a new DefaultFileManagerFactory instance");
            DefaultFileManagerFactory defaultFileManagerFactory = new DefaultFileManagerFactory();
            Container container = this.getContextContainer();
            if (container == null) {
                LOG.warn("LoadPackages - Config Container is null.  May cause a NPE to be thrown");
            } else {
                container.inject((Object)defaultFileManagerFactory);
            }
            prov.setFileManagerFactory((FileManagerFactory)defaultFileManagerFactory);
        } else {
            prov.setFileManagerFactory(fileManagerFactory);
        }
        LOG.trace("LoadPackages - After prov.setFileManagerFactory().  Before init()");
        prov.init((Configuration)config);
        LOG.trace("LoadPackages - After prov.init().  Before loadPackages()");
        prov.loadPackages();
        LOG.trace("LoadPackages - After prov.loadPackages().  Before config.getPackageConfigs().values()");
        ArrayList<PackageConfig> list = new ArrayList<PackageConfig>(config.getPackageConfigs().values());
        LOG.trace("LoadPackages - After config.getPackageConfigs().  Before pkgConfigs.values()");
        list.removeAll(pkgConfigs.values());
        return list;
    }

    @Override
    public List<PackageConfig> loadPackages(Container container, Bundle bundle, BundleContext bundleContext, ObjectFactory objectFactory, FileManagerFactory fileManagerFactory, Map<String, PackageConfig> pkgConfigs) throws ConfigurationException {
        this.setContextContainer(container);
        return this.loadPackages(bundle, bundleContext, objectFactory, fileManagerFactory, pkgConfigs);
    }

    protected Container getContextContainer() {
        return this.contextContainer;
    }

    protected void setContextContainer(Container contextContainer) {
        this.contextContainer = contextContainer;
    }

    static class EnumeratorIterator<E>
    implements Iterator<E> {
        Enumeration<E> e = null;

        public EnumeratorIterator(Enumeration<E> e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public E next() {
            return this.e.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class BundleConfigurationProvider
    extends StrutsXmlConfigurationProvider {
        private Bundle bundle;
        private BundleContext bundleContext;

        public BundleConfigurationProvider(String filename, Bundle bundle, BundleContext bundleContext) {
            super(filename, false, null);
            this.bundle = bundle;
            this.bundleContext = bundleContext;
        }

        public BundleConfigurationProvider(String filename) {
            super(filename, false, null);
        }

        protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
            if (this.bundle == null) {
                throw new IllegalStateException("Unable to get configuration URLs, current Bundle reference is null");
            }
            Enumeration e = this.bundle.getResources("struts.xml");
            return e.hasMoreElements() ? new EnumeratorIterator(e) : null;
        }
    }
}

