/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.history.FsJobArchivist;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.helper.KubernetesDeploymentHelper$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JArray;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.immutable.List;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class FlinkHistoryArchives$
implements Logger {
    public static FlinkHistoryArchives$ MODULE$;
    private transient DefaultFormats$ formats;
    private final String FAILED_STATE;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FlinkHistoryArchives$();
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private DefaultFormats$ formats$lzycompute() {
        FlinkHistoryArchives$ flinkHistoryArchives$ = this;
        synchronized (flinkHistoryArchives$) {
            if (!this.bitmap$trans$0) {
                this.formats = DefaultFormats$.MODULE$;
                this.bitmap$trans$0 = true;
            }
        }
        return this.formats;
    }

    public DefaultFormats$ formats() {
        return !this.bitmap$trans$0 ? this.formats$lzycompute() : this.formats;
    }

    public String getJobStateFromArchiveFile(TrackId trackId) {
        String string;
        Object object = new Object();
        try {
            string = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String string;
                Predef$.MODULE$.require(trackId.jobId() != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] getJobStateFromArchiveFile: JobId cannot be null.");
                String archiveDir = trackId.properties().getProperty(JobManagerOptions.ARCHIVE_DIR.key());
                if (archiveDir == null) {
                    string = FlinkHistoryArchives$.MODULE$.FAILED_STATE;
                } else {
                    String string2;
                    Path archivePath = new Path(archiveDir, trackId.jobId());
                    Collection collection = FsJobArchivist.getArchivedJsons((Path)archivePath);
                    if (collection.isEmpty()) {
                        string2 = FlinkHistoryArchives$.MODULE$.FAILED_STATE;
                    } else {
                        JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(collection).foreach((Function1 & Serializable & scala.Serializable)a -> {
                            FlinkHistoryArchives$.$anonfun$getJobStateFromArchiveFile$3(trackId, object, a);
                            return BoxedUnit.UNIT;
                        });
                        string2 = FlinkHistoryArchives$.MODULE$.FAILED_STATE;
                    }
                    string = string2;
                }
                return string;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> FlinkHistoryArchives$.MODULE$.FAILED_STATE);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                string = (String)ex.value();
            }
            throw ex;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$getJobStateFromArchiveFile$6(TrackId trackId$4, Object nonLocalReturnKey3$1, JValue x) {
        String jid;
        String string = jid = (String)ExtractableJsonAstNode$.MODULE$.extractOpt$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(x), "jid")), (Formats)MODULE$.formats(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.$conforms());
        String string2 = trackId$4.jobId();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NonLocalReturnControl(nonLocalReturnKey3$1, ExtractableJsonAstNode$.MODULE$.extractOpt$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(x), "state")), (Formats)MODULE$.formats(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.$conforms()));
        }
    }

    public static final /* synthetic */ void $anonfun$getJobStateFromArchiveFile$3(TrackId trackId$4, Object nonLocalReturnKey3$1, ArchivedJson a) {
        String string = a.getPath();
        String string2 = new StringBuilder(17).append("/jobs/").append(trackId$4.jobId()).append("/exceptions").toString();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.parse((Object)a.getJson(), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                JValue ok = (JValue)success.value();
                String log = (String)ExtractableJsonAstNode$.MODULE$.extractOpt$extension(package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(ok), "root-exception")), (Formats)MODULE$.formats(), ManifestFactory$.MODULE$.classType(String.class)).orNull(Predef$.MODULE$.$conforms());
                if (log != null) {
                    String path = KubernetesDeploymentHelper$.MODULE$.getJobErrorLog(trackId$4.jobId());
                    File file = new File(path);
                    Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)log);
                    Predef$.MODULE$.println((Object)new StringBuilder(13).append(" error path: ").append(path).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            String string3 = a.getPath();
            String string4 = "/jobs/overview";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JsonMethods$.MODULE$.parse((Object)a.getJson(), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JValue ok = (JValue)success.value();
                    JValue jValue = MonadicJValue$.MODULE$.$bslash$extension0(package$.MODULE$.jvalue2monadic(ok), "jobs");
                    boolean bl = JNothing$.MODULE$.equals(jValue) ? true : JNull$.MODULE$.equals(jValue);
                    if (bl) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (jValue instanceof JArray) {
                        JArray jArray = (JArray)jValue;
                        List arr = jArray.arr();
                        arr.foreach((Function1 & Serializable & scala.Serializable)x -> {
                            FlinkHistoryArchives$.$anonfun$getJobStateFromArchiveFile$6(trackId$4, nonLocalReturnKey3$1, x);
                            return BoxedUnit.UNIT;
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)try_);
                }
            }
        }
    }

    private FlinkHistoryArchives$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
        this.FAILED_STATE = "FAILED";
    }
}

