/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;

public class ConsumedPartitionGroup
implements Iterable<IntermediateResultPartitionID> {
    private final List<IntermediateResultPartitionID> resultPartitions;
    private final AtomicInteger unfinishedPartitions;
    private final IntermediateDataSetID intermediateDataSetID;

    private ConsumedPartitionGroup(List<IntermediateResultPartitionID> resultPartitions) {
        Preconditions.checkArgument((resultPartitions.size() > 0 ? 1 : 0) != 0, (Object)"The size of result partitions in the ConsumedPartitionGroup should be larger than 0.");
        this.intermediateDataSetID = resultPartitions.get(0).getIntermediateDataSetID();
        for (IntermediateResultPartitionID resultPartition : resultPartitions) {
            Preconditions.checkArgument((boolean)resultPartition.getIntermediateDataSetID().equals(this.intermediateDataSetID));
        }
        this.resultPartitions = resultPartitions;
        this.unfinishedPartitions = new AtomicInteger(resultPartitions.size());
    }

    public static ConsumedPartitionGroup fromMultiplePartitions(List<IntermediateResultPartitionID> resultPartitions) {
        return new ConsumedPartitionGroup(resultPartitions);
    }

    public static ConsumedPartitionGroup fromSinglePartition(IntermediateResultPartitionID resultPartition) {
        return new ConsumedPartitionGroup(Collections.singletonList(resultPartition));
    }

    @Override
    public Iterator<IntermediateResultPartitionID> iterator() {
        return this.resultPartitions.iterator();
    }

    public int size() {
        return this.resultPartitions.size();
    }

    public boolean isEmpty() {
        return this.resultPartitions.isEmpty();
    }

    public IntermediateResultPartitionID getFirst() {
        return this.iterator().next();
    }

    public IntermediateDataSetID getIntermediateDataSetID() {
        return this.intermediateDataSetID;
    }

    public int partitionUnfinished() {
        return this.unfinishedPartitions.incrementAndGet();
    }

    public int partitionFinished() {
        return this.unfinishedPartitions.decrementAndGet();
    }

    @VisibleForTesting
    public int getNumberOfUnfinishedPartitions() {
        return this.unfinishedPartitions.get();
    }

    public boolean areAllPartitionsFinished() {
        return this.unfinishedPartitions.get() == 0;
    }
}

