/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.internal.InternalAggregatingState;
import org.apache.flink.runtime.state.ttl.AbstractTtlState;
import org.apache.flink.runtime.state.ttl.TtlAggregateFunction;
import org.apache.flink.runtime.state.ttl.TtlStateContext;
import org.apache.flink.runtime.state.ttl.TtlValue;

class TtlAggregatingState<K, N, IN, ACC, OUT>
extends AbstractTtlState<K, N, ACC, TtlValue<ACC>, InternalAggregatingState<K, N, IN, TtlValue<ACC>, OUT>>
implements InternalAggregatingState<K, N, IN, ACC, OUT> {
    TtlAggregatingState(TtlStateContext<InternalAggregatingState<K, N, IN, TtlValue<ACC>, OUT>, ACC> ttlStateContext, TtlAggregateFunction<IN, ACC, OUT> aggregateFunction) {
        super(ttlStateContext);
        aggregateFunction.stateClear = () -> ((InternalAggregatingState)((InternalAggregatingState)ttlStateContext.original)).clear();
        aggregateFunction.updater = ((InternalAggregatingState)ttlStateContext.original)::updateInternal;
    }

    public OUT get() throws Exception {
        this.accessCallback.run();
        return (OUT)((InternalAggregatingState)this.original).get();
    }

    public void add(IN value) throws Exception {
        this.accessCallback.run();
        ((InternalAggregatingState)this.original).add(value);
    }

    @Override
    @Nullable
    public TtlValue<ACC> getUnexpiredOrNull(@Nonnull TtlValue<ACC> ttlValue) {
        return this.expired(ttlValue) ? null : ttlValue;
    }

    @Override
    public void clear() {
        ((InternalAggregatingState)this.original).clear();
    }

    @Override
    public ACC getInternal() throws Exception {
        return (ACC)this.getWithTtlCheckAndUpdate(((InternalAggregatingState)this.original)::getInternal, ((InternalAggregatingState)this.original)::updateInternal);
    }

    @Override
    public void updateInternal(ACC valueToStore) throws Exception {
        ((InternalAggregatingState)this.original).updateInternal(this.wrapWithTs(valueToStore));
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        ((InternalAggregatingState)this.original).mergeNamespaces(target, sources);
    }
}

