/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.Serializable;
import org.json4s.JArray;
import org.json4s.JBool;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JInt;
import org.json4s.JLong;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JSet;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u001d3A\u0001B\u0003\u0001\u0019!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0001W!)\u0011\t\u0001C!\u0005\n\u0001\"JV1mk\u0016\u001cVM]5bY&TXM\u001d\u0006\u0003\r\u001d\tqA[1dWN|gN\u0003\u0002\t\u0013\u00051!n]8oiMT\u0011AC\u0001\u0004_J<7\u0001A\n\u0003\u00015\u00012A\u0004\f\u0019\u001b\u0005y!B\u0001\t\u0012\u0003!!\u0017\r^1cS:$'B\u0001\u0004\u0013\u0015\t\u0019B#A\u0005gCN$XM\u001d=nY*\tQ#A\u0002d_6L!aF\b\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>feB\u0011\u0011d\t\b\u00035\u0005r!a\u0007\u0011\u000f\u0005qyR\"A\u000f\u000b\u0005yY\u0011A\u0002\u001fs_>$h(C\u0001\u000b\u0013\tA\u0011\"\u0003\u0002#\u000f\u00059!j]8o\u0003N#\u0016B\u0001\u0013&\u0005\u0019Qe+\u00197vK*\u0011!eB\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003\u0015\t\u0011b]3sS\u0006d\u0017N_3\u0015\t1\u0012D\u0007\u0010\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG\u000fC\u00034\u0005\u0001\u0007\u0001$A\u0003wC2,X\rC\u00036\u0005\u0001\u0007a'\u0001\u0003kg>t\u0007CA\u001c;\u001b\u0005A$BA\u001d\u0012\u0003\u0011\u0019wN]3\n\u0005mB$!\u0004&t_:<UM\\3sCR|'\u000fC\u0003>\u0005\u0001\u0007a(\u0001\u0005qe>4\u0018\u000eZ3s!\tqq(\u0003\u0002A\u001f\t\u00112+\u001a:jC2L'0\u001a:Qe>4\u0018\u000eZ3s\u0003\u001dI7/R7qif$\"a\u0011$\u0011\u00055\"\u0015BA#/\u0005\u001d\u0011un\u001c7fC:DQaM\u0002A\u0002a\u0001")
public class JValueSerializer
extends JsonSerializer<JValue> {
    public void serialize(JValue value, JsonGenerator json, SerializerProvider provider) {
        if (value == null) {
            json.writeNull();
            return;
        }
        JValue jValue = value;
        if (jValue instanceof JInt) {
            JInt jInt = (JInt)jValue;
            BigInt v = jInt.num();
            json.writeNumber(v.bigInteger());
            return;
        }
        if (jValue instanceof JLong) {
            JLong jLong = (JLong)jValue;
            long v = jLong.num();
            json.writeNumber(v);
            return;
        }
        if (jValue instanceof JDouble) {
            JDouble jDouble = (JDouble)jValue;
            double v = jDouble.num();
            json.writeNumber(v);
            return;
        }
        if (jValue instanceof JDecimal) {
            JDecimal jDecimal = (JDecimal)jValue;
            BigDecimal v = jDecimal.num();
            json.writeNumber(v.bigDecimal());
            return;
        }
        if (jValue instanceof JString) {
            JString jString = (JString)jValue;
            String v = jString.s();
            json.writeString(v);
            return;
        }
        if (jValue instanceof JBool) {
            JBool jBool = (JBool)jValue;
            boolean v = jBool.value();
            json.writeBoolean(v);
            return;
        }
        if (jValue instanceof JArray) {
            JArray jArray = (JArray)jValue;
            List<JValue> elements = jArray.arr();
            json.writeStartArray();
            elements.foreach((Function1 & Serializable & scala.Serializable)x -> {
                this.serialize(x, json, provider);
                return BoxedUnit.UNIT;
            });
            json.writeEndArray();
            return;
        }
        if (jValue instanceof JSet) {
            JSet jSet = (JSet)jValue;
            Set<JValue> elements = jSet.set();
            json.writeStartArray();
            elements.foreach((Function1 & Serializable & scala.Serializable)x -> {
                this.serialize(x, json, provider);
                return BoxedUnit.UNIT;
            });
            json.writeEndArray();
            return;
        }
        if (jValue instanceof JObject) {
            JObject jObject = (JObject)jValue;
            List<Tuple2<String, JValue>> fields = jObject.obj();
            json.writeStartObject();
            fields.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                JValueSerializer.$anonfun$serialize$3(this, json, provider, x0$1);
                return BoxedUnit.UNIT;
            });
            json.writeEndObject();
            return;
        }
        JNull$ jNull$ = JsonAST$.MODULE$.JNull();
        JValue jValue2 = jValue;
        if (!(jNull$ != null ? !jNull$.equals(jValue2) : jValue2 != null)) {
            json.writeNull();
            return;
        }
        JNothing$ jNothing$ = JsonAST$.MODULE$.JNothing();
        JValue jValue3 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue3) : jValue3 != null)) {
            return;
        }
        throw new MatchError((Object)jValue);
    }

    public boolean isEmpty(JValue value) {
        JValue jValue = value;
        JNothing$ jNothing$ = JsonAST$.MODULE$.JNothing();
        return !(jValue != null ? !jValue.equals(jNothing$) : jNothing$ != null);
    }

    public static final /* synthetic */ void $anonfun$serialize$3(JValueSerializer $this, JsonGenerator json$1, SerializerProvider provider$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            JValue jValue = (JValue)tuple2._2();
            JNothing$ jNothing$ = JsonAST$.MODULE$.JNothing();
            JValue jValue2 = jValue;
            if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
                return;
            }
        }
        if (tuple2 != null) {
            String n = (String)tuple2._1();
            JValue v = (JValue)tuple2._2();
            json$1.writeFieldName(n);
            $this.serialize(v, json$1, provider$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

