/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePadding {
    private static final Logger LOG;
    private static long preAllocSize;
    private static final ByteBuffer fill;
    private long currentSize;

    public static long getPreAllocSize() {
        return preAllocSize;
    }

    public static void setPreallocSize(long size2) {
        preAllocSize = size2;
    }

    public void setCurrentSize(long currentSize) {
        this.currentSize = currentSize;
    }

    long padFile(FileChannel fileChannel) throws IOException {
        long newFileSize = FilePadding.calculateFileSizeWithPadding(fileChannel.position(), this.currentSize, preAllocSize);
        if (this.currentSize != newFileSize) {
            fileChannel.write((ByteBuffer)fill.position(0), newFileSize - (long)fill.remaining());
            this.currentSize = newFileSize;
        }
        return this.currentSize;
    }

    public static long calculateFileSizeWithPadding(long position, long fileSize, long preAllocSize) {
        if (preAllocSize > 0L && position + 4096L >= fileSize) {
            if (position > fileSize) {
                fileSize = position + preAllocSize;
                fileSize -= fileSize % preAllocSize;
            } else {
                fileSize += preAllocSize;
            }
        }
        return fileSize;
    }

    static {
        preAllocSize = 0x4000000L;
        fill = ByteBuffer.allocateDirect(1);
        LOG = LoggerFactory.getLogger(FileTxnLog.class);
        String size2 = System.getProperty("zookeeper.preAllocSize");
        if (size2 != null) {
            try {
                preAllocSize = Long.parseLong(size2) * 1024L;
            }
            catch (NumberFormatException e) {
                LOG.warn(size2 + " is not a valid value for preAllocSize");
            }
        }
    }
}

