/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.polygon;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

class PolygonNoder {
    private boolean[] isHoleTouching;
    private List<NodedSegmentString> nodedRings;

    public PolygonNoder(Coordinate[] shellRing, Coordinate[][] holeRings) {
        this.nodedRings = PolygonNoder.createNodedSegmentStrings(shellRing, holeRings);
        this.isHoleTouching = new boolean[holeRings.length];
    }

    public void node() {
        NodeAdder nodeAdder = new NodeAdder(this.isHoleTouching);
        MCIndexNoder noder = new MCIndexNoder(nodeAdder);
        noder.computeNodes(this.nodedRings);
    }

    public boolean isShellNoded() {
        return this.nodedRings.get(0).hasNodes();
    }

    public boolean isHoleNoded(int i) {
        return this.nodedRings.get(i + 1).hasNodes();
    }

    public Coordinate[] getNodedShell() {
        return this.nodedRings.get(0).getNodedCoordinates();
    }

    public Coordinate[] getNodedHole(int i) {
        return this.nodedRings.get(i + 1).getNodedCoordinates();
    }

    public boolean[] getHolesTouching() {
        return this.isHoleTouching;
    }

    public static List<NodedSegmentString> createNodedSegmentStrings(Coordinate[] shellRing, Coordinate[][] holeRings) {
        ArrayList<NodedSegmentString> segStr = new ArrayList<NodedSegmentString>();
        segStr.add(PolygonNoder.createNodedSegString(shellRing, -1));
        for (int i = 0; i < holeRings.length; ++i) {
            segStr.add(PolygonNoder.createNodedSegString(holeRings[i], i));
        }
        return segStr;
    }

    private static NodedSegmentString createNodedSegString(Coordinate[] ringPts, int i) {
        return new NodedSegmentString(ringPts, i);
    }

    private static class NodeAdder
    implements SegmentIntersector {
        private LineIntersector li = new RobustLineIntersector();
        private boolean[] isHoleTouching;

        public NodeAdder(boolean[] isHoleTouching) {
            this.isHoleTouching = isHoleTouching;
        }

        @Override
        public void processIntersections(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
            if (ss0 == ss1) {
                return;
            }
            Coordinate p00 = ss0.getCoordinate(segIndex0);
            Coordinate p01 = ss0.getCoordinate(segIndex0 + 1);
            Coordinate p10 = ss1.getCoordinate(segIndex1);
            Coordinate p11 = ss1.getCoordinate(segIndex1 + 1);
            this.li.computeIntersection(p00, p01, p10, p11);
            if (this.li.getIntersectionNum() == 1) {
                this.addTouch(ss0);
                this.addTouch(ss1);
                Coordinate intPt = this.li.getIntersection(0);
                if (this.li.isInteriorIntersection(0)) {
                    ((NodedSegmentString)ss0).addIntersectionNode(intPt, segIndex0);
                } else if (this.li.isInteriorIntersection(1)) {
                    ((NodedSegmentString)ss1).addIntersectionNode(intPt, segIndex1);
                }
            }
        }

        private void addTouch(SegmentString ss) {
            int holeIndex = (Integer)ss.getData();
            if (holeIndex >= 0) {
                this.isHoleTouching[holeIndex] = true;
            }
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }
}

