/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.volcano.api.model.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.volcano.api.model.scheduling.v1beta1.QueueStatus;
import io.fabric8.volcano.api.model.scheduling.v1beta1.Reservation;
import io.fabric8.volcano.api.model.scheduling.v1beta1.ReservationBuilder;
import io.fabric8.volcano.api.model.scheduling.v1beta1.ReservationFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class QueueStatusFluent<A extends QueueStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Map<String, Quantity> allocated;
    private Integer completed;
    private Integer inqueue;
    private Integer pending;
    private ReservationBuilder reservation;
    private Integer running;
    private String state;
    private Integer unknown;

    public QueueStatusFluent() {
    }

    public QueueStatusFluent(QueueStatus instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAllocated(Map<String, Quantity> map) {
        if (this.allocated == null && map != null) {
            this.allocated = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocated.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAllocated(String key, Quantity value) {
        if (this.allocated == null && key != null && value != null) {
            this.allocated = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocated.put(key, value);
        }
        return (A)((Object)this);
    }

    public Reservation buildReservation() {
        return this.reservation != null ? this.reservation.build() : null;
    }

    protected void copyInstance(QueueStatus instance) {
        QueueStatus queueStatus = instance = instance != null ? instance : new QueueStatus();
        if (instance != null) {
            this.withAllocated(instance.getAllocated());
            this.withCompleted(instance.getCompleted());
            this.withInqueue(instance.getInqueue());
            this.withPending(instance.getPending());
            this.withReservation(instance.getReservation());
            this.withRunning(instance.getRunning());
            this.withState(instance.getState());
            this.withUnknown(instance.getUnknown());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ReservationNested<A> editOrNewReservation() {
        return this.withNewReservationLike(Optional.ofNullable(this.buildReservation()).orElse(new ReservationBuilder().build()));
    }

    public ReservationNested<A> editOrNewReservationLike(Reservation item) {
        return this.withNewReservationLike(Optional.ofNullable(this.buildReservation()).orElse(item));
    }

    public ReservationNested<A> editReservation() {
        return this.withNewReservationLike(Optional.ofNullable(this.buildReservation()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueueStatusFluent that = (QueueStatusFluent)((Object)o);
        if (!Objects.equals(this.allocated, that.allocated)) {
            return false;
        }
        if (!Objects.equals(this.completed, that.completed)) {
            return false;
        }
        if (!Objects.equals(this.inqueue, that.inqueue)) {
            return false;
        }
        if (!Objects.equals(this.pending, that.pending)) {
            return false;
        }
        if (!Objects.equals((Object)this.reservation, (Object)that.reservation)) {
            return false;
        }
        if (!Objects.equals(this.running, that.running)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        if (!Objects.equals(this.unknown, that.unknown)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, Quantity> getAllocated() {
        return this.allocated;
    }

    public Integer getCompleted() {
        return this.completed;
    }

    public Integer getInqueue() {
        return this.inqueue;
    }

    public Integer getPending() {
        return this.pending;
    }

    public Integer getRunning() {
        return this.running;
    }

    public String getState() {
        return this.state;
    }

    public Integer getUnknown() {
        return this.unknown;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAllocated() {
        return this.allocated != null;
    }

    public boolean hasCompleted() {
        return this.completed != null;
    }

    public boolean hasInqueue() {
        return this.inqueue != null;
    }

    public boolean hasPending() {
        return this.pending != null;
    }

    public boolean hasReservation() {
        return this.reservation != null;
    }

    public boolean hasRunning() {
        return this.running != null;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public boolean hasUnknown() {
        return this.unknown != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allocated, this.completed, this.inqueue, this.pending, this.reservation, this.running, this.state, this.unknown, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAllocated(String key) {
        if (this.allocated == null) {
            return (A)((Object)this);
        }
        if (key != null && this.allocated != null) {
            this.allocated.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAllocated(Map<String, Quantity> map) {
        if (this.allocated == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocated == null) continue;
                this.allocated.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocated != null && !this.allocated.isEmpty()) {
            sb.append("allocated:");
            sb.append(this.allocated);
            sb.append(",");
        }
        if (this.completed != null) {
            sb.append("completed:");
            sb.append(this.completed);
            sb.append(",");
        }
        if (this.inqueue != null) {
            sb.append("inqueue:");
            sb.append(this.inqueue);
            sb.append(",");
        }
        if (this.pending != null) {
            sb.append("pending:");
            sb.append(this.pending);
            sb.append(",");
        }
        if (this.reservation != null) {
            sb.append("reservation:");
            sb.append((Object)this.reservation);
            sb.append(",");
        }
        if (this.running != null) {
            sb.append("running:");
            sb.append(this.running);
            sb.append(",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state);
            sb.append(",");
        }
        if (this.unknown != null) {
            sb.append("unknown:");
            sb.append(this.unknown);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public <K, V> A withAllocated(Map<String, Quantity> allocated) {
        this.allocated = allocated == null ? null : new LinkedHashMap<String, Quantity>(allocated);
        return (A)((Object)this);
    }

    public A withCompleted(Integer completed) {
        this.completed = completed;
        return (A)((Object)this);
    }

    public A withInqueue(Integer inqueue) {
        this.inqueue = inqueue;
        return (A)((Object)this);
    }

    public ReservationNested<A> withNewReservation() {
        return new ReservationNested(null);
    }

    public ReservationNested<A> withNewReservationLike(Reservation item) {
        return new ReservationNested(item);
    }

    public A withPending(Integer pending) {
        this.pending = pending;
        return (A)((Object)this);
    }

    public A withReservation(Reservation reservation) {
        this._visitables.remove((Object)"reservation");
        if (reservation != null) {
            this.reservation = new ReservationBuilder(reservation);
            this._visitables.get((Object)"reservation").add(this.reservation);
        } else {
            this.reservation = null;
            this._visitables.get((Object)"reservation").remove((Object)this.reservation);
        }
        return (A)((Object)this);
    }

    public A withRunning(Integer running) {
        this.running = running;
        return (A)((Object)this);
    }

    public A withState(String state) {
        this.state = state;
        return (A)((Object)this);
    }

    public A withUnknown(Integer unknown) {
        this.unknown = unknown;
        return (A)((Object)this);
    }

    public class ReservationNested<N>
    extends ReservationFluent<ReservationNested<N>>
    implements Nested<N> {
        ReservationBuilder builder;

        ReservationNested(Reservation item) {
            this.builder = new ReservationBuilder(this, item);
        }

        public N and() {
            return (N)QueueStatusFluent.this.withReservation(this.builder.build());
        }

        public N endReservation() {
            return this.and();
        }
    }
}

