/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.art;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.roaringbitmap.ArraysShim;
import org.roaringbitmap.art.BranchNode;
import org.roaringbitmap.art.Containers;
import org.roaringbitmap.art.KeyIterator;
import org.roaringbitmap.art.LeafNode;
import org.roaringbitmap.art.LeafNodeIterator;
import org.roaringbitmap.art.Node;
import org.roaringbitmap.art.Node4;
import org.roaringbitmap.longlong.LongUtils;

public class Art {
    private Node root = null;
    private long keySize = 0L;
    static final byte[] EMPTY_BYTES = new byte[0];

    public boolean isEmpty() {
        return this.root == null;
    }

    public void insert(byte[] key, long containerIdx) {
        Node freshRoot = this.insert(this.root, key, 0, containerIdx);
        if (freshRoot != this.root) {
            this.root = freshRoot;
        }
        ++this.keySize;
    }

    public long findByKey(byte[] key) {
        Node node = this.findByKey(this.root, key, 0);
        if (node != null) {
            LeafNode leafNode = (LeafNode)node;
            return leafNode.containerIdx;
        }
        return -1L;
    }

    public long findByKey(long key) {
        LeafNode node = this.findByKey(this.root, key);
        if (node != null) {
            return node.containerIdx;
        }
        return -1L;
    }

    private Node findByKey(Node node, byte[] key, int depth) {
        while (node != null) {
            int pos;
            if (node instanceof LeafNode) {
                LeafNode leafNode = (LeafNode)node;
                byte[] leafNodeKeyBytes = leafNode.getKeyBytes();
                if (depth == 6) {
                    return leafNode;
                }
                int mismatchIndex = ArraysShim.mismatch(leafNodeKeyBytes, depth, 6, key, depth, 6);
                if (mismatchIndex != -1) {
                    return null;
                }
                return leafNode;
            }
            BranchNode branchNode = (BranchNode)node;
            byte branchNodePrefixLength = branchNode.prefixLength();
            if (branchNodePrefixLength > 0) {
                int commonLength = Art.commonPrefixLength(key, depth, key.length, branchNode.prefix, 0, branchNodePrefixLength);
                if (commonLength != branchNodePrefixLength) {
                    return null;
                }
                depth += branchNodePrefixLength;
            }
            if ((pos = branchNode.getChildPos(key[depth])) == -1) {
                return null;
            }
            node = branchNode.getChild(pos);
            ++depth;
        }
        return null;
    }

    private LeafNode findByKey(Node node, long key) {
        int depth = 0;
        while (node != null) {
            if (node instanceof BranchNode) {
                int pos;
                BranchNode branchNode = (BranchNode)node;
                int branchNodePrefixLength = branchNode.prefixLength();
                if (branchNodePrefixLength > 0) {
                    byte[] prefix = branchNode.prefix;
                    for (int i = 0; i < branchNodePrefixLength; ++i) {
                        if (prefix[i] == LongUtils.getByte(key, depth + i)) continue;
                        return null;
                    }
                    depth += branchNodePrefixLength;
                }
                if ((pos = branchNode.getChildPos(LongUtils.getByte(key, depth))) == -1) {
                    return null;
                }
                node = branchNode.getChild(pos);
                ++depth;
                continue;
            }
            LeafNode leafNode = (LeafNode)node;
            long leafNodeKey = leafNode.getKey();
            return leafNodeKey == LongUtils.rightShiftHighPart(key) ? leafNode : null;
        }
        return null;
    }

    public KeyIterator iterator(Containers containers) {
        return new KeyIterator(this, containers);
    }

    public long remove(byte[] key) {
        Toolkit toolkit = this.removeSpecifyKey(this.root, key, 0);
        if (toolkit != null) {
            return toolkit.matchedContainerId;
        }
        return -1L;
    }

    protected Toolkit removeSpecifyKey(Node node, byte[] key, int dep) {
        int pos;
        if (node == null) {
            return null;
        }
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            if (this.leafMatch(leafNode, key, dep)) {
                if (leafNode == this.root) {
                    this.root = null;
                }
                --this.keySize;
                return new Toolkit(null, leafNode.getContainerIdx(), null);
            }
            return null;
        }
        BranchNode branchNode = (BranchNode)node;
        byte branchNodePrefixLength = branchNode.prefixLength();
        if (branchNodePrefixLength > 0) {
            int commonLength = Art.commonPrefixLength(key, dep, key.length, branchNode.prefix, 0, branchNodePrefixLength);
            if (commonLength != branchNodePrefixLength) {
                return null;
            }
            dep += branchNodePrefixLength;
        }
        if ((pos = branchNode.getChildPos(key[dep])) != -1) {
            Node child = branchNode.getChild(pos);
            if (child instanceof LeafNode && this.leafMatch((LeafNode)child, key, dep)) {
                Node freshNode = branchNode.remove(pos);
                --this.keySize;
                if (branchNode == this.root && freshNode != branchNode) {
                    this.root = freshNode;
                }
                long matchedContainerIdx = ((LeafNode)child).getContainerIdx();
                Toolkit toolkit = new Toolkit(freshNode, matchedContainerIdx, branchNode);
                toolkit.needToVerifyReplacing = true;
                return toolkit;
            }
            Toolkit toolkit = this.removeSpecifyKey(child, key, dep + 1);
            if (toolkit != null && toolkit.needToVerifyReplacing && toolkit.freshMatchedParentNode != null && toolkit.freshMatchedParentNode != toolkit.originalMatchedParentNode) {
                branchNode.replaceNode(pos, toolkit.freshMatchedParentNode);
                toolkit.needToVerifyReplacing = false;
                return toolkit;
            }
            if (toolkit != null) {
                return toolkit;
            }
        }
        return null;
    }

    private boolean leafMatch(LeafNode leafNode, byte[] key, int dep) {
        byte[] leafNodeKeyBytes = leafNode.getKeyBytes();
        int mismatchIndex = ArraysShim.mismatch(leafNodeKeyBytes, dep, 6, key, dep, 6);
        return mismatchIndex == -1;
    }

    private Node insert(Node node, byte[] key, int depth, long containerIdx) {
        int pos;
        if (node == null) {
            LeafNode leafNode = new LeafNode(key, containerIdx);
            return leafNode;
        }
        if (node instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)node;
            byte[] prefix = leafNode.getKeyBytes();
            int commonPrefix = Art.commonPrefixLength(prefix, depth, prefix.length, key, depth, key.length);
            Node4 node4 = new Node4(commonPrefix);
            System.arraycopy(key, depth, node4.prefix, 0, commonPrefix);
            node4.insert(leafNode, prefix[depth + commonPrefix]);
            LeafNode anotherLeaf = new LeafNode(key, containerIdx);
            node4.insert(anotherLeaf, key[depth + commonPrefix]);
            return node4;
        }
        BranchNode branchNode = (BranchNode)node;
        byte branchNodePrefixLength = branchNode.prefixLength();
        if (branchNodePrefixLength > 0) {
            int mismatchPos = ArraysShim.mismatch(branchNode.prefix, 0, branchNodePrefixLength, key, depth, key.length);
            if (mismatchPos != branchNodePrefixLength) {
                Node4 node4 = new Node4(mismatchPos);
                System.arraycopy(branchNode.prefix, 0, node4.prefix, 0, mismatchPos);
                node4.insert(branchNode, branchNode.prefix[mismatchPos]);
                int newPrefixLength = branchNodePrefixLength - (mismatchPos + 1);
                branchNode.prefix = Arrays.copyOfRange(branchNode.prefix, mismatchPos + 1, (int)branchNodePrefixLength);
                LeafNode leafNode = new LeafNode(key, containerIdx);
                node4.insert(leafNode, key[mismatchPos + depth]);
                return node4;
            }
            depth += branchNodePrefixLength;
        }
        if ((pos = branchNode.getChildPos(key[depth])) != -1) {
            Node child = branchNode.getChild(pos);
            Node freshOne = this.insert(child, key, depth + 1, containerIdx);
            if (freshOne != child) {
                branchNode.replaceNode(pos, freshOne);
            }
            return branchNode;
        }
        LeafNode leafNode = new LeafNode(key, containerIdx);
        return branchNode.insert(leafNode, key[depth]);
    }

    static int commonPrefixLength(byte[] key1, int aFromIndex, int aToIndex, byte[] key2, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        int minLength = Math.min(aLength, bLength);
        int mismatchIndex = ArraysShim.mismatch(key1, aFromIndex, aToIndex, key2, bFromIndex, bToIndex);
        if (aLength != bLength && mismatchIndex >= minLength) {
            return minLength;
        }
        return mismatchIndex;
    }

    public Node getRoot() {
        return this.root;
    }

    private LeafNode getExtremeLeaf(boolean reverse) {
        Node parent = this.getRoot();
        for (int depth = 0; depth < 7; ++depth) {
            if (!(parent instanceof BranchNode)) continue;
            BranchNode branchNode = (BranchNode)parent;
            int childIndex = reverse ? branchNode.getMaxPos() : branchNode.getMinPos();
            parent = branchNode.getChild(childIndex);
        }
        return (LeafNode)parent;
    }

    public LeafNode first() {
        return this.getExtremeLeaf(false);
    }

    public LeafNode last() {
        return this.getExtremeLeaf(true);
    }

    public void serializeArt(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(Long.reverseBytes(this.keySize));
        this.serialize(this.root, dataOutput);
    }

    public void deserializeArt(DataInput dataInput) throws IOException {
        this.keySize = Long.reverseBytes(dataInput.readLong());
        this.root = this.deserialize(dataInput);
    }

    public void serializeArt(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putLong(this.keySize);
        this.serialize(this.root, byteBuffer);
    }

    public void deserializeArt(ByteBuffer byteBuffer) throws IOException {
        this.keySize = byteBuffer.getLong();
        this.root = this.deserialize(byteBuffer);
    }

    public LeafNodeIterator leafNodeIterator(boolean reverse, Containers containers) {
        return new LeafNodeIterator(this, reverse, containers);
    }

    public LeafNodeIterator leafNodeIteratorFrom(long bound, boolean reverse, Containers containers) {
        return new LeafNodeIterator(this, reverse, containers, bound);
    }

    private void serialize(Node node, DataOutput dataOutput) throws IOException {
        if (node instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)node;
            branchNode.serialize(dataOutput);
            int nexPos = branchNode.getNextLargerPos(-1);
            while (nexPos != -1) {
                Node child = branchNode.getChild(nexPos);
                this.serialize(child, dataOutput);
                nexPos = branchNode.getNextLargerPos(nexPos);
            }
        } else {
            node.serialize(dataOutput);
        }
    }

    private void serialize(Node node, ByteBuffer byteBuffer) throws IOException {
        if (node instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)node;
            branchNode.serialize(byteBuffer);
            int nexPos = branchNode.getNextLargerPos(-1);
            while (nexPos != -1) {
                Node child = branchNode.getChild(nexPos);
                this.serialize(child, byteBuffer);
                nexPos = branchNode.getNextLargerPos(nexPos);
            }
        } else {
            node.serialize(byteBuffer);
        }
    }

    private Node deserialize(DataInput dataInput) throws IOException {
        Node oneNode = Node.deserialize(dataInput);
        if (oneNode == null) {
            return null;
        }
        if (oneNode instanceof LeafNode) {
            return oneNode;
        }
        BranchNode branch = (BranchNode)oneNode;
        int count = branch.count;
        Node[] children = new Node[count];
        for (int i = 0; i < count; ++i) {
            Node child;
            children[i] = child = this.deserialize(dataInput);
        }
        branch.replaceChildren(children);
        return branch;
    }

    private Node deserialize(ByteBuffer byteBuffer) throws IOException {
        Node oneNode = Node.deserialize(byteBuffer);
        if (oneNode == null) {
            return null;
        }
        if (oneNode instanceof LeafNode) {
            return oneNode;
        }
        BranchNode branchNode = (BranchNode)oneNode;
        int count = branchNode.count;
        Node[] children = new Node[count];
        for (int i = 0; i < count; ++i) {
            Node child;
            children[i] = child = this.deserialize(byteBuffer);
        }
        branchNode.replaceChildren(children);
        return branchNode;
    }

    public long serializeSizeInBytes() {
        return this.serializeSizeInBytes(this.root) + 8L;
    }

    public long getKeySize() {
        return this.keySize;
    }

    private long serializeSizeInBytes(Node node) {
        if (node instanceof BranchNode) {
            BranchNode branchNode = (BranchNode)node;
            int currentNodeSize = branchNode.serializeSizeInBytes();
            long childrenTotalSize = 0L;
            int nexPos = branchNode.getNextLargerPos(-1);
            while (nexPos != -1) {
                Node child = branchNode.getChild(nexPos);
                long childSize = this.serializeSizeInBytes(child);
                nexPos = branchNode.getNextLargerPos(nexPos);
                childrenTotalSize += childSize;
            }
            return (long)currentNodeSize + childrenTotalSize;
        }
        int nodeSize = node.serializeSizeInBytes();
        return nodeSize;
    }

    class Toolkit {
        Node freshMatchedParentNode;
        long matchedContainerId;
        Node originalMatchedParentNode;
        boolean needToVerifyReplacing = false;

        Toolkit(Node freshMatchedParentNode, long matchedContainerId, Node originalMatchedParentNode) {
            this.freshMatchedParentNode = freshMatchedParentNode;
            this.matchedContainerId = matchedContainerId;
            this.originalMatchedParentNode = originalMatchedParentNode;
        }
    }
}

