/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.EnsembleCombiningStrategy$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$SaveLoadV1_0$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.json4s.JValue;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class GradientBoostedTreesModel$
implements Loader<GradientBoostedTreesModel>,
Serializable {
    public static final GradientBoostedTreesModel$ MODULE$ = new GradientBoostedTreesModel$();

    public RDD<Tuple2<Object, Object>> computeInitialPredictionAndError(RDD<LabeledPoint> data, double initTreeWeight, DecisionTreeModel initTree, Loss loss) {
        return data.map((Function1 & Serializable)lp -> {
            double pred = initTreeWeight * initTree.predict(lp.features());
            double error = loss.computeError(pred, lp.label());
            return new Tuple2.mcDD.sp(pred, error);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Object>> updatePredictionError(RDD<LabeledPoint> data, RDD<Tuple2<Object, Object>> predictionAndError, double treeWeight, DecisionTreeModel tree, Loss loss) {
        RDD qual$1 = data.zip(predictionAndError, ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable x$1 = (Function1 & Serializable)iter -> iter.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LabeledPoint lp = (LabeledPoint)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    double pred = tuple22._1$mcD$sp();
                    double newPred = pred + tree.predict(lp.features()) * treeWeight;
                    double newError = loss.computeError(newPred, lp.label());
                    return new Tuple2.mcDD.sp(newPred, newError);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD newPredError = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        return newPredError;
    }

    @Override
    public GradientBoostedTreesModel load(SparkContext sc, String path) {
        Tuple3<String, String, JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String loadedClassName = (String)tuple3._1();
        String version = (String)tuple3._2();
        JValue jsonMetadata = (JValue)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)loadedClassName, (Object)version, (Object)jsonMetadata);
        String loadedClassName2 = (String)tuple32._1();
        String version2 = (String)tuple32._2();
        JValue jsonMetadata2 = (JValue)tuple32._3();
        String classNameV1_0 = GradientBoostedTreesModel$SaveLoadV1_0$.MODULE$.thisClassName();
        Tuple2 tuple2 = new Tuple2((Object)loadedClassName2, (Object)version2);
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            String string = (String)tuple2._2();
            if ("1.0".equals(string)) {
                String string2 = className;
                String string3 = classNameV1_0;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    TreeEnsembleModel.SaveLoadV1_0.Metadata metadata = TreeEnsembleModel$SaveLoadV1_0$.MODULE$.readMetadata(jsonMetadata2);
                    String string4 = metadata.combiningStrategy();
                    String string5 = EnsembleCombiningStrategy$.MODULE$.Sum().toString();
                    Predef$.MODULE$.assert(!(string4 != null ? !string4.equals(string5) : string5 != null));
                    DecisionTreeModel[] trees = TreeEnsembleModel$SaveLoadV1_0$.MODULE$.loadTrees(sc, path, metadata.treeAlgo());
                    return new GradientBoostedTreesModel(Algo$.MODULE$.fromString(metadata.algo()), trees, metadata.treeWeights());
                }
            }
        }
        throw new Exception("GradientBoostedTreesModel.load did not recognize model with (className, format version): (" + loadedClassName2 + ", " + version2 + ").  Supported:\n  (" + classNameV1_0 + ", 1.0)");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradientBoostedTreesModel$.class);
    }

    private GradientBoostedTreesModel$() {
    }
}

