/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LimitRangeItem;
import io.fabric8.kubernetes.api.model.LimitRangeItemBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeItemFluent;
import io.fabric8.kubernetes.api.model.LimitRangeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LimitRangeSpecFluent<A extends LimitRangeSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<LimitRangeItemBuilder> limits = new ArrayList();

    public LimitRangeSpecFluent() {
    }

    public LimitRangeSpecFluent(LimitRangeSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToLimits(Collection<LimitRangeItem> items) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get((Object)"limits").add(builder);
            this.limits.add(builder);
        }
        return (A)((Object)this);
    }

    public LimitsNested<A> addNewLimit() {
        return new LimitsNested(-1, null);
    }

    public LimitsNested<A> addNewLimitLike(LimitRangeItem item) {
        return new LimitsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLimits(LimitRangeItem ... items) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get((Object)"limits").add(builder);
            this.limits.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToLimits(int index, LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
        if (index < 0 || index >= this.limits.size()) {
            this._visitables.get((Object)"limits").add(builder);
            this.limits.add(builder);
        } else {
            this._visitables.get((Object)"limits").add(builder);
            this.limits.add(index, builder);
        }
        return (A)((Object)this);
    }

    public LimitRangeItem buildFirstLimit() {
        return this.limits.get(0).build();
    }

    public LimitRangeItem buildLastLimit() {
        return this.limits.get(this.limits.size() - 1).build();
    }

    public LimitRangeItem buildLimit(int index) {
        return this.limits.get(index).build();
    }

    public List<LimitRangeItem> buildLimits() {
        return this.limits != null ? LimitRangeSpecFluent.build(this.limits) : null;
    }

    public LimitRangeItem buildMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        for (LimitRangeItemBuilder item : this.limits) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(LimitRangeSpec instance) {
        LimitRangeSpec limitRangeSpec = instance = instance != null ? instance : new LimitRangeSpec();
        if (instance != null) {
            this.withLimits(instance.getLimits());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LimitsNested<A> editFirstLimit() {
        if (this.limits.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "limits"));
        }
        return this.setNewLimitLike(0, this.buildLimit(0));
    }

    public LimitsNested<A> editLastLimit() {
        int index = this.limits.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "limits"));
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public LimitsNested<A> editLimit(int index) {
        if (this.limits.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "limits"));
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public LimitsNested<A> editMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.limits.size(); ++i) {
            if (!predicate.test(this.limits.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "limits"));
        }
        return this.setNewLimitLike(index, this.buildLimit(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecFluent that = (LimitRangeSpecFluent)((Object)o);
        if (!Objects.equals(this.limits, that.limits)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasLimits() {
        return this.limits != null && !this.limits.isEmpty();
    }

    public boolean hasMatchingLimit(Predicate<LimitRangeItemBuilder> predicate) {
        for (LimitRangeItemBuilder item : this.limits) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.limits, this.additionalProperties);
    }

    public A removeAllFromLimits(Collection<LimitRangeItem> items) {
        if (this.limits == null) {
            return (A)((Object)this);
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get((Object)"limits").remove((Object)builder);
            this.limits.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromLimits(LimitRangeItem ... items) {
        if (this.limits == null) {
            return (A)((Object)this);
        }
        for (LimitRangeItem item : items) {
            LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
            this._visitables.get((Object)"limits").remove((Object)builder);
            this.limits.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLimits(Predicate<LimitRangeItemBuilder> predicate) {
        if (this.limits == null) {
            return (A)((Object)this);
        }
        Iterator<LimitRangeItemBuilder> each = this.limits.iterator();
        List visitables = this._visitables.get((Object)"limits");
        while (each.hasNext()) {
            LimitRangeItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public LimitsNested<A> setNewLimitLike(int index, LimitRangeItem item) {
        return new LimitsNested(index, item);
    }

    public A setToLimits(int index, LimitRangeItem item) {
        if (this.limits == null) {
            this.limits = new ArrayList();
        }
        LimitRangeItemBuilder builder = new LimitRangeItemBuilder(item);
        if (index < 0 || index >= this.limits.size()) {
            this._visitables.get((Object)"limits").add(builder);
            this.limits.add(builder);
        } else {
            this._visitables.get((Object)"limits").add(builder);
            this.limits.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withLimits(List<LimitRangeItem> limits) {
        if (this.limits != null) {
            this._visitables.get((Object)"limits").clear();
        }
        if (limits != null) {
            this.limits = new ArrayList();
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        } else {
            this.limits = null;
        }
        return (A)((Object)this);
    }

    public A withLimits(LimitRangeItem ... limits) {
        if (this.limits != null) {
            this.limits.clear();
            this._visitables.remove((Object)"limits");
        }
        if (limits != null) {
            for (LimitRangeItem item : limits) {
                this.addToLimits(item);
            }
        }
        return (A)((Object)this);
    }

    public class LimitsNested<N>
    extends LimitRangeItemFluent<LimitsNested<N>>
    implements Nested<N> {
        LimitRangeItemBuilder builder;
        int index;

        LimitsNested(int index, LimitRangeItem item) {
            this.index = index;
            this.builder = new LimitRangeItemBuilder(this, item);
        }

        public N and() {
            return (N)LimitRangeSpecFluent.this.setToLimits(this.index, this.builder.build());
        }

        public N endLimit() {
            return this.and();
        }
    }
}

