/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBDataEncoder;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t4A!\u0004\b\u0001;!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015\u0011\u0004\u0001\"\u00114\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015y\u0006\u0001\"\u0011a\u0005Q)fn]1gKJ{w\u000fR1uC\u0016s7m\u001c3fe*\u0011q\u0002E\u0001\u0006gR\fG/\u001a\u0006\u0003#I\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005M!\u0012!C3yK\u000e,H/[8o\u0015\t)b#A\u0002tc2T!a\u0006\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0004\u0005\u0002 A5\ta\"\u0003\u0002\"\u001d\t\u0011\"k\\2lg\u0012\u0013E)\u0019;b\u000b:\u001cw\u000eZ3s\u0003MYW-_*uCR,WI\\2pI\u0016\u00148\u000b]3d!\tyB%\u0003\u0002&\u001d\t\u00192*Z=Ti\u0006$X-\u00128d_\u0012,'o\u00159fG\u0006Ya/\u00197vKN\u001b\u0007.Z7b!\tA3&D\u0001*\u0015\tQC#A\u0003usB,7/\u0003\u0002-S\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\rqJg.\u001b;?)\ry\u0003'\r\t\u0003?\u0001AQAI\u0002A\u0002\rBQAJ\u0002A\u0002\u001d\nqc];qa>\u0014Ho]*dQ\u0016l\u0017-\u0012<pYV$\u0018n\u001c8\u0016\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012qAQ8pY\u0016\fg.A\u0005f]\u000e|G-Z&fsR\u0011AH\u0011\t\u0004kuz\u0014B\u0001 7\u0005\u0015\t%O]1z!\t)\u0004)\u0003\u0002Bm\t!!)\u001f;f\u0011\u0015\u0019U\u00011\u0001E\u0003\r\u0011xn\u001e\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011\nF\u0001\tG\u0006$\u0018\r\\=ti&\u00111J\u0012\u0002\n+:\u001c\u0018MZ3S_^\f!#\u001a8d_\u0012,'+Z7bS:LgnZ&fsR\u0011AH\u0014\u0005\u0006\u0007\u001a\u0001\r\u0001R\u0001\u001cK:\u001cw\u000eZ3Qe\u00164\u0017\u000e_&fs\u001a{'OU1oO\u0016\u001c6-\u00198\u0015\u0005q\n\u0006\"B\"\b\u0001\u0004!\u0015aC3oG>$WMV1mk\u0016$\"\u0001\u0010+\t\u000b\rC\u0001\u0019\u0001#\u0002\u0013\u0011,7m\u001c3f\u0017\u0016LHC\u0001#X\u0011\u0015A\u0016\u00021\u0001=\u0003\u0015\u0011\u0017\u0010^3t\u0003I!WmY8eKJ+W.Y5oS:<7*Z=\u0015\u0005\u0011[\u0006\"\u0002-\u000b\u0001\u0004a\u0014a\u00073fG>$W\r\u0015:fM&D8*Z=G_J\u0014\u0016M\\4f'\u000e\fg\u000e\u0006\u0002E=\")\u0001l\u0003a\u0001y\u0005YA-Z2pI\u00164\u0016\r\\;f)\t!\u0015\rC\u0003Y\u0019\u0001\u0007A\b")
public class UnsafeRowDataEncoder
extends RocksDBDataEncoder {
    private final KeyStateEncoderSpec keyStateEncoderSpec;

    @Override
    public boolean supportsSchemaEvolution() {
        return false;
    }

    @Override
    public byte[] encodeKey(UnsafeRow row) {
        return this.encodeUnsafeRow(row);
    }

    @Override
    public byte[] encodeRemainingKey(UnsafeRow row) {
        return this.encodeUnsafeRow(row);
    }

    @Override
    public byte[] encodePrefixKeyForRangeScan(UnsafeRow row) {
        Predef$.MODULE$.assert(this.keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec);
        RangeKeyScanStateEncoderSpec rsk = (RangeKeyScanStateEncoderSpec)this.keyStateEncoderSpec;
        Seq rangeScanKeyFieldsWithOrdinal = (Seq)rsk.orderingOrdinals().map((Function1 & Serializable)ordinal -> UnsafeRowDataEncoder.$anonfun$encodePrefixKeyForRangeScan$1(rsk, BoxesRunTime.unboxToInt((Object)ordinal)));
        UnsafeRowWriter writer = new UnsafeRowWriter(rsk.orderingOrdinals().length());
        writer.resetRowWriter();
        ((IterableOnceOps)rangeScanKeyFieldsWithOrdinal.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            UnsafeRowDataEncoder.$anonfun$encodePrefixKeyForRangeScan$2(this, row, writer, x0$1);
            return BoxedUnit.UNIT;
        });
        return this.encodeUnsafeRow(writer.getRow());
    }

    @Override
    public byte[] encodeValue(UnsafeRow row) {
        return this.encodeUnsafeRow(row);
    }

    @Override
    public UnsafeRow decodeKey(byte[] bytes) {
        KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
        if (keyStateEncoderSpec instanceof NoPrefixKeyStateEncoderSpec) {
            return this.decodeToUnsafeRow(bytes, this.reusedKeyRow());
        }
        if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
            PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec;
            int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
            return this.decodeToUnsafeRow(bytes, numColsPrefixKey);
        }
        throw this.unsupportedOperationForKeyStateEncoder("decodeKey");
    }

    @Override
    public UnsafeRow decodeRemainingKey(byte[] bytes) {
        KeyStateEncoderSpec keyStateEncoderSpec = this.keyStateEncoderSpec;
        if (keyStateEncoderSpec instanceof PrefixKeyScanStateEncoderSpec) {
            PrefixKeyScanStateEncoderSpec prefixKeyScanStateEncoderSpec = (PrefixKeyScanStateEncoderSpec)keyStateEncoderSpec;
            int numColsPrefixKey = prefixKeyScanStateEncoderSpec.numColsPrefixKey();
            return this.decodeToUnsafeRow(bytes, this.keySchema().length() - numColsPrefixKey);
        }
        if (keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec) {
            RangeKeyScanStateEncoderSpec rangeKeyScanStateEncoderSpec = (RangeKeyScanStateEncoderSpec)keyStateEncoderSpec;
            Seq<Object> orderingOrdinals = rangeKeyScanStateEncoderSpec.orderingOrdinals();
            return this.decodeToUnsafeRow(bytes, this.keySchema().length() - orderingOrdinals.length());
        }
        throw this.unsupportedOperationForKeyStateEncoder("decodeRemainingKey");
    }

    @Override
    public UnsafeRow decodePrefixKeyForRangeScan(byte[] bytes) {
        Predef$.MODULE$.assert(this.keyStateEncoderSpec instanceof RangeKeyScanStateEncoderSpec);
        RangeKeyScanStateEncoderSpec rsk = (RangeKeyScanStateEncoderSpec)this.keyStateEncoderSpec;
        UnsafeRowWriter writer = new UnsafeRowWriter(rsk.orderingOrdinals().length());
        Seq rangeScanKeyFieldsWithOrdinal = (Seq)rsk.orderingOrdinals().map((Function1 & Serializable)ordinal -> UnsafeRowDataEncoder.$anonfun$decodePrefixKeyForRangeScan$1(rsk, BoxesRunTime.unboxToInt((Object)ordinal)));
        writer.resetRowWriter();
        UnsafeRow row = this.decodeToUnsafeRow(bytes, rsk.orderingOrdinals().length());
        ((IterableOnceOps)rangeScanKeyFieldsWithOrdinal.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            UnsafeRowDataEncoder.$anonfun$decodePrefixKeyForRangeScan$2(this, row, writer, x0$1);
            return BoxedUnit.UNIT;
        });
        return writer.getRow();
    }

    @Override
    public UnsafeRow decodeValue(byte[] bytes) {
        return this.decodeToUnsafeRow(bytes, this.reusedValueRow());
    }

    public static final /* synthetic */ Tuple2 $anonfun$encodePrefixKeyForRangeScan$1(RangeKeyScanStateEncoderSpec rsk$1, int ordinal) {
        StructField field = rsk$1.keySchema().apply(ordinal);
        return new Tuple2((Object)field, (Object)BoxesRunTime.boxToInteger((int)ordinal));
    }

    public static final /* synthetic */ void $anonfun$encodePrefixKeyForRangeScan$2(UnsafeRowDataEncoder $this, UnsafeRow row$1, UnsafeRowWriter writer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 fieldWithOrdinal = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField field = (StructField)fieldWithOrdinal._1();
            Object value = row$1.get(idx, field.dataType());
            ByteBuffer bbuf = ByteBuffer.allocate(field.dataType().defaultSize() + 1);
            bbuf.order(ByteOrder.BIG_ENDIAN);
            if (value == null) {
                bbuf.put($this.nullValMarker());
                writer$1.write(idx, bbuf.array());
                return;
            }
            DataType dataType = field.dataType();
            if (BooleanType$.MODULE$.equals(dataType)) {
            } else if (ByteType$.MODULE$.equals(dataType)) {
                byte byteVal = BoxesRunTime.unboxToByte((Object)value);
                byte signCol = byteVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.put(byteVal);
                writer$1.write(idx, bbuf.array());
            } else if (ShortType$.MODULE$.equals(dataType)) {
                short shortVal = BoxesRunTime.unboxToShort((Object)value);
                byte signCol = shortVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.putShort(shortVal);
                writer$1.write(idx, bbuf.array());
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                int intVal = BoxesRunTime.unboxToInt((Object)value);
                byte signCol = intVal < 0 ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.putInt(intVal);
                writer$1.write(idx, bbuf.array());
            } else if (LongType$.MODULE$.equals(dataType)) {
                long longVal = BoxesRunTime.unboxToLong((Object)value);
                byte signCol = longVal < 0L ? $this.negativeValMarker() : $this.positiveValMarker();
                bbuf.put(signCol);
                bbuf.putLong(longVal);
                writer$1.write(idx, bbuf.array());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                float floatVal = BoxesRunTime.unboxToFloat((Object)value);
                int rawBits = Float.floatToRawIntBits(floatVal);
                if ((rawBits & $this.floatSignBitMask()) != 0) {
                    int updatedVal = rawBits ^ $this.floatFlipBitMask();
                    bbuf.put($this.negativeValMarker());
                    v0 = bbuf.putFloat(Float.intBitsToFloat(updatedVal));
                } else {
                    bbuf.put($this.positiveValMarker());
                    v0 = bbuf.putFloat(floatVal);
                }
                writer$1.write(idx, bbuf.array());
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                double doubleVal = BoxesRunTime.unboxToDouble((Object)value);
                long rawBits = Double.doubleToRawLongBits(doubleVal);
                if ((rawBits & $this.doubleSignBitMask()) != 0L) {
                    long updatedVal = rawBits ^ $this.doubleFlipBitMask();
                    bbuf.put($this.negativeValMarker());
                    v1 = bbuf.putDouble(Double.longBitsToDouble(updatedVal));
                } else {
                    bbuf.put($this.positiveValMarker());
                    v1 = bbuf.putDouble(doubleVal);
                }
                writer$1.write(idx, bbuf.array());
            } else {
                throw new MatchError((Object)dataType);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$decodePrefixKeyForRangeScan$1(RangeKeyScanStateEncoderSpec rsk$2, int ordinal) {
        StructField field = rsk$2.keySchema().apply(ordinal);
        return new Tuple2((Object)field, (Object)BoxesRunTime.boxToInteger((int)ordinal));
    }

    public static final /* synthetic */ void $anonfun$decodePrefixKeyForRangeScan$2(UnsafeRowDataEncoder $this, UnsafeRow row$2, UnsafeRowWriter writer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 fieldWithOrdinal = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField field = (StructField)fieldWithOrdinal._1();
            byte[] value = row$2.getBinary(idx);
            ByteBuffer bbuf = ByteBuffer.wrap(value);
            bbuf.order(ByteOrder.BIG_ENDIAN);
            byte isNullOrSignCol = bbuf.get();
            if (isNullOrSignCol == $this.nullValMarker()) {
                writer$2.setNullAt(idx);
                return;
            }
            DataType dataType = field.dataType();
            if (BooleanType$.MODULE$.equals(dataType)) {
            } else if (ByteType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.get());
            } else if (ShortType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.getShort());
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.getInt());
            } else if (LongType$.MODULE$.equals(dataType)) {
                writer$2.write(idx, bbuf.getLong());
            } else if (FloatType$.MODULE$.equals(dataType)) {
                if (isNullOrSignCol == $this.negativeValMarker()) {
                    int updatedVal = Float.floatToRawIntBits(bbuf.getFloat()) ^ $this.floatFlipBitMask();
                    writer$2.write(idx, Float.intBitsToFloat(updatedVal));
                } else {
                    writer$2.write(idx, bbuf.getFloat());
                }
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                if (isNullOrSignCol == $this.negativeValMarker()) {
                    long updatedVal = Double.doubleToRawLongBits(bbuf.getDouble()) ^ $this.doubleFlipBitMask();
                    writer$2.write(idx, Double.longBitsToDouble(updatedVal));
                } else {
                    writer$2.write(idx, bbuf.getDouble());
                }
            } else {
                throw new MatchError((Object)dataType);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public UnsafeRowDataEncoder(KeyStateEncoderSpec keyStateEncoderSpec, StructType valueSchema) {
        this.keyStateEncoderSpec = keyStateEncoderSpec;
        super(keyStateEncoderSpec, valueSchema);
    }
}

