/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.zip.CRC32C;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.state.ArrayIndexRange;
import scala.Function1;
import scala.Option;
import scala.runtime.BoxedUnit;

public final class KeyValueChecksum$ {
    public static final KeyValueChecksum$ MODULE$ = new KeyValueChecksum$();

    public int create(UnsafeRow keyRow, Option<UnsafeRow> valueRow) {
        return this.create(keyRow.getBytes(), (Option<byte[]>)valueRow.map((Function1 & Serializable)x$1 -> x$1.getBytes()));
    }

    public int create(byte[] keyBytes, Option<byte[]> valueBytes) {
        return this.create(new ArrayIndexRange<Object>(keyBytes, 0, keyBytes.length), (Option<ArrayIndexRange<Object>>)valueBytes.map((Function1 & Serializable)v -> new ArrayIndexRange(v, 0, ((byte[])v).length)));
    }

    public int create(ArrayIndexRange<Object> keyBytes, Option<ArrayIndexRange<Object>> valueBytes) {
        CRC32C crc32c = new CRC32C();
        crc32c.update((byte[])keyBytes.array(), keyBytes.fromIndex(), keyBytes.length());
        valueBytes.foreach((Function1 & Serializable)value -> {
            crc32c.update((byte[])value.array(), value.fromIndex(), value.length());
            return BoxedUnit.UNIT;
        });
        return (int)crc32c.getValue();
    }

    private KeyValueChecksum$() {
    }
}

