/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.state.AllColumnFamiliesReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSource$;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataTableEntry;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorsUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateStoreColumnFamilySchemaUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateVariableType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.timers.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.InMemoryStateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionErrors$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RocksDBStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\n\u0015\u0001\u0015BQA\u0011\u0001\u0005\u0002\rC\u0001B\u0012\u0001\t\u0006\u0004%Ia\u0012\u0005\t\u0019\u0002A)\u0019!C\u0005\u001b\")a\u000b\u0001C!/\")Q\r\u0001C!M\"9\u0011Q\u0002\u0001\u0005B\u0005=\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002|\u0001!I!! \t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011q\u0013\u0001\u0005\n\u0005euaBA[)!\u0005\u0011q\u0017\u0004\u0007'QA\t!!/\t\r\t{A\u0011AAa\u0011\u001d\t\u0019m\u0004C\u0005\u0003\u000bDq!!4\u0010\t\u0003\tyMA\bTi\u0006$X\rR1uCN{WO]2f\u0015\t)b#A\u0003ti\u0006$XM\u0003\u0002\u00181\u0005\u0011aO\r\u0006\u00033i\t1\u0002Z1uCN|WO]2fg*\u00111\u0004H\u0001\nKb,7-\u001e;j_:T!!\b\u0010\u0002\u0007M\fHN\u0003\u0002 A\u0005)1\u000f]1sW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0014/mq\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004PE*,7\r\u001e\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nqaY1uC2|wM\u0003\u000249\u0005I1m\u001c8oK\u000e$xN]\u0005\u0003kA\u0012Q\u0002V1cY\u0016\u0004&o\u001c<jI\u0016\u0014\bCA\u001c;\u001b\u0005A$BA\u001d\u001d\u0003\u001d\u0019x.\u001e:dKNL!a\u000f\u001d\u0003%\u0011\u000bG/Y*pkJ\u001cWMU3hSN$XM\u001d\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fy\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0003z\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\tB\u0011Q\tA\u0007\u0002)\u000591/Z:tS>tW#\u0001%\u0011\u0005%SU\"\u0001\u000f\n\u0005-c\"\u0001D*qCJ\\7+Z:tS>t\u0017A\u00035bI>|\u0007oQ8oMV\ta\n\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006!1m\u001c8g\u0015\t\u0019\u0006%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003+B\u0013QbQ8oM&<WO]1uS>t\u0017!C:i_J$h*Y7f)\u0005A\u0006CA-c\u001d\tQ\u0006\r\u0005\u0002\\=6\tAL\u0003\u0002^I\u00051AH]8pizR\u0011aX\u0001\u0006g\u000e\fG.Y\u0005\u0003Cz\u000ba\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011MX\u0001\tO\u0016$H+\u00192mKR!qM\u001b:\u007f!\ty\u0003.\u0003\u0002ja\t)A+\u00192mK\")1.\u0002a\u0001Y\u000611o\u00195f[\u0006\u0004\"!\u001c9\u000e\u00039T!a\u001c\u000f\u0002\u000bQL\b/Z:\n\u0005Et'AC*ueV\u001cG\u000fV=qK\")1/\u0002a\u0001i\u0006a\u0001/\u0019:uSRLwN\\5oOB\u0019QO\u001e=\u000e\u0003yK!a\u001e0\u0003\u000b\u0005\u0013(/Y=\u0011\u0005edX\"\u0001>\u000b\u0005m\u0014\u0014aC3yaJ,7o]5p]NL!! >\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007BB@\u0006\u0001\u0004\t\t!\u0001\u0006qe>\u0004XM\u001d;jKN\u0004b!a\u0001\u0002\naCVBAA\u0003\u0015\r\t9AK\u0001\u0005kRLG.\u0003\u0003\u0002\f\u0005\u0015!aA'ba\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\ra\u0017\u0011\u0003\u0005\b\u0003'1\u0001\u0019AA\u000b\u0003\u001dy\u0007\u000f^5p]N\u0004B!a\u0006\u0002\u001c5\u0011\u0011\u0011\u0004\u0006\u0004\u0003\u000fa\u0012\u0002BA\u000f\u00033\u0011\u0001dQ1tK&s7/\u001a8tSRLg/Z*ue&tw-T1q\u0003a\u0019X\u000f\u001d9peR\u001cX\t\u001f;fe:\fG.T3uC\u0012\fG/\u0019\u000b\u0003\u0003G\u00012!^A\u0013\u0013\r\t9C\u0018\u0002\b\u0005>|G.Z1o\u0003U9W\r^*uCR,gi\u001c:nCR4VM]:j_:$\u0002\"!\f\u0002:\u0005-\u0013q\n\t\u0006k\u0006=\u00121G\u0005\u0004\u0003cq&AB(qi&|g\u000eE\u0002v\u0003kI1!a\u000e_\u0005\rIe\u000e\u001e\u0005\b\u0003wA\u0001\u0019AA\u001f\u00035\u0019Ho\u001c:f\u001b\u0016$\u0018\rZ1uCB!QO^A !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#)\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002J\u0005\r#aF*uCR,W*\u001a;bI\u0006$\u0018\rV1cY\u0016,e\u000e\u001e:z\u0011\u0019\ti\u0005\u0003a\u00011\u0006\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011\u001d\t\t\u0006\u0003a\u0001\u0003'\nqAY1uG\"LE\rE\u0002v\u0003+J1!a\u0016_\u0005\u0011auN\\4\u00029%\u001c(+Z1e\u00032d7i\u001c7GC6LG.[3t\u001f:Tu.\u001b8WgQ1\u00111EA/\u0003OBq!a\u0018\n\u0001\u0004\t\t'A\u0007t_V\u00148-Z(qi&|gn\u001d\t\u0004\u000b\u0006\r\u0014bAA3)\t\u00112\u000b^1uKN{WO]2f\u001fB$\u0018n\u001c8t\u0011\u001d\tY$\u0003a\u0001\u0003{\tACY;jY\u0012\u001c\u0016\u000f\\\"p]\u001a4uN\u001d\"bi\u000eDGCBA7\u0003o\nI\b\u0005\u0003\u0002p\u0005MTBAA9\u0015\tyD$\u0003\u0003\u0002v\u0005E$aB*R\u0019\u000e{gN\u001a\u0005\u0007\u0003\u001bR\u0001\u0019\u0001-\t\u000f\u0005E#\u00021\u0001\u0002T\u0005\t\"/\u001e8Ti\u0006$XMV1s\u0007\",7m[:\u0015\r\u0005}\u0014QQAD!\r)\u0018\u0011Q\u0005\u0004\u0003\u0007s&\u0001B+oSRDq!a\u0018\f\u0001\u0004\t\t\u0007C\u0004\u0002\n.\u0001\r!!\u0010\u0002%M$\u0018\r^3Ti>\u0014X-T3uC\u0012\fG/Y\u0001\u001dO\u0016$8\u000b^8sK6+G/\u00193bi\u0006\fe\u000e\u001a*v]\u000eCWmY6t)\u0011\ty)!&\u0011\u0007\u0015\u000b\t*C\u0002\u0002\u0014R\u0011Ac\u0015;bi\u0016\u001cFo\u001c:f%\u0016\fG-\u001a:J]\u001a|\u0007bBA0\u0019\u0001\u0007\u0011\u0011M\u0001\u0017O\u0016$8*Z=Ti\u0006$X-\u00128d_\u0012,'o\u00159fGR1\u00111TAU\u0003g\u0003B!!(\u0002&6\u0011\u0011q\u0014\u0006\u0004+\u0005\u0005&bAAR5\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003O\u000byJA\nLKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s'B,7\rC\u0004\u0002,6\u0001\r!!,\u0002\u001f\r|GNR1nS2L8k\u00195f[\u0006\u0004B!!(\u00020&!\u0011\u0011WAP\u0005e\u0019F/\u0019;f'R|'/Z\"pY\u001a\u000bW.\u001b7z'\u000eDW-\\1\t\u000f\u0005mR\u00021\u0001\u0002>\u0005y1\u000b^1uK\u0012\u000bG/Y*pkJ\u001cW\r\u0005\u0002F\u001fM\u0019q\"a/\u0011\u0007U\fi,C\u0002\u0002@z\u0013a!\u00118z%\u00164GCAA\\\u0003U9W\r^*uCR,7\u000b^8sK6+G/\u00193bi\u0006$b!!\u0010\u0002H\u0006-\u0007bBAe#\u0001\u0007\u0011\u0011M\u0001\u0013gR\fG/Z*pkJ\u001cWm\u00149uS>t7\u000fC\u0003M#\u0001\u0007a*A\u000bhKR|E\u000eZ*dQ\u0016l\u0017MR5mKB\u000bG\u000f[:\u0015\r\u0005E\u0017q^Ay!\u0019\t\u0019.!8\u0002d:!\u0011Q[Am\u001d\rY\u0016q[\u0005\u0002?&\u0019\u00111\u001c0\u0002\u000fA\f7m[1hK&!\u0011q\\Aq\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005mg\f\u0005\u0003\u0002f\u0006-XBAAt\u0015\r\tIOU\u0001\u0003MNLA!!<\u0002h\n!\u0001+\u0019;i\u0011\u001d\tIM\u0005a\u0001\u0003CBQ\u0001\u0014\nA\u00029\u0003")
public class StateDataSource
implements TableProvider,
DataSourceRegister,
Logging {
    private SparkSession session;
    private Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static List<Path> getOldSchemaFilePaths(StateSourceOptions stateSourceOptions, Configuration hadoopConf) {
        return StateDataSource$.MODULE$.getOldSchemaFilePaths(stateSourceOptions, hadoopConf);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession session$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = SparkSession$.MODULE$.active();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.session;
    }

    private SparkSession session() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    private Configuration hadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopConf = this.session().sessionState().newHadoopConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopConf;
    }

    private Configuration hadoopConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hadoopConf$lzycompute();
        }
        return this.hadoopConf;
    }

    @Override
    public String shortName() {
        return "statestore";
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        StateStoreReaderInfo stateStoreReaderInfo;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.modifySourceOptions(this.hadoopConf(), StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), properties));
        SQLConf batchSqlConf = this.buildSqlConfForBatch(sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
        StateStoreConf stateConf = StateStoreConf$.MODULE$.apply(batchSqlConf);
        if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
            String string = stateConf.providerClass();
            String string2 = RocksDBStateStoreProvider.class.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw OfflineStateRepartitionErrors$.MODULE$.unsupportedStateStoreProviderError(sourceOptions.resolvedCpLocation(), stateConf.providerClass());
            }
        }
        if ((stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions)).keyStateEncoderSpecOpt().isDefined()) {
            keyStateEncoderSpec = (KeyStateEncoderSpec)stateStoreReaderInfo.keyStateEncoderSpecOpt().get();
        } else {
            StructType keySchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "key");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(keySchema);
        }
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return new StateTable(this.session(), schema, sourceOptions, stateConf, BoxesRunTime.unboxToInt((Object)batchSqlConf.getConf(SQLConf$.MODULE$.STATEFUL_SHUFFLE_PARTITIONS_INTERNAL()).get()), keyStateEncoderSpec2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt(), stateStoreReaderInfo.stateSchemaProviderOpt(), stateStoreReaderInfo.joinColFamilyOpt(), stateStoreReaderInfo.allColumnFamiliesReaderInfo());
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        StructType structType;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.modifySourceOptions(this.hadoopConf(), StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), options));
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        List<Path> oldSchemaFilePaths = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
        Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
        try {
            Tuple2 tuple2;
            Enumeration.Value value = sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, oldSchemaFilePaths, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$6());
            } else {
                Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, oldSchemaFilePaths, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$6());
                } else {
                    Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.require(stateStoreReaderInfo.stateStoreColFamilySchemaOpt().isDefined());
                        StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateStoreReaderInfo.stateStoreColFamilySchemaOpt().get();
                        tuple2 = new Tuple2((Object)resultSchema.keySchema(), (Object)resultSchema.valueSchema());
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType keySchema = (StructType)tuple22._1();
            StructType valueSchema = (StructType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)keySchema, (Object)valueSchema);
            StructType keySchema2 = (StructType)tuple23._1();
            StructType valueSchema2 = (StructType)tuple23._2();
            structType = SchemaUtil$.MODULE$.getSourceSchema(sourceOptions, keySchema2, valueSchema2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt(), (Option<String>)stateStoreReaderInfo.allColumnFamiliesReaderInfo().map((Function1 & Serializable)x$2 -> x$2.operatorName()), (Option<Object>)stateStoreReaderInfo.allColumnFamiliesReaderInfo().flatMap((Function1 & Serializable)x$3 -> x$3.stateFormatVersion()));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
            }
            throw throwable;
        }
        return structType;
    }

    public boolean supportsExternalMetadata() {
        return false;
    }

    private Option<Object> getStateFormatVersion(StateMetadataTableEntry[] storeMetadata, String checkpointLocation, long batchId) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))) {
            String string = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
            String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new StreamingQueryCheckpointMetadata(this.session(), checkpointLocation).offsetLog().get(batchId).flatMap((Function1 & Serializable)x$4 -> x$4.metadataOpt()).flatMap((Function1 & Serializable)x$5 -> x$5.conf().get((Object)SQLConf$.MODULE$.STREAMING_JOIN_STATE_FORMAT_VERSION().key())).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$6))));
            }
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isReadAllColFamiliesOnJoinV3(StateSourceOptions sourceOptions, StateMetadataTableEntry[] storeMetadata) {
        if (!sourceOptions.internalOnlyReadAllColumnFamilies()) return false;
        String string = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
        String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!StreamStreamJoinStateHelper$.MODULE$.usesVirtualColumnFamilies(this.hadoopConf(), sourceOptions.stateCheckpointLocation().toString(), sourceOptions.operatorId())) return false;
        return true;
    }

    private SQLConf buildSqlConfForBatch(String checkpointLocation, long batchId) {
        OffsetSeqLog offsetLog = new StreamingQueryCheckpointMetadata(this.session(), checkpointLocation).offsetLog();
        Option option = offsetLog.get(batchId);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetSeqBase value = (OffsetSeqBase)some.value();
            OffsetSeqMetadataBase metadata = (OffsetSeqMetadataBase)value.metadataOpt().getOrElse((Function0 & Serializable)() -> {
                throw StateDataSourceErrors$.MODULE$.offsetMetadataLogUnavailable(batchId, checkpointLocation);
            });
            SQLConf clonedSqlConf = this.session().sessionState().conf().clone();
            OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, clonedSqlConf);
            return clonedSqlConf;
        }
        throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(batchId, checkpointLocation);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runStateVarChecks(StateSourceOptions sourceOptions, StateMetadataTableEntry[] stateStoreMetadata) {
        Option<String> option = sourceOptions.stateVarName();
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
            StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
            String string = opMetadata.operatorName();
            if (string != null) {
                String string2;
                String string3 = string2 = string;
                String string4 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    Seq<String> possibleStoreNames = SymmetricHashJoinStateManager$.MODULE$.allStateStoreNames((Seq<StreamingSymmetricHashJoinHelper.JoinSide>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamingSymmetricHashJoinHelper.JoinSide[]{StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, StreamingSymmetricHashJoinHelper$RightSide$.MODULE$}));
                    if (possibleStoreNames.contains((Object)name)) return;
                    String errorMsg = "Store name " + name + " not allowed for join operator. Allowed names are " + possibleStoreNames + ". Please remove this option and re-run the query.";
                    throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STORE_NAME(), errorMsg);
                }
            }
            if (string != null) {
                String string5 = string;
                if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)string5)) {
                    StateDataSource.runTWSChecks$1(opMetadata, sourceOptions);
                    return;
                }
            }
            String errorMsg = "Providing state variable names is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), errorMsg);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (!sourceOptions.readRegisteredTimers()) {
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) != 1) return;
            if (!StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))).operatorName())) return;
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified("stateVarName");
        }
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
        StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
        String string = opMetadata.operatorName();
        if (string != null) {
            String string6 = string;
            if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)string6)) {
                StateDataSource.runTWSChecks$1(opMetadata, sourceOptions);
                return;
            }
        }
        String errorMsg = "Providing readRegisteredTimers=true is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
        throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), errorMsg);
    }

    private StateStoreReaderInfo getStoreMetadataAndRunChecks(StateSourceOptions sourceOptions) {
        None$ none$;
        StateMetadataTableEntry[] storeMetadata = StateDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$v2$state$StateDataSource$$getStateStoreMetadata(sourceOptions, this.hadoopConf());
        if (!sourceOptions.internalOnlyReadAllColumnFamilies()) {
            this.runStateVarChecks(sourceOptions, storeMetadata);
        }
        None$ keyStateEncoderSpecOpt = None$.MODULE$;
        None$ stateStoreColFamilySchemaOpt = None$.MODULE$;
        None$ transformWithStateVariableInfoOpt = None$.MODULE$;
        None$ stateSchemaProvider = None$.MODULE$;
        None$ joinColFamilyOpt = None$.MODULE$;
        String timeMode = TimeMode.None().toString();
        Set stateStoreColFamilySchemas = Predef$.MODULE$.Set().empty();
        List<TransformWithStateVariableInfo> stateVariableInfos = package$.MODULE$.List().empty();
        Enumeration.Value value = sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            List list;
            ObjectRef stateVarName = ObjectRef.create((Object)((String)sourceOptions.stateVarName().getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME())));
            if (storeMetadata.length > 0 && ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).version() == 2) {
                String opName = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
                if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)opName.contains(x$1)))) {
                    StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
                    TransformWithStateOperatorProperties operatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(storeMetadataEntry.operatorPropertiesJson());
                    timeMode = operatorProperties.timeMode();
                    if (sourceOptions.readRegisteredTimers()) {
                        stateVarName.elem = (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1();
                    }
                    if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
                        stateVarName.elem = ((TransformWithStateVariableInfo)operatorProperties.stateVariables().head()).stateName();
                        stateVariableInfos = operatorProperties.stateVariables();
                    }
                    List stateVarInfoList = operatorProperties.stateVariables().filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$3(stateVarName, stateVar)));
                    if (!TimerStateUtils$.MODULE$.isTimerCFName((String)stateVarName.elem) && StateStoreColumnFamilySchemaUtils$.MODULE$.isTestingInternalColFamily((String)stateVarName.elem)) {
                        stateVarInfoList = new .colon.colon((Object)new TransformWithStateVariableInfo((String)stateVarName.elem, StateVariableType$.MODULE$.ValueState(), false), (List)Nil$.MODULE$);
                    }
                    Predef$.MODULE$.require(stateVarInfoList.size() == 1, (Function0 & Serializable)() -> "Failed to find unique state variable info for state variable " + (String)stateVarName$2.elem + " in operator " + sourceOptions.operatorId());
                    TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)stateVarInfoList.head();
                    transformWithStateVariableInfoOpt = new Some((Object)stateVarInfo);
                    List<String> schemaFilePaths = storeMetadataEntry.stateSchemaFilePaths();
                    StateSchemaMetadata stateSchemaMetadata = StateSchemaMetadata$.MODULE$.createStateSchemaMetadata(sourceOptions.stateCheckpointLocation().toString(), this.hadoopConf(), schemaFilePaths);
                    stateSchemaProvider = new Some((Object)new InMemoryStateSchemaProvider(stateSchemaMetadata));
                    list = schemaFilePaths.map((Function1 & Serializable)x$7 -> new Path(x$7));
                } else {
                    String string = opName;
                    String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        joinColFamilyOpt = new Some((Object)((String)stateVarName.elem));
                    }
                    list = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
                }
            } else {
                list = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
            }
            List oldSchemaFilePaths = list;
            try {
                int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
                Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
                StateStoreId storeId = new StateStoreId(stateCheckpointLocation.toString(), sourceOptions.operatorId(), partitionId, sourceOptions.storeName());
                StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
                StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf(), oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
                List<StateStoreColFamilySchema> stateSchema = manager.readSchemaFile();
                if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
                    stateStoreColFamilySchemas = stateSchema.toSet();
                }
                StateStoreColFamilySchema resultSchema = this.isReadAllColFamiliesOnJoinV3(sourceOptions, storeMetadata) ? (StateStoreColFamilySchema)stateSchema.head() : (StateStoreColFamilySchema)stateSchema.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$6(stateVarName, x$8))).head();
                keyStateEncoderSpecOpt = new Some((Object)this.getKeyStateEncoderSpec(resultSchema, storeMetadata));
                stateStoreColFamilySchemaOpt = new Some((Object)resultSchema);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
                }
                throw throwable;
            }
        }
        if (sourceOptions.internalOnlyReadAllColumnFamilies()) {
            Predef$.MODULE$.assert(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata)), (Function0 & Serializable)() -> "storeMetadata shouldn't be empty");
            String operatorName = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
            Option<Object> stateFormatVersion = this.getStateFormatVersion(storeMetadata, sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
            none$ = new Some((Object)new AllColumnFamiliesReaderInfo((Set<StateStoreColFamilySchema>)stateStoreColFamilySchemas, stateVariableInfos, operatorName, stateFormatVersion));
        } else {
            none$ = None$.MODULE$;
        }
        None$ allColFamilyReaderInfoOpt = none$;
        return new StateStoreReaderInfo((Option<KeyStateEncoderSpec>)keyStateEncoderSpecOpt, (Option<StateStoreColFamilySchema>)stateStoreColFamilySchemaOpt, (Option<TransformWithStateVariableInfo>)transformWithStateVariableInfoOpt, (Option<StateSchemaProvider>)stateSchemaProvider, (Option<String>)joinColFamilyOpt, (Option<AllColumnFamiliesReaderInfo>)allColFamilyReaderInfoOpt);
    }

    private KeyStateEncoderSpec getKeyStateEncoderSpec(StateStoreColFamilySchema colFamilySchema, StateMetadataTableEntry[] storeMetadata) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        if (storeMetadata.length == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Metadata for state store not found, possible cause is this checkpoint is created by older version of spark. If the query has session window aggregation, the state can't be read correctly and runtime exception will be thrown. Run the streaming query in newer spark version to generate state metadata can fix the issue.");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
        } else {
            Predef$.MODULE$.require(storeMetadata.length == 1);
            StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
            if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() == 0) {
                keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
            } else if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() > 0) {
                keyStateEncoderSpec = new PrefixKeyScanStateEncoderSpec(colFamilySchema.keySchema(), storeMetadataEntry.numColsPrefixKey());
            } else if (storeMetadataEntry.version() == 2) {
                Predef$.MODULE$.require(colFamilySchema.keyStateEncoderSpec().isDefined());
                keyStateEncoderSpec = (KeyStateEncoderSpec)colFamilySchema.keyStateEncoderSpec().get();
            } else {
                throw StateDataSourceErrors$.MODULE$.internalError("Failed to read key state encoder spec for operator=" + storeMetadataEntry.operatorId());
            }
        }
        NoPrefixKeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return keyStateEncoderSpec2;
    }

    public static final /* synthetic */ boolean $anonfun$runStateVarChecks$1(String stateVarName$1, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = stateVarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void runTWSChecks$1(StateMetadataTableEntry opMetadata, StateSourceOptions sourceOptions$1) {
        String operatorProperties = opMetadata.operatorPropertiesJson();
        if (operatorProperties.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "No state variable names are defined for the transformWithState operator");
        }
        TransformWithStateOperatorProperties twsOperatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(operatorProperties);
        String timeMode = twsOperatorProperties.timeMode();
        if (sourceOptions$1.readRegisteredTimers()) {
            String string = timeMode;
            String string2 = TimeMode.None().toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), "Registered timers are not available in TimeMode=None.");
            }
        }
        String stateVarName = sourceOptions$1.readRegisteredTimers() ? (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1() : (String)sourceOptions$1.stateVarName().get();
        List<TransformWithStateVariableInfo> stateVars = twsOperatorProperties.stateVariables();
        List stateVarInfo = stateVars.filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$runStateVarChecks$1(stateVarName, stateVar)));
        if (stateVarInfo.size() != 1 && !StateStoreColumnFamilySchemaUtils$.MODULE$.isTestingInternalColFamily(stateVarName)) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "State variable " + stateVarName + " is not defined for the transformWithState operator.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$3(ObjectRef stateVarName$2, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$6(ObjectRef stateVarName$2, StateStoreColFamilySchema x$8) {
        String string = x$8.colFamilyName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public StateDataSource() {
        Logging.$init$((Logging)this);
    }
}

