/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCDatabaseMetadata;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class JDBCDatabaseMetadata$
implements Logging,
Serializable {
    public static final JDBCDatabaseMetadata$ MODULE$ = new JDBCDatabaseMetadata$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> safeGet(Function0<Object> f) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)f.apply$mcI$sp()));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while getting specific database metadata"}))).log((Seq)Nil$.MODULE$)), throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public JDBCDatabaseMetadata fromJDBCConnectionFactory(Function1<Object, Connection> getConnection) {
        JDBCDatabaseMetadata jDBCDatabaseMetadata;
        block6: {
            ObjectRef conn = ObjectRef.create(null);
            try {
                try {
                    conn.elem = (Connection)getConnection.apply((Object)BoxesRunTime.boxToInteger((int)-1));
                    DatabaseMetaData databaseMetadata = ((Connection)conn.elem).getMetaData();
                    jDBCDatabaseMetadata = new JDBCDatabaseMetadata(this.safeGet((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> databaseMetadata.getDatabaseMajorVersion()), this.safeGet((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> databaseMetadata.getDatabaseMinorVersion()), this.safeGet((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> databaseMetadata.getDriverMajorVersion()), this.safeGet((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> databaseMetadata.getDriverMinorVersion()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while getting database metadata object from connection"}))).log((Seq)Nil$.MODULE$)), throwable2);
                        jDBCDatabaseMetadata = new JDBCDatabaseMetadata((Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                this.closeConnection$1(conn);
            }
        }
        return jDBCDatabaseMetadata;
    }

    public JDBCDatabaseMetadata apply(Option<Object> databaseMajorVersion, Option<Object> databaseMinorVersion, Option<Object> databaseDriverMajorVersion, Option<Object> databaseDriverMinorVersion) {
        return new JDBCDatabaseMetadata(databaseMajorVersion, databaseMinorVersion, databaseDriverMajorVersion, databaseDriverMinorVersion);
    }

    public Option<Tuple4<Option<Object>, Option<Object>, Option<Object>, Option<Object>>> unapply(JDBCDatabaseMetadata x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4(x$0.databaseMajorVersion(), x$0.databaseMinorVersion(), x$0.databaseDriverMajorVersion(), x$0.databaseDriverMinorVersion()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCDatabaseMetadata$.class);
    }

    private final void closeConnection$1(ObjectRef conn$1) {
        try {
            if ((Connection)conn$1.elem != null) {
                ((Connection)conn$1.elem).close();
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "closed connection during metadata fetch");
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Exception closing connection during metadata fetch", (Throwable)e);
        }
    }

    private JDBCDatabaseMetadata$() {
    }
}

