/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.MappingMatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.InvalidPathException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.ee10.servlet.ServletApiRequest;
import org.sparkproject.jetty.ee10.servlet.ServletApiResponse;
import org.sparkproject.jetty.ee10.servlet.ServletChannel;
import org.sparkproject.jetty.ee10.servlet.ServletContextHandler;
import org.sparkproject.jetty.ee10.servlet.ServletContextRequest;
import org.sparkproject.jetty.ee10.servlet.ServletContextResponse;
import org.sparkproject.jetty.ee10.servlet.ServletCoreRequest;
import org.sparkproject.jetty.ee10.servlet.ServletCoreResponse;
import org.sparkproject.jetty.ee10.servlet.ServletHandler;
import org.sparkproject.jetty.http.CompressedContentFormat;
import org.sparkproject.jetty.http.HttpException;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.http.content.FileMappingHttpContentFactory;
import org.sparkproject.jetty.http.content.HttpContent;
import org.sparkproject.jetty.http.content.PreCompressedHttpContentFactory;
import org.sparkproject.jetty.http.content.ResourceHttpContentFactory;
import org.sparkproject.jetty.http.content.ValidatingCachingHttpContentFactory;
import org.sparkproject.jetty.http.content.VirtualHttpContentFactory;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.server.AliasCheck;
import org.sparkproject.jetty.server.AllowedResourceAliasChecker;
import org.sparkproject.jetty.server.Context;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.ResourceService;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.SymlinkAllowedResourceAliasChecker;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.util.Blocker;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.ExceptionUtil;
import org.sparkproject.jetty.util.URIUtil;
import org.sparkproject.jetty.util.resource.Resource;
import org.sparkproject.jetty.util.resource.Resources;

public class ResourceServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private ServletResourceService _resourceService;
    private WelcomeServletMode _welcomeServletMode;
    private boolean _pathInfoOnly;
    private ByteBufferPool.Sized _bufferPool;

    public ResourceService getResourceService() {
        return this._resourceService;
    }

    public void init() throws ServletException {
        String cc;
        int encodingHeaderCacheSize;
        boolean addAliasCheck;
        ServletContextHandler contextHandler = this.initContextHandler(this.getServletContext());
        this._resourceService = new ServletResourceService(contextHandler);
        this._resourceService.setWelcomeFactory(this._resourceService);
        Resource baseResource = contextHandler.getBaseResource();
        String rb = this.getInitParameter("baseResource", "resourceBase");
        if (rb != null) {
            try {
                Resource resource = baseResource = URIUtil.isRelative(rb) ? baseResource.resolve(rb) : contextHandler.newResource(rb);
                if (baseResource.isAlias()) {
                    baseResource = contextHandler.newResource(baseResource.getRealURI());
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to create baseResource from {}", (Object)rb, (Object)e);
                throw new UnavailableException(e.toString());
            }
        }
        if (!(baseResource == null || baseResource.isDirectory() && baseResource.isReadable())) {
            LOG.warn("baseResource {} is not a readable directory", (Object)baseResource);
        }
        if (this.getInitBoolean("allowAliases", true, "installAllowedResourceAliasChecker").booleanValue()) {
            addAliasCheck = true;
            for (AliasCheck aliasCheck : contextHandler.getAliasChecks()) {
                AllowedResourceAliasChecker allowedResourceAliasChecker;
                if (!(aliasCheck instanceof AllowedResourceAliasChecker) || !Objects.equals(baseResource, (allowedResourceAliasChecker = (AllowedResourceAliasChecker)aliasCheck).getBaseResource())) continue;
                addAliasCheck = false;
                break;
            }
            if (addAliasCheck) {
                contextHandler.addAliasCheck(new AllowedResourceAliasChecker((ContextHandler)contextHandler, baseResource));
            }
        }
        if (this.getInitBoolean("allowSymlinks", false)) {
            addAliasCheck = true;
            for (AliasCheck aliasCheck : contextHandler.getAliasChecks()) {
                SymlinkAllowedResourceAliasChecker aliasChecker;
                if (!(aliasCheck instanceof SymlinkAllowedResourceAliasChecker) || !Objects.equals(baseResource, (aliasChecker = (SymlinkAllowedResourceAliasChecker)aliasCheck).getBaseResource())) continue;
                addAliasCheck = false;
                break;
            }
            if (addAliasCheck) {
                contextHandler.addAliasCheck(new SymlinkAllowedResourceAliasChecker((ContextHandler)contextHandler, baseResource));
            }
        }
        List<CompressedContentFormat> precompressedFormats = this.parsePrecompressedFormats(this.getInitParameter("precompressed"), this.getInitBoolean("gzip"), this._resourceService.getPrecompressedFormats());
        HttpContent.Factory contentFactory = (HttpContent.Factory)this.getServletContext().getAttribute(HttpContent.Factory.class.getName());
        if (contentFactory == null) {
            long cacheValidationTime;
            MimeTypes.Mutable mimeTypes = contextHandler.getMimeTypes();
            ByteBufferPool.Sized bufferPool = this.getByteBufferPool(contextHandler);
            contentFactory = new ResourceHttpContentFactory(baseResource, mimeTypes, bufferPool);
            Object styleSheet = contextHandler.getServer().getDefaultStyleSheet();
            String stylesheetParam = this.getInitParameter("stylesheet");
            if (stylesheetParam != null) {
                try {
                    Resource s;
                    HttpContent styleSheetContent = contentFactory.getContent(stylesheetParam);
                    Resource resource = s = styleSheetContent == null ? null : styleSheetContent.getResource();
                    if (Resources.isReadableFile(s)) {
                        styleSheet = s;
                    } else {
                        LOG.warn("Stylesheet {} does not exist", (Object)stylesheetParam);
                    }
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Unable to use stylesheet: {}", (Object)stylesheetParam, (Object)e);
                    }
                    LOG.warn("Unable to use stylesheet: {} - {}", (Object)stylesheetParam, (Object)e.toString());
                }
            }
            if (this.getInitBoolean("useFileMappedBuffer", false)) {
                contentFactory = new FileMappingHttpContentFactory(contentFactory);
            }
            contentFactory = new VirtualHttpContentFactory(contentFactory, (Resource)styleSheet, "text/css", bufferPool);
            contentFactory = new PreCompressedHttpContentFactory(contentFactory, precompressedFormats);
            int maxCacheSize = this.getInitInt("maxCacheSize", -2);
            int maxCachedFileSize = this.getInitInt("maxCachedFileSize", -2);
            int maxCachedFiles = this.getInitInt("maxCachedFiles", -2);
            long l = cacheValidationTime = this.getInitParameter("cacheValidationTime") != null ? Long.parseLong(this.getInitParameter("cacheValidationTime")) : -2L;
            if (maxCachedFiles != -2 || maxCacheSize != -2 || maxCachedFileSize != -2 || cacheValidationTime != -2L) {
                ValidatingCachingHttpContentFactory cached = new ValidatingCachingHttpContentFactory(contentFactory, cacheValidationTime > -2L ? cacheValidationTime : Duration.ofSeconds(1L).toMillis(), bufferPool);
                contentFactory = cached;
                if (maxCacheSize >= 0) {
                    cached.setMaxCacheSize(maxCacheSize);
                }
                if (maxCachedFileSize >= 0) {
                    cached.setMaxCachedFileSize(maxCachedFileSize);
                }
                if (maxCachedFiles >= 0) {
                    cached.setMaxCachedFiles(maxCachedFiles);
                }
            }
        }
        this._resourceService.setHttpContentFactory(contentFactory);
        if (contextHandler.getWelcomeFiles() == null) {
            contextHandler.setWelcomeFiles(new String[]{"index.html", "index.jsp"});
        }
        this._resourceService.setAcceptRanges(this.getInitBoolean("acceptRanges", this._resourceService.isAcceptRanges()));
        this._resourceService.setDirAllowed(this.getInitBoolean("dirAllowed", this._resourceService.isDirAllowed()));
        boolean redirectWelcome = this.getInitBoolean("redirectWelcome", false);
        this._resourceService.setWelcomeMode(redirectWelcome ? ResourceService.WelcomeMode.REDIRECT : ResourceService.WelcomeMode.SERVE);
        this._resourceService.setPrecompressedFormats(precompressedFormats);
        this._resourceService.setEtags(this.getInitBoolean("etags", this._resourceService.isEtags()));
        this._welcomeServletMode = WelcomeServletMode.NONE;
        String welcomeServlets = this.getInitParameter("welcomeServlets");
        if (welcomeServlets != null) {
            welcomeServlets = welcomeServlets.toLowerCase(Locale.ENGLISH);
            switch (welcomeServlets) {
                case "true": {
                    WelcomeServletMode welcomeServletMode = WelcomeServletMode.MATCH;
                    break;
                }
                case "exact": {
                    WelcomeServletMode welcomeServletMode = WelcomeServletMode.EXACT;
                    break;
                }
                default: {
                    WelcomeServletMode welcomeServletMode = this._welcomeServletMode = WelcomeServletMode.NONE;
                }
            }
        }
        if ((encodingHeaderCacheSize = this.getInitInt("encodingHeaderCacheSize", -1)) >= 0) {
            this._resourceService.setEncodingCacheSize(encodingHeaderCacheSize);
        }
        if ((cc = this.getInitParameter("cacheControl")) != null) {
            this._resourceService.setCacheControl(cc);
        }
        ArrayList<String> gzipEquivalentFileExtensions = new ArrayList<String>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                gzipEquivalentFileExtensions.add((String)(s.charAt(0) == '.' ? s : "." + s));
            }
        } else {
            gzipEquivalentFileExtensions.add(".svgz");
        }
        this._resourceService.setGzipEquivalentFileExtensions(gzipEquivalentFileExtensions);
        this._pathInfoOnly = this.getInitBoolean("pathInfoOnly", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("  .baseResource = {}", (Object)baseResource);
            LOG.debug("  .resourceService = {}", (Object)this._resourceService);
            LOG.debug("  .welcomeServletMode = {}", (Object)this._welcomeServletMode);
        }
    }

    private ByteBufferPool.Sized getByteBufferPool(ContextHandler contextHandler) {
        if (this._bufferPool != null) {
            return this._bufferPool;
        }
        if (contextHandler == null) {
            return ByteBufferPool.SIZED_NON_POOLING;
        }
        Server server = contextHandler.getServer();
        if (server == null) {
            return ByteBufferPool.SIZED_NON_POOLING;
        }
        this._bufferPool = new ByteBufferPool.Sized(server.getByteBufferPool(), this.getInitBoolean("useDirectByteBuffers", true), this.getInitInt("byteBufferSize", 32768));
        return this._bufferPool;
    }

    private String getInitParameter(String name, String ... deprecated) {
        String value = this.getInitParameter(name);
        if (value != null) {
            return value;
        }
        for (String d : deprecated) {
            value = this.getInitParameter(d);
            if (value == null) continue;
            LOG.warn("Deprecated {} used instead of {}", (Object)d, (Object)name);
            return value;
        }
        return null;
    }

    private List<CompressedContentFormat> parsePrecompressedFormats(String precompressed, Boolean gzip, List<CompressedContentFormat> dft) {
        if (precompressed == null && gzip == null) {
            return dft;
        }
        ArrayList<CompressedContentFormat> ret = new ArrayList<CompressedContentFormat>();
        if (precompressed != null && precompressed.indexOf(61) > 0) {
            for (String pair : precompressed.split(",")) {
                String[] setting = pair.split("=");
                String encoding = setting[0].trim();
                String extension = setting[1].trim();
                ret.add(new CompressedContentFormat(encoding, extension));
                if (gzip != Boolean.TRUE || ret.contains(CompressedContentFormat.GZIP)) continue;
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (precompressed != null) {
            if (Boolean.parseBoolean(precompressed)) {
                ret.add(CompressedContentFormat.BR);
                ret.add(CompressedContentFormat.GZIP);
            }
        } else if (gzip == Boolean.TRUE) {
            ret.add(CompressedContentFormat.GZIP);
        }
        return ret;
    }

    private Boolean getInitBoolean(String name) {
        String value = this.getInitParameter(name);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private Boolean getInitBoolean(String name, boolean dft, String ... deprecated) {
        String value = this.getInitParameter(name, deprecated);
        if (value == null || value.isEmpty()) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private boolean getInitBoolean(String name, boolean dft) {
        return Optional.ofNullable(this.getInitBoolean(name)).orElse(dft);
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value != null && !value.isEmpty()) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    protected ServletContextHandler initContextHandler(ServletContext servletContext) {
        if (servletContext instanceof ServletContextHandler.ServletContextApi) {
            ServletContextHandler.ServletContextApi api = (ServletContextHandler.ServletContextApi)servletContext;
            return api.getContext().getServletContextHandler();
        }
        Context context = ContextHandler.getCurrentContext();
        if (context instanceof ContextHandler.ScopedContext) {
            ContextHandler.ScopedContext scopedContext = (ContextHandler.ScopedContext)context;
            return (ServletContextHandler)scopedContext.getContextHandler();
        }
        throw new IllegalArgumentException("The servletContext " + String.valueOf(servletContext) + " " + servletContext.getClass().getName() + " is not " + ContextHandler.ScopedContext.class.getName());
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block22: {
            boolean included = httpServletRequest.getDispatcherType() == DispatcherType.INCLUDE;
            String encodedPathInContext = this.getEncodedPathInContext(httpServletRequest, included);
            if (LOG.isDebugEnabled()) {
                LOG.debug("doGet(hsReq={}, hsResp={}) pathInContext={}, included={}", new Object[]{httpServletRequest, httpServletResponse, encodedPathInContext, included});
            }
            try {
                String characterEncoding;
                HttpContent content = this._resourceService.getContent(encodedPathInContext, ServletContextRequest.getServletContextRequest((ServletRequest)httpServletRequest));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("content = {}", (Object)content);
                }
                if (content == null || Resources.missing(content.getResource())) {
                    this.doNotFound(httpServletRequest, httpServletResponse, encodedPathInContext);
                    break block22;
                }
                ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)httpServletRequest);
                ServletContextResponse servletContextResponse = servletContextRequest.getServletContextResponse();
                ServletChannel servletChannel = servletContextRequest.getServletChannel();
                Request coreRequest = httpServletRequest instanceof ServletApiRequest ? servletChannel.getRequest() : ServletCoreRequest.wrap(httpServletRequest);
                boolean writingOrStreaming = servletContextResponse.isWritingOrStreaming();
                boolean useServletResponse = !(httpServletResponse instanceof ServletApiResponse) || writingOrStreaming;
                Response r = useServletResponse ? new ServletCoreResponse(coreRequest, httpServletResponse, included) : servletChannel.getResponse();
                Response.Wrapper coreResponse = new Response.Wrapper(coreRequest, r){

                    @Override
                    public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
                        super.write(false, byteBuffer, callback);
                    }
                };
                if (coreResponse.isCommitted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Response already committed for {}", (Object)coreRequest.getHttpURI());
                    }
                    return;
                }
                long contentLength = content.getContentLengthValue();
                if (writingOrStreaming) {
                    content = new UnknownLengthHttpContent(content);
                }
                if ((characterEncoding = servletContextResponse.getRawCharacterEncoding()) != null) {
                    content = new ForcedCharacterEncodingHttpContent(content, characterEncoding);
                }
                if (httpServletRequest.isAsyncSupported() && (contentLength < 0L || contentLength > (long)coreRequest.getConnectionMetaData().getHttpConfiguration().getOutputBufferSize())) {
                    AsyncContext asyncContext;
                    if (httpServletRequest.isAsyncStarted()) {
                        asyncContext = httpServletRequest.getAsyncContext();
                    } else {
                        asyncContext = httpServletRequest.startAsync();
                        asyncContext.setTimeout(0L);
                    }
                    AsyncContextCallback callback = new AsyncContextCallback(asyncContext, httpServletResponse);
                    this._resourceService.doGet(coreRequest, coreResponse, callback, content);
                    break block22;
                }
                try (Blocker.Callback callback = Blocker.callback();){
                    this._resourceService.doGet(coreRequest, coreResponse, callback, content);
                    callback.block();
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (InvalidPathException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("InvalidPathException for pathInContext: {}", (Object)encodedPathInContext, (Object)e);
                }
                if (included) {
                    throw new FileNotFoundException(encodedPathInContext);
                }
                httpServletResponse.setStatus(404);
            }
        }
    }

    protected String getEncodedPathInContext(HttpServletRequest request, boolean included) {
        HttpServletMapping mapping = request.getHttpServletMapping();
        if (included) {
            Object object = request.getAttribute("jakarta.servlet.include.mapping");
            if (object instanceof HttpServletMapping) {
                HttpServletMapping httpServletMapping;
                mapping = httpServletMapping = (HttpServletMapping)object;
            } else {
                return URIUtil.encodePath(URIUtil.addPaths(request.getServletPath(), request.getPathInfo()));
            }
        }
        return switch (mapping.getMappingMatch()) {
            default -> throw new IncompatibleClassChangeError();
            case MappingMatch.CONTEXT_ROOT -> "/";
            case MappingMatch.DEFAULT, MappingMatch.EXTENSION, MappingMatch.EXACT -> {
                ServletApiRequest apiRequest;
                if (included) {
                    yield URIUtil.encodePath((String)request.getAttribute("jakarta.servlet.include.servlet_path"));
                }
                if (request instanceof ServletApiRequest) {
                    apiRequest = (ServletApiRequest)request;
                    yield Context.getPathInContext(request.getContextPath(), apiRequest.getRequest().getHttpURI().getCanonicalPath());
                }
                yield URIUtil.encodePath(request.getServletPath());
            }
            case MappingMatch.PATH -> {
                ServletApiRequest apiRequest;
                if (this._pathInfoOnly) {
                    if (included) {
                        yield URIUtil.encodePath((String)request.getAttribute("jakarta.servlet.include.path_info"));
                    }
                    yield URIUtil.encodePath(request.getPathInfo());
                }
                if (included) {
                    yield URIUtil.encodePath(URIUtil.addPaths((String)request.getAttribute("jakarta.servlet.include.servlet_path"), (String)request.getAttribute("jakarta.servlet.include.path_info")));
                }
                if (request instanceof ServletApiRequest) {
                    apiRequest = (ServletApiRequest)request;
                    yield Context.getPathInContext(request.getContextPath(), apiRequest.getRequest().getHttpURI().getCanonicalPath());
                }
                yield URIUtil.encodePath(URIUtil.addPaths(request.getServletPath(), request.getPathInfo()));
            }
        };
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doHead(req={}, resp={}) (calling doGet())", (Object)req, (Object)resp);
        }
        this.doGet(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET, HEAD, OPTIONS");
    }

    protected void doNotFound(HttpServletRequest request, HttpServletResponse response, String encodedPathInContext) throws IOException {
        if (request.getDispatcherType() == DispatcherType.INCLUDE) {
            throw new FileNotFoundException(encodedPathInContext);
        }
        response.sendError(404);
    }

    static String getIncludedPathInContext(HttpServletRequest request, String includedServletPath) {
        String pathInfo = (String)request.getAttribute("jakarta.servlet.include.path_info");
        return URIUtil.addPaths(includedServletPath, pathInfo);
    }

    private static boolean isIncluded(HttpServletRequest request) {
        return request.getAttribute("jakarta.servlet.include.request_uri") != null;
    }

    private class ServletResourceService
    extends ResourceService
    implements ResourceService.WelcomeFactory {
        private final ServletContextHandler _servletContextHandler;

        private ServletResourceService(ServletContextHandler servletContextHandler) {
            this._servletContextHandler = servletContextHandler;
        }

        @Override
        public String getWelcomeTarget(HttpContent content, Request coreRequest) {
            String[] welcomes = this._servletContextHandler.getWelcomeFiles();
            if (welcomes == null) {
                return null;
            }
            String pathInContext = Request.getPathInContext(coreRequest);
            String welcomeTarget = null;
            Resource base = content.getResource();
            if (Resources.isReadableDirectory(base)) {
                for (String welcome : welcomes) {
                    ServletHandler.MappedServlet entry;
                    String welcomeInContext = URIUtil.addPaths(pathInContext, welcome);
                    Resource welcomePath = content.getResource().resolve(welcome);
                    if (Resources.isReadableFile(welcomePath)) {
                        return welcomeInContext;
                    }
                    if (ResourceServlet.this._welcomeServletMode == WelcomeServletMode.NONE || welcomeTarget != null || (entry = this._servletContextHandler.getServletHandler().getMappedServlet(welcomeInContext)) == null || entry.getServletHolder().getServletInstance() == ResourceServlet.this || ResourceServlet.this._welcomeServletMode != WelcomeServletMode.MATCH && !entry.getPathSpec().getDeclaration().equals(welcomeInContext)) continue;
                    welcomeTarget = welcomeInContext;
                }
            }
            return welcomeTarget;
        }

        @Override
        protected void serveWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            HttpServletRequest servletRequest = this.getServletRequest(request);
            HttpServletResponse servletResponse = this.getServletResponse(response);
            boolean included = ResourceServlet.isIncluded(servletRequest);
            RequestDispatcher dispatcher = servletRequest.getServletContext().getRequestDispatcher(welcomeTarget);
            if (dispatcher == null) {
                Response.writeError(request, response, callback, 500);
                return;
            }
            try {
                if (included) {
                    dispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                } else {
                    servletRequest.setAttribute("org.sparkproject.jetty.server.welcome", (Object)welcomeTarget);
                    dispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                }
                callback.succeeded();
            }
            catch (ServletException e) {
                callback.failed(e);
            }
        }

        @Override
        protected void rehandleWelcome(Request request, Response response, Callback callback, String welcomeTarget) throws IOException {
            this.serveWelcome(request, response, callback, welcomeTarget);
        }

        @Override
        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, int statusCode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("writeHttpError(coreRequest={}, coreResponse={}, callback={}, statusCode={})", new Object[]{coreRequest, coreResponse, callback, statusCode});
            }
            this.writeHttpError(coreRequest, coreResponse, callback, statusCode, null, null);
        }

        @Override
        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, Throwable cause) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(cause).log("writeHttpError(coreRequest={}, coreResponse={}, callback={}, cause={})", new Object[]{coreRequest, coreResponse, callback, cause});
            }
            int statusCode = 500;
            String reason = null;
            if (cause instanceof HttpException) {
                HttpException httpException = (HttpException)((Object)cause);
                statusCode = httpException.getCode();
                reason = httpException.getReason();
            }
            this.writeHttpError(coreRequest, coreResponse, callback, statusCode, reason, cause);
        }

        @Override
        protected void writeHttpError(Request coreRequest, Response coreResponse, Callback callback, int statusCode, String reason, Throwable cause) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(cause).log("writeHttpError(coreRequest={}, coreResponse={}, callback={}, statusCode={}, reason={}, cause={})", new Object[]{coreRequest, coreResponse, callback, statusCode, reason, cause});
            }
            HttpServletRequest request = this.getServletRequest(coreRequest);
            HttpServletResponse response = this.getServletResponse(coreResponse);
            try {
                if (ResourceServlet.isIncluded(request)) {
                    return;
                }
                if (cause != null) {
                    request.setAttribute("org.sparkproject.jetty.server.error_exception", (Object)cause);
                }
                response.sendError(statusCode, reason);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                callback.succeeded();
            }
        }

        @Override
        protected boolean handleConditionalHeaders(Request request, Response response, HttpContent content, Callback callback) throws IOException {
            boolean included = ResourceServlet.isIncluded(this.getServletRequest(request));
            if (included) {
                return false;
            }
            return super.handleConditionalHeaders(request, response, content, callback);
        }

        private HttpServletRequest getServletRequest(Request request) {
            ServletCoreRequest servletCoreRequest = Request.asInContext(request, ServletCoreRequest.class);
            if (servletCoreRequest != null) {
                return servletCoreRequest.getServletRequest();
            }
            ServletContextRequest servletContextRequest = Request.as(request, ServletContextRequest.class);
            if (servletContextRequest != null) {
                return servletContextRequest.getServletApiRequest();
            }
            throw new IllegalStateException("instanceof " + String.valueOf(request.getClass()));
        }

        private HttpServletResponse getServletResponse(Response response) {
            ServletCoreResponse servletCoreResponse = Response.asInContext(response, ServletCoreResponse.class);
            if (servletCoreResponse != null) {
                return servletCoreResponse.getServletResponse();
            }
            ServletContextResponse servletContextResponse = Response.asInContext(response, ServletContextResponse.class);
            if (servletContextResponse != null) {
                return servletContextResponse.getServletApiResponse();
            }
            throw new IllegalStateException("instanceof " + String.valueOf(response.getClass()));
        }
    }

    private static enum WelcomeServletMode {
        NONE,
        MATCH,
        EXACT;

    }

    private static class UnknownLengthHttpContent
    extends HttpContent.Wrapper {
        public UnknownLengthHttpContent(HttpContent content) {
            super(content);
        }

        @Override
        public HttpField getContentLength() {
            return null;
        }

        @Override
        public long getContentLengthValue() {
            return -1L;
        }
    }

    private static class ForcedCharacterEncodingHttpContent
    extends HttpContent.Wrapper {
        private final String characterEncoding;
        private final HttpField contentType;

        public ForcedCharacterEncodingHttpContent(HttpContent content, String characterEncoding) {
            super(Objects.requireNonNull(content));
            this.characterEncoding = characterEncoding;
            if (content.getContentTypeValue() == null || content.getResource().isDirectory()) {
                this.contentType = null;
            } else {
                String mimeType = content.getContentTypeValue();
                int idx = mimeType.indexOf(";charset");
                if (idx >= 0) {
                    mimeType = mimeType.substring(0, idx);
                }
                this.contentType = new HttpField(HttpHeader.CONTENT_TYPE, mimeType + ";charset=" + characterEncoding);
            }
        }

        @Override
        public HttpField getContentType() {
            return this.contentType;
        }

        @Override
        public String getCharacterEncoding() {
            return this.characterEncoding;
        }
    }

    private static class AsyncContextCallback
    implements Callback {
        private final AsyncContext _asyncContext;
        private final HttpServletResponse _response;

        private AsyncContextCallback(AsyncContext asyncContext, HttpServletResponse response) {
            this._asyncContext = asyncContext;
            this._response = response;
        }

        @Override
        public void succeeded() {
            this._asyncContext.complete();
        }

        @Override
        public void failed(Throwable x) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("AsyncContextCallback failed {}", (Object)this._asyncContext);
                }
                this._response.sendError(-1);
            }
            catch (IOException e) {
                ExceptionUtil.addSuppressedIfNotAssociated(x, e);
            }
            finally {
                this._asyncContext.complete();
            }
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("Async get failed");
            }
        }
    }
}

