/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.package$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.PrometheusResource$;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import org.sparkproject.jetty.ee10.servlet.ServletContextHandler;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Experimental
@Path(value="/executors")
@ScalaSignature(bytes="\u0006\u0005)4Qa\u0002\u0005\u0001\u0011QAQa\b\u0001\u0005\u0002\u0005BQa\t\u0001\u0005\u0002\u0011:aa\u0015\u0005\t\u00029!fAB\u0004\t\u0011\u0003qQ\u000bC\u0003 \t\u0011\u0005a\u000bC\u0003X\t\u0011\u0005\u0001L\u0001\nQe>lW\r\u001e5fkN\u0014Vm]8ve\u000e,'BA\u0005\u000b\u0003\t1\u0018G\u0003\u0002\f\u0019\u0005\u0019\u0011\r]5\u000b\u00055q\u0011AB:uCR,8O\u0003\u0002\u0010!\u0005)1\u000f]1sW*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h'\r\u0001Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"\u0001\u0005\n\u0005yA!!E!qSJ+\u0017/^3ti\u000e{g\u000e^3yi\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001#!\ta\u0002!A\u0005fq\u0016\u001cW\u000f^8sgR\tQ\u0005\u0005\u0002'[9\u0011qe\u000b\t\u0003Q]i\u0011!\u000b\u0006\u0003U\u0001\na\u0001\u0010:p_Rt\u0014B\u0001\u0017\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051:\u0002F\u0001\u00022!\t\u0011\u0014(D\u00014\u0015\t!T'\u0001\u0002sg*\u0011agN\u0001\u0003oNT\u0011\u0001O\u0001\bU\u0006\\\u0017M\u001d;b\u0013\tQ4GA\u0002H\u000bRCCA\u0001\u001f@\u0001B\u0011!'P\u0005\u0003}M\u0012A\u0001U1uQ\u0006)a/\u00197vK\u0006\n\u0011)\u0001\u0006qe>lW\r\u001e5fkNDCAA\"@\rB\u0011!\u0007R\u0005\u0003\u000bN\u0012\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0002\u000f\u0006\n\u0001*\u0001\u0006uKb$x\u0006\u001d7bS:D#\u0001\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055s\u0011AC1o]>$\u0018\r^5p]&\u0011q\n\u0014\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0005\u0001qz\u0014+I\u0001S\u0003)yS\r_3dkR|'o]\u0001\u0013!J|W.\u001a;iKV\u001c(+Z:pkJ\u001cW\r\u0005\u0002\u001d\tM\u0011A!\u0006\u000b\u0002)\u0006\tr-\u001a;TKJ4H.\u001a;IC:$G.\u001a:\u0015\u0005e+\u0007C\u0001.d\u001b\u0005Y&B\u0001/^\u0003\u001d\u0019XM\u001d<mKRT!AX0\u0002\t\u0015,\u0017\u0007\r\u0006\u0003A\u0006\fQA[3uifT!A\u0019\n\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011Am\u0017\u0002\u0016'\u0016\u0014h\u000f\\3u\u0007>tG/\u001a=u\u0011\u0006tG\r\\3s\u0011\u00151g\u00011\u0001h\u0003\u0019)\u0018NU8piB\u0011A\u0004[\u0005\u0003S\"\u0011a!V%S_>$\b")
public class PrometheusResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public static ServletContextHandler getServletHandler(UIRoot uiRoot) {
        return PrometheusResource$.MODULE$.getServletHandler(uiRoot);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    @Path(value="prometheus")
    @Produces(value={"text/plain"})
    public String executors() {
        StringBuilder sb = new StringBuilder();
        sb.append("spark_info{version=\"" + package$.MODULE$.SPARK_VERSION_SHORT() + "\", revision=\"" + package$.MODULE$.SPARK_REVISION() + "\"} 1.0\n");
        AppStatusStore store = ((SparkUI)this.uiRoot()).store();
        store.executorList(true).foreach((Function1 & Serializable)executor -> {
            PrometheusResource.$anonfun$executors$1(store, sb, executor);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    public static final /* synthetic */ void $anonfun$executors$3(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$executors$5(StringBuilder sb$1, String prefix$1, String labels$1, ExecutorMetrics m) {
        String[] names = (String[])((Object[])new String[]{"JVMHeapMemory", "JVMOffHeapMemory", "OnHeapExecutionMemory", "OffHeapExecutionMemory", "OnHeapStorageMemory", "OffHeapStorageMemory", "OnHeapUnifiedMemory", "OffHeapUnifiedMemory", "DirectPoolMemory", "MappedPoolMemory", "ProcessTreeJVMVMemory", "ProcessTreeJVMRSSMemory", "ProcessTreePythonVMemory", "ProcessTreePythonRSSMemory", "ProcessTreeOtherVMemory", "ProcessTreeOtherRSSMemory"});
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])names), (Function1 & Serializable)name -> sb$1.append(prefix$1 + name + "_bytes" + labels$1 + " " + m.getMetricValue((String)name) + "\n"));
        new .colon.colon((Object)"MinorGCCount", (List)new .colon.colon((Object)"MajorGCCount", (List)new .colon.colon((Object)"ConcurrentGCCount", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)name -> sb$1.append(prefix$1 + name + "_total" + labels$1 + " " + m.getMetricValue((String)name) + "\n"));
        new .colon.colon((Object)"MinorGCTime", (List)new .colon.colon((Object)"MajorGCTime", (List)new .colon.colon((Object)"ConcurrentGCTime", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)name -> sb$1.append(prefix$1 + name + "_seconds_total" + labels$1 + " " + (double)m.getMetricValue((String)name) * 0.001 + "\n"));
    }

    public static final /* synthetic */ void $anonfun$executors$1(AppStatusStore store$1, StringBuilder sb$1, ExecutorSummary executor) {
        String prefix = "metrics_executor_";
        String labels = ((IterableOnceOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application_id"), (Object)store$1.applicationInfo().id()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application_name"), (Object)store$1.applicationInfo().name()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executor_id"), (Object)executor.id()), (List)Nil$.MODULE$))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return k + "=\"" + v + "\"";
            }
            throw new MatchError((Object)tuple2);
        })).mkString("{", ", ", "}");
        sb$1.append(prefix + "rddBlocks" + labels + " " + executor.rddBlocks() + "\n");
        sb$1.append(prefix + "memoryUsed_bytes" + labels + " " + executor.memoryUsed() + "\n");
        sb$1.append(prefix + "diskUsed_bytes" + labels + " " + executor.diskUsed() + "\n");
        sb$1.append(prefix + "totalCores" + labels + " " + executor.totalCores() + "\n");
        sb$1.append(prefix + "maxTasks" + labels + " " + executor.maxTasks() + "\n");
        sb$1.append(prefix + "activeTasks" + labels + " " + executor.activeTasks() + "\n");
        sb$1.append(prefix + "failedTasks_total" + labels + " " + executor.failedTasks() + "\n");
        sb$1.append(prefix + "completedTasks_total" + labels + " " + executor.completedTasks() + "\n");
        sb$1.append(prefix + "totalTasks_total" + labels + " " + executor.totalTasks() + "\n");
        sb$1.append(prefix + "totalDuration_seconds_total" + labels + " " + (double)executor.totalDuration() * 0.001 + "\n");
        sb$1.append(prefix + "totalGCTime_seconds_total" + labels + " " + (double)executor.totalGCTime() * 0.001 + "\n");
        sb$1.append(prefix + "totalInputBytes_bytes_total" + labels + " " + executor.totalInputBytes() + "\n");
        sb$1.append(prefix + "totalShuffleRead_bytes_total" + labels + " " + executor.totalShuffleRead() + "\n");
        sb$1.append(prefix + "totalShuffleWrite_bytes_total" + labels + " " + executor.totalShuffleWrite() + "\n");
        sb$1.append(prefix + "maxMemory_bytes" + labels + " " + executor.maxMemory() + "\n");
        executor.executorLogs().foreach((Function1 & Serializable)x0$2 -> {
            PrometheusResource.$anonfun$executors$3(x0$2);
            return BoxedUnit.UNIT;
        });
        executor.memoryMetrics().foreach((Function1 & Serializable)m -> {
            sb$1.append(prefix + "usedOnHeapStorageMemory_bytes" + labels + " " + m.usedOnHeapStorageMemory() + "\n");
            sb$1.append(prefix + "usedOffHeapStorageMemory_bytes" + labels + " " + m.usedOffHeapStorageMemory() + "\n");
            sb$1.append(prefix + "totalOnHeapStorageMemory_bytes" + labels + " " + m.totalOnHeapStorageMemory() + "\n");
            return sb$1.append(prefix + "totalOffHeapStorageMemory_bytes" + labels + " " + m.totalOffHeapStorageMemory() + "\n");
        });
        executor.peakMemoryMetrics().foreach((Function1 & Serializable)m -> {
            PrometheusResource.$anonfun$executors$5(sb$1, prefix, labels, m);
            return BoxedUnit.UNIT;
        });
    }

    public PrometheusResource() {
        ApiRequestContext.$init$(this);
    }
}

