/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.WeakValueMap;

public abstract class AbstractLazyLoadList<E>
implements List<E> {
    private Map<Integer, E> itemsByIndex = null;
    protected int size = -1;

    public AbstractLazyLoadList(String cacheType) {
        this.itemsByIndex = cacheType != null ? (cacheType.equalsIgnoreCase("soft") ? new SoftValueMap() : (cacheType.equalsIgnoreCase("weak") ? new WeakValueMap() : (cacheType.equalsIgnoreCase("strong") ? new HashMap<Integer, E>() : (cacheType.equalsIgnoreCase("none") ? null : new WeakValueMap())))) : new WeakValueMap();
    }

    protected abstract E retrieveObjectForIndex(int var1);

    protected abstract int getSize();

    protected boolean isOpen() {
        return true;
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean add(Object e) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public E get(int index) {
        if (this.itemsByIndex != null && this.itemsByIndex.containsKey(index)) {
            return this.itemsByIndex.get(index);
        }
        E obj = this.retrieveObjectForIndex(index);
        this.itemsByIndex.put(index, obj);
        return obj;
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new LazyLoadListIterator();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public int size() {
        if (this.size >= 0) {
            return this.size;
        }
        this.size = this.getSize();
        return this.size;
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException(Localiser.msg("052603"));
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.itemsByIndex != null && this.itemsByIndex.containsKey(i) ? this.itemsByIndex.get(i) : this.retrieveObjectForIndex(i);
        }
        return array;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a == null) {
            throw new NullPointerException("null argument is illegal!");
        }
        Object[] array = a;
        int ourSize = this.size();
        if (a.length < ourSize) {
            array = new Object[this.size()];
        }
        for (int i = 0; i < ourSize; ++i) {
            array[i] = this.itemsByIndex != null && this.itemsByIndex.containsKey(i) ? this.itemsByIndex.get(i) : this.retrieveObjectForIndex(i);
        }
        return array;
    }

    private class LazyLoadListIterator
    implements ListIterator {
        private int iteratorIndex = 0;

        private LazyLoadListIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            AbstractLazyLoadList abstractLazyLoadList = AbstractLazyLoadList.this;
            synchronized (abstractLazyLoadList) {
                if (!AbstractLazyLoadList.this.isOpen()) {
                    return false;
                }
                return this.iteratorIndex <= AbstractLazyLoadList.this.size() - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasPrevious() {
            AbstractLazyLoadList abstractLazyLoadList = AbstractLazyLoadList.this;
            synchronized (abstractLazyLoadList) {
                if (!AbstractLazyLoadList.this.isOpen()) {
                    return false;
                }
                return this.iteratorIndex > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            AbstractLazyLoadList abstractLazyLoadList = AbstractLazyLoadList.this;
            synchronized (abstractLazyLoadList) {
                if (!AbstractLazyLoadList.this.isOpen()) {
                    throw new NoSuchElementException(Localiser.msg("052600"));
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next element");
                }
                if (AbstractLazyLoadList.this.itemsByIndex != null && AbstractLazyLoadList.this.itemsByIndex.containsKey(this.iteratorIndex)) {
                    return AbstractLazyLoadList.this.itemsByIndex.get(this.iteratorIndex);
                }
                Object obj = AbstractLazyLoadList.this.retrieveObjectForIndex(this.iteratorIndex);
                if (AbstractLazyLoadList.this.itemsByIndex != null) {
                    AbstractLazyLoadList.this.itemsByIndex.put(this.iteratorIndex, obj);
                }
                ++this.iteratorIndex;
                return obj;
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.iteratorIndex;
            }
            return AbstractLazyLoadList.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            AbstractLazyLoadList abstractLazyLoadList = AbstractLazyLoadList.this;
            synchronized (abstractLazyLoadList) {
                if (!AbstractLazyLoadList.this.isOpen()) {
                    throw new NoSuchElementException(Localiser.msg("052600"));
                }
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous element");
                }
                --this.iteratorIndex;
                if (AbstractLazyLoadList.this.itemsByIndex != null && AbstractLazyLoadList.this.itemsByIndex.containsKey(this.iteratorIndex)) {
                    return AbstractLazyLoadList.this.itemsByIndex.get(this.iteratorIndex);
                }
                Object obj = AbstractLazyLoadList.this.retrieveObjectForIndex(this.iteratorIndex);
                if (AbstractLazyLoadList.this.itemsByIndex != null) {
                    AbstractLazyLoadList.this.itemsByIndex.put(this.iteratorIndex, obj);
                }
                ++this.iteratorIndex;
                return obj;
            }
        }

        @Override
        public int previousIndex() {
            if (this.iteratorIndex == 0) {
                return -1;
            }
            return this.iteratorIndex - 1;
        }

        public void add(Object e) {
            throw new UnsupportedOperationException(Localiser.msg("052603"));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Localiser.msg("052603"));
        }

        public void set(Object e) {
            throw new UnsupportedOperationException(Localiser.msg("052603"));
        }
    }
}

