/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.apache.spark.sql.catalyst.util.Geometry;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryCollection;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.LineString;
import org.apache.spark.sql.catalyst.util.geo.MultiLineString;
import org.apache.spark.sql.catalyst.util.geo.MultiPoint;
import org.apache.spark.sql.catalyst.util.geo.MultiPolygon;
import org.apache.spark.sql.catalyst.util.geo.Point;
import org.apache.spark.sql.catalyst.util.geo.Polygon;
import org.apache.spark.sql.catalyst.util.geo.Ring;
import org.apache.spark.sql.catalyst.util.geo.WkbParseException;
import org.apache.spark.sql.catalyst.util.geo.WkbUtil;

public class WkbReader {
    private ByteBuffer buffer;
    private final int validationLevel;
    private byte[] currentWkb;

    public WkbReader() {
        this(1);
    }

    public WkbReader(int validationLevel) {
        this.validationLevel = validationLevel;
    }

    private static boolean isValidCoordinate(double value) {
        return Double.isFinite(value);
    }

    private static boolean isValidCoordinateAllowEmpty(double value) {
        return Double.isFinite(value) || Double.isNaN(value);
    }

    public GeometryModel read(byte[] wkb) {
        try {
            this.currentWkb = wkb;
            GeometryModel geometryModel = this.readGeometry(Geometry.DEFAULT_SRID);
            return geometryModel;
        }
        finally {
            this.buffer = null;
            this.currentWkb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeometryModel read(byte[] wkb, int srid) {
        try {
            this.currentWkb = wkb;
            GeometryModel geometryModel = this.readGeometry(srid);
            return geometryModel;
        }
        finally {
            this.buffer = null;
            this.currentWkb = null;
        }
    }

    private void checkNotAtEnd(long pos) {
        if (this.buffer.position() >= this.buffer.limit()) {
            throw new WkbParseException("Unexpected end of WKB buffer", pos, this.currentWkb);
        }
    }

    private ByteOrder readEndianness() {
        this.checkNotAtEnd(this.buffer.position());
        byte endianValue = this.buffer.get();
        if (endianValue != 0 && endianValue != 1) {
            throw new WkbParseException("Invalid byte order " + endianValue, this.buffer.position() - 1, this.currentWkb);
        }
        return endianValue == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    private int readInt() {
        if (this.buffer.remaining() < 4) {
            throw new WkbParseException("Unexpected end of WKB buffer", this.buffer.position(), this.currentWkb);
        }
        return this.buffer.getInt();
    }

    private double readDoubleAllowEmpty() {
        if (this.buffer.remaining() < 8) {
            throw new WkbParseException("Unexpected end of WKB buffer", this.buffer.position(), this.currentWkb);
        }
        double value = this.buffer.getDouble();
        if (!WkbReader.isValidCoordinateAllowEmpty(value)) {
            throw new WkbParseException("Invalid coordinate value found", this.buffer.position() - 8, this.currentWkb);
        }
        return value;
    }

    private double readDoubleNoEmpty() {
        if (this.buffer.remaining() < 8) {
            throw new WkbParseException("Unexpected end of WKB buffer", this.buffer.position(), this.currentWkb);
        }
        double value = this.buffer.getDouble();
        if (!WkbReader.isValidCoordinate(value)) {
            throw new WkbParseException("Invalid coordinate value found", this.buffer.position() - 8, this.currentWkb);
        }
        return value;
    }

    private GeometryModel readGeometry(int defaultSrid) {
        if (this.currentWkb == null || this.currentWkb.length < 1) {
            throw new WkbParseException("WKB data is empty or null", 0L, this.currentWkb);
        }
        if (this.currentWkb.length < 5) {
            throw new WkbParseException("WKB data too short", 0L, this.currentWkb);
        }
        this.buffer = ByteBuffer.wrap(this.currentWkb);
        ByteOrder byteOrder = this.readEndianness();
        this.buffer.order(byteOrder);
        return this.readGeometryInternal(defaultSrid);
    }

    private GeometryModel readNestedGeometryWithDimensionCheck(int defaultSrid, boolean expectedHasZ, boolean expectedHasM) {
        return this.readNestedGeometryInternal(defaultSrid, true, expectedHasZ, expectedHasM);
    }

    private GeometryModel readNestedGeometryInternal(int defaultSrid, boolean validateDimensions, boolean expectedHasZ, boolean expectedHasM) {
        ByteOrder byteOrder = this.readEndianness();
        ByteOrder savedByteOrder = this.buffer.order();
        this.buffer.order(byteOrder);
        long typeStartPos = this.buffer.position();
        int typeAndDim = this.readInt();
        if (!WkbUtil.isValidWkbType(typeAndDim)) {
            throw new WkbParseException("Invalid or unsupported type " + typeAndDim, typeStartPos, this.currentWkb);
        }
        GeoTypeId geoType = WkbUtil.getBaseType(typeAndDim);
        int dimensionCount = WkbUtil.getDimensionCount(typeAndDim);
        boolean hasZ = WkbUtil.hasZ(typeAndDim);
        boolean hasM = WkbUtil.hasM(typeAndDim);
        if (validateDimensions && (hasZ != expectedHasZ || hasM != expectedHasM)) {
            throw new WkbParseException("Invalid or unsupported type " + typeAndDim, typeStartPos, this.currentWkb);
        }
        GeometryModel result = this.readGeometryData(geoType, defaultSrid, dimensionCount, hasZ, hasM, typeStartPos);
        this.buffer.order(savedByteOrder);
        return result;
    }

    private GeometryModel readGeometryInternal(int defaultSrid) {
        long typeStartPos = this.buffer.position();
        int typeAndDim = this.readInt();
        if (!WkbUtil.isValidWkbType(typeAndDim)) {
            throw new WkbParseException("Invalid or unsupported type " + typeAndDim, typeStartPos, this.currentWkb);
        }
        GeoTypeId geoType = WkbUtil.getBaseType(typeAndDim);
        int dimensionCount = WkbUtil.getDimensionCount(typeAndDim);
        boolean hasZ = WkbUtil.hasZ(typeAndDim);
        boolean hasM = WkbUtil.hasM(typeAndDim);
        return this.readGeometryData(geoType, defaultSrid, dimensionCount, hasZ, hasM, typeStartPos);
    }

    private GeometryModel readGeometryData(GeoTypeId geoType, int defaultSrid, int dimensionCount, boolean hasZ, boolean hasM, long typeStartPos) {
        switch (geoType) {
            case POINT: {
                return this.readPoint(defaultSrid, dimensionCount, hasZ, hasM);
            }
            case LINESTRING: {
                return this.readLineString(defaultSrid, dimensionCount, hasZ, hasM);
            }
            case POLYGON: {
                return this.readPolygon(defaultSrid, dimensionCount, hasZ, hasM);
            }
            case MULTI_POINT: {
                return this.readMultiPoint(defaultSrid, hasZ, hasM);
            }
            case MULTI_LINESTRING: {
                return this.readMultiLineString(defaultSrid, hasZ, hasM);
            }
            case MULTI_POLYGON: {
                return this.readMultiPolygon(defaultSrid, hasZ, hasM);
            }
            case GEOMETRY_COLLECTION: {
                return this.readGeometryCollection(defaultSrid, hasZ, hasM);
            }
        }
        throw new WkbParseException("Unsupported geometry type: " + String.valueOf((Object)geoType), typeStartPos, this.currentWkb);
    }

    private Point readPoint(int srid, int dimensionCount, boolean hasZ, boolean hasM) {
        double[] coords = new double[dimensionCount];
        for (int i = 0; i < dimensionCount; ++i) {
            coords[i] = this.readDoubleAllowEmpty();
        }
        return new Point(coords, srid, hasZ, hasM);
    }

    private Point readInternalPoint(int srid, int dimensionCount, boolean hasZ, boolean hasM) {
        double[] coords = new double[dimensionCount];
        for (int i = 0; i < dimensionCount; ++i) {
            coords[i] = this.readDoubleNoEmpty();
        }
        return new Point(coords, srid, hasZ, hasM);
    }

    private LineString readLineString(int srid, int dimensionCount, boolean hasZ, boolean hasM) {
        long numPointsPos = this.buffer.position();
        int numPoints = this.readInt();
        if (this.validationLevel > 0 && numPoints == 1) {
            throw new WkbParseException("Too few points in linestring", numPointsPos, this.currentWkb);
        }
        ArrayList<Point> points = new ArrayList<Point>(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            points.add(this.readInternalPoint(srid, dimensionCount, hasZ, hasM));
        }
        return new LineString(points, srid, hasZ, hasM);
    }

    private Ring readRing(int srid, int dimensionCount, boolean hasZ, boolean hasM) {
        long numPointsPos = this.buffer.position();
        int numPoints = this.readInt();
        ArrayList<Point> points = new ArrayList<Point>(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            Point p = this.readInternalPoint(srid, dimensionCount, hasZ, hasM);
            points.add(p);
        }
        Ring ring = new Ring(points);
        if (this.validationLevel > 0 && !ring.isClosed()) {
            throw new WkbParseException(numPoints < 4 ? "Too few points in ring" : "Ring is not closed", numPointsPos, this.currentWkb);
        }
        return ring;
    }

    private Polygon readPolygon(int srid, int dimensionCount, boolean hasZ, boolean hasM) {
        int numRings = this.readInt();
        ArrayList<Ring> rings = new ArrayList<Ring>(numRings);
        for (int i = 0; i < numRings; ++i) {
            rings.add(this.readRing(srid, dimensionCount, hasZ, hasM));
        }
        return new Polygon(rings, srid, hasZ, hasM);
    }

    private MultiPoint readMultiPoint(int srid, boolean hasZ, boolean hasM) {
        int numPoints = this.readInt();
        ArrayList<Point> points = new ArrayList<Point>(numPoints);
        for (int i = 0; i < numPoints; ++i) {
            GeometryModel geom = this.readNestedGeometryWithDimensionCheck(srid, hasZ, hasM);
            if (!(geom instanceof Point)) {
                throw new WkbParseException("Expected Point in MultiPoint", this.buffer.position(), this.currentWkb);
            }
            points.add((Point)geom);
        }
        return new MultiPoint(points, srid, hasZ, hasM);
    }

    private MultiLineString readMultiLineString(int srid, boolean hasZ, boolean hasM) {
        int numLineStrings = this.readInt();
        ArrayList<LineString> lineStrings = new ArrayList<LineString>(numLineStrings);
        for (int i = 0; i < numLineStrings; ++i) {
            GeometryModel geom = this.readNestedGeometryWithDimensionCheck(srid, hasZ, hasM);
            if (!(geom instanceof LineString)) {
                throw new WkbParseException("Expected LineString in MultiLineString", this.buffer.position(), this.currentWkb);
            }
            lineStrings.add((LineString)geom);
        }
        return new MultiLineString(lineStrings, srid, hasZ, hasM);
    }

    private MultiPolygon readMultiPolygon(int srid, boolean hasZ, boolean hasM) {
        int numPolygons = this.readInt();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(numPolygons);
        for (int i = 0; i < numPolygons; ++i) {
            GeometryModel geom = this.readNestedGeometryWithDimensionCheck(srid, hasZ, hasM);
            if (!(geom instanceof Polygon)) {
                throw new WkbParseException("Expected Polygon in MultiPolygon", this.buffer.position(), this.currentWkb);
            }
            polygons.add((Polygon)geom);
        }
        return new MultiPolygon(polygons, srid, hasZ, hasM);
    }

    private GeometryCollection readGeometryCollection(int srid, boolean hasZ, boolean hasM) {
        int numGeometries = this.readInt();
        ArrayList<GeometryModel> geometries = new ArrayList<GeometryModel>(numGeometries);
        for (int i = 0; i < numGeometries; ++i) {
            geometries.add(this.readNestedGeometryWithDimensionCheck(srid, hasZ, hasM));
        }
        return new GeometryCollection(geometries, srid, hasZ, hasM);
    }
}

