/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.catalyst.catalog.ArchiveResource$;
import org.apache.spark.sql.catalyst.catalog.FileResource$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceLoader;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceType;
import org.apache.spark.sql.catalyst.catalog.JarResource$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.util.DependencyUtils$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Unstable
@ScalaSignature(bytes="\u0006\u0005\u00054AAB\u0004\u0001%!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003.\u0001\u0011\u0005c\u0006C\u00038\u0001\u0011\u0005\u0001\bC\u0003X\u0001\u0011\u0005\u0001LA\u000bTKN\u001c\u0018n\u001c8SKN|WO]2f\u0019>\fG-\u001a:\u000b\u0005!I\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035}i\u0011a\u0007\u0006\u00039u\tqaY1uC2|wM\u0003\u0002\u001f\u0013\u0005A1-\u0019;bYf\u001cH/\u0003\u0002!7\t1b)\u001e8di&|gNU3t_V\u00148-\u001a'pC\u0012,'/A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015J\u0011aB2mCN\u001c\u0018nY\u0005\u0003O\u0011\u0012Ab\u00159be.\u001cVm]:j_:\fa\u0001P5oSRtDC\u0001\u0016-!\tY\u0003!D\u0001\b\u0011\u0015\t#\u00011\u0001#\u00031aw.\u00193SKN|WO]2f)\ty#\u0007\u0005\u0002\u0015a%\u0011\u0011'\u0006\u0002\u0005+:LG\u000fC\u00034\u0007\u0001\u0007A'\u0001\u0005sKN|WO]2f!\tQR'\u0003\u000277\t\u0001b)\u001e8di&|gNU3t_V\u00148-Z\u0001\fe\u0016\u001cx\u000e\u001c<f\u0015\u0006\u00148\u000f\u0006\u0002:\u001bB\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u0012\u0003\u0019a$o\\8u}%\ta#\u0003\u0002B+\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003V\u0001\"A\u0012&\u000f\u0005\u001dC\u0005C\u0001\u001f\u0016\u0013\tIU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%\u0016\u0011\u0015qE\u00011\u0001P\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016a\u00018fi*\tA+\u0001\u0003kCZ\f\u0017B\u0001,R\u0005\r)&+S\u0001\u0007C\u0012$'*\u0019:\u0015\u0005=J\u0006\"\u0002(\u0006\u0001\u0004)\u0005F\u0001\u0001\\!\tav,D\u0001^\u0015\tq6\"\u0001\u0006b]:|G/\u0019;j_:L!\u0001Y/\u0003\u0011Us7\u000f^1cY\u0016\u0004")
public class SessionResourceLoader
implements FunctionResourceLoader {
    private final SparkSession session;

    public void loadResource(FunctionResource resource) {
        FunctionResourceType functionResourceType = resource.resourceType();
        if (JarResource$.MODULE$.equals(functionResourceType)) {
            this.addJar(resource.uri());
            return;
        }
        if (FileResource$.MODULE$.equals(functionResourceType)) {
            this.session.sparkContext().addFile(resource.uri());
            return;
        }
        if (ArchiveResource$.MODULE$.equals(functionResourceType)) {
            this.session.sparkContext().addArchive(resource.uri());
            return;
        }
        throw new MatchError((Object)functionResourceType);
    }

    public Seq<String> resolveJars(URI path) {
        String string = path.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case 104684: {
                if (!"ivy".equals(string)) break;
                return DependencyUtils$.MODULE$.resolveMavenDependencies(path);
            }
        }
        String string2 = path.toString();
        return Nil$.MODULE$.$colon$colon((Object)string2);
    }

    public void addJar(String path) {
        URI uri = Utils$.MODULE$.resolveURI(path);
        this.resolveJars(uri).foreach((Function1 & Serializable)p -> {
            SessionResourceLoader.$anonfun$addJar$1(this, p);
            return BoxedUnit.UNIT;
        });
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.session.sharedState().jarClassLoader()));
    }

    public static final /* synthetic */ void $anonfun$addJar$1(SessionResourceLoader $this, String p) {
        $this.session.sparkContext().addJar(p);
        URI uri = new Path(p).toUri();
        URL jarURL = uri.getScheme() == null ? new File(p).toURI().toURL() : uri.toURL();
        $this.session.sharedState().jarClassLoader().addURL(jarURL);
    }

    public SessionResourceLoader(SparkSession session) {
        this.session = session;
    }
}

